/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.FwTaskConfigurationListener;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectTasksOptions", storages={@Storage(value="watcherTasks.xml")})
public class ProjectTasksOptions
extends TasksPersistentComponent {
    private final Project myProject;
    private volatile List<String> mySuppressedTaskNames = Collections.emptyList();
    private volatile Set<String> mySuppressedTaskNameSet = Collections.emptySet();
    private volatile Set<FileType> myConfiguredWatcherFileTypes = Collections.emptySet();
    private final List<FwTaskConfigurationListener> myTaskConfigurationListeners = ContainerUtil.createEmptyCOWList();

    public static ProjectTasksOptions getInstance(Project project) {
        return (ProjectTasksOptions)ServiceManager.getService((Project)project, ProjectTasksOptions.class);
    }

    public ProjectTasksOptions(Project project) {
        this.myProject = project;
    }

    public void addTaskConfigurationListener(@NotNull FwTaskConfigurationListener listener) {
        if (listener == null) {
            ProjectTasksOptions.$$$reportNull$$$0(0);
        }
        this.myTaskConfigurationListeners.add(listener);
    }

    @Override
    public void setTasks(List<Pair<TaskOptions, Boolean>> tasks) {
        super.setTasks(tasks);
        this.onTasksUpdated(tasks);
    }

    @Override
    public void addTask(TaskOptions options, boolean isEnabled) {
        super.addTask(options, isEnabled);
        this.onTasksUpdated(this.getTasks());
    }

    private void onTasksUpdated(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            ProjectTasksOptions.$$$reportNull$$$0(1);
        }
        this.myConfiguredWatcherFileTypes = ImmutableSet.copyOf((Collection)ContainerUtil.map(tasks, pair -> ((TaskOptions)pair.getFirst()).getFileType()));
        this.fireConfigurationEvents(tasks);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void fireConfigurationEvents(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            ProjectTasksOptions.$$$reportNull$$$0(2);
        }
        boolean hasEnabledTasks = ProjectTasksOptions.hasEnabledTasks(tasks);
        boolean hasEnabledTasksWithImmediateSync = ProjectTasksOptions.hasEnabledTasksWithImmediateSync(tasks);
        UIUtil.invokeLaterIfNeeded(() -> {
            for (FwTaskConfigurationListener listener : this.myTaskConfigurationListeners) {
                listener.taskConfigurationChanged(hasEnabledTasks, hasEnabledTasksWithImmediateSync);
            }
        });
    }

    public boolean hasEnabledTasks() {
        return ProjectTasksOptions.hasEnabledTasks(this.getTasks());
    }

    private static boolean hasEnabledTasks(@NotNull List<Pair<TaskOptions, Boolean>> tasks) {
        if (tasks == null) {
            ProjectTasksOptions.$$$reportNull$$$0(3);
        }
        for (Pair<TaskOptions, Boolean> task : tasks) {
            if (!Boolean.TRUE.equals(task.getSecond())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnabledTasksWithImmediateSync() {
        return ProjectTasksOptions.hasEnabledTasksWithImmediateSync(this.getTasks());
    }

    private static boolean hasEnabledTasksWithImmediateSync(@NotNull List<Pair<TaskOptions, Boolean>> pairs) {
        if (pairs == null) {
            ProjectTasksOptions.$$$reportNull$$$0(4);
        }
        for (Pair<TaskOptions, Boolean> pair : pairs) {
            if (!Boolean.TRUE.equals(pair.getSecond()) || !((TaskOptions)pair.getFirst()).isImmediateSync()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<String> getSuppressedTaskNames() {
        List<String> list = this.mySuppressedTaskNames;
        if (list == null) {
            ProjectTasksOptions.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public void setSuppressedTaskNames(@NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            ProjectTasksOptions.$$$reportNull$$$0(6);
        }
        ImmutableList immutableList = ImmutableList.copyOf(suppressedTaskNames);
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)immutableList);
        this.mySuppressedTaskNames = immutableList;
        this.mySuppressedTaskNameSet = immutableSet;
        if (immutableSet.size() != immutableList.size()) {
            ArrayList mutableCopy = ContainerUtil.newArrayList((Iterable)immutableList);
            ContainerUtil.removeDuplicates((Collection)mutableCopy);
            this.mySuppressedTaskNames = ImmutableList.copyOf((Collection)mutableCopy);
            this.mySuppressedTaskNameSet = ImmutableSet.copyOf((Collection)mutableCopy);
        }
    }

    @NotNull
    public List<TaskOptions> findTasksForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectTasksOptions.$$$reportNull$$$0(7);
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file) || Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"npm-debug.log", (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
            List<TaskOptions> list = Collections.emptyList();
            if (list == null) {
                ProjectTasksOptions.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<TaskOptions> result = null;
        for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
            TaskOptions options;
            boolean enabled = (Boolean)task.getSecond();
            if (!enabled || !(options = (TaskOptions)task.getFirst()).getFileScope(this.myProject).contains(file)) continue;
            if (result == null) {
                result = new ArrayList<TaskOptions>();
            }
            result.add(options);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            ProjectTasksOptions.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean containWatcherWithFileType(@NotNull FileType type) {
        if (type == null) {
            ProjectTasksOptions.$$$reportNull$$$0(10);
        }
        return this.myConfiguredWatcherFileTypes.contains(type);
    }

    public boolean isEnabled(String name) {
        Pair<TaskOptions, Boolean> taskByName = this.findTaskByName(name);
        return taskByName != null && (Boolean)taskByName.getSecond() != false;
    }

    @NotNull
    public FileWatchersState getWatchersState() {
        FileWatchersState fileWatchersState = new FileWatchersState(this.getTasks(), this.mySuppressedTaskNames);
        if (fileWatchersState == null) {
            ProjectTasksOptions.$$$reportNull$$$0(11);
        }
        return fileWatchersState;
    }

    public void setWatchersState(@NotNull FileWatchersState state) {
        if (state == null) {
            ProjectTasksOptions.$$$reportNull$$$0(12);
        }
        this.setTasks(state.getTasks());
        this.setSuppressedTaskNames((List<String>)state.getSuppressedTaskNames());
    }

    public boolean isSuppressedTaskName(@NotNull String taskName) {
        if (taskName == null) {
            ProjectTasksOptions.$$$reportNull$$$0(13);
        }
        return this.mySuppressedTaskNameSet.contains(taskName);
    }

    public void suppressTaskName(@NotNull String taskName) {
        if (taskName == null) {
            ProjectTasksOptions.$$$reportNull$$$0(14);
        }
        if (!this.isSuppressedTaskName(taskName)) {
            ArrayList list = ContainerUtil.newArrayList(this.mySuppressedTaskNames);
            list.add(taskName);
            this.setSuppressedTaskNames(list);
        }
    }

    public boolean containsTask(@NotNull TaskOptions taskOptions) {
        if (taskOptions == null) {
            ProjectTasksOptions.$$$reportNull$$$0(15);
        }
        List<Pair<TaskOptions, Boolean>> tasks = this.getTasks();
        for (Pair<TaskOptions, Boolean> taskPair : tasks) {
            if (!((TaskOptions)taskPair.getFirst()).equals(taskOptions)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/model/ProjectTasksOptions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedTaskNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/model/ProjectTasksOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressedTaskNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksForFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchersState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTaskConfigurationListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onTasksUpdated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fireConfigurationEvents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasEnabledTasks";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasEnabledTasksWithImmediateSync";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSuppressedTaskNames";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTasksForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containWatcherWithFileType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setWatchersState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedTaskName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "suppressTaskName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "containsTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

