/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import gnu.trove.THashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ApplicationTasksOptions", storages={@Storage(value="watcherDefaultTasks.xml")})
public class ApplicationTasksOptions
extends TasksPersistentComponent {
    public static ApplicationTasksOptions getInstance() {
        return (ApplicationTasksOptions)ServiceManager.getService(ApplicationTasksOptions.class);
    }

    public void addOrUpdate(List<Pair<TaskOptions, Boolean>> tasks) {
        THashMap map2index = new THashMap();
        List<Pair<TaskOptions, Boolean>> myTasks = this.getTasks();
        for (int i = 0; i < myTasks.size(); ++i) {
            Pair<TaskOptions, Boolean> optionsPair = myTasks.get(i);
            map2index.put(((TaskOptions)optionsPair.getFirst()).getName(), i);
        }
        for (Pair<TaskOptions, Boolean> optionsPair : tasks) {
            TaskOptions options = (TaskOptions)optionsPair.getFirst();
            Integer index = (Integer)map2index.get(options.getName());
            if (index == null) {
                map2index.put(options.getName(), myTasks.size());
                myTasks.add(optionsPair);
                continue;
            }
            myTasks.set(index, optionsPair);
        }
    }

    @Override
    @NotNull
    public List<String> getSuppressedTaskNames() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    public void setSuppressedTaskNames(@NotNull List<String> suppressedTaskNames) {
        if (suppressedTaskNames == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/model/ApplicationTasksOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressedTaskNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressedTaskNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/model/ApplicationTasksOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSuppressedTaskNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

