/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBoxListModelEditor;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchersPanel {
    private final Project myProject;
    private final JComponent myComponent;
    private final CheckBoxListModelEditor<TaskOptions> myEditor;
    private volatile ImmutableList<String> mySuppressedTaskNames;

    public WatchersPanel(final @NotNull Project project) {
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(0);
        }
        this.mySuppressedTaskNames = ImmutableList.of();
        this.myProject = project;
        this.myEditor = new CheckBoxListModelEditor(TaskOptions::getName, BackgroundTaskBundle.message("settings.no.watchers.configured", new Object[0]));
        this.myEditor.getList().setSelectionMode(2);
        this.myComponent = this.myEditor.editAction(item -> {
            NewWatcherDialog dialog = new NewWatcherDialog(this.myProject, (TaskOptions)item, BackgroundTaskBundle.message("edit.task", new Object[0]));
            return dialog.showAndGet() ? dialog.getTaskOptions() : null;
        }).copyAction(item -> {
            TaskOptions options = item.createCopy();
            options.setName(options.getName() + " Copy");
            this.editOptionsAndAdd(options);
        }).getToolbar().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                WatchersPanel.suggestOptions(project, button, (Processor<TaskOptions>)options -> {
                    WatchersPanel.this.editOptionsAndAdd(options);
                    return false;
                });
            }
        }).addExtraAction((AnActionButton)new ImportWatchersActionButton()).addExtraAction((AnActionButton)new ExportWatchersActionButton()).createPanel();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void editOptionsAndAdd(TaskOptions options) {
        NewWatcherDialog dialog = new NewWatcherDialog(this.myProject, options, BackgroundTaskBundle.message("new.task", new Object[0]));
        if (dialog.showAndGet()) {
            this.insertNewTool(dialog.getTaskOptions(), true);
        }
        this.myEditor.getList().repaint();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getList(), true));
    }

    private static void suggestOptions(@NotNull Project project, AnActionButton button, Processor<TaskOptions> processor) {
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(1);
        }
        ArrayList<Pair> optionsList = new ArrayList<Pair>(ContainerUtil.map((Object[])BackgroundTaskConsumer.EP_NAME.getExtensions(), consumer -> Pair.create((Object)consumer.getOptionsTemplate(), (Object)consumer)));
        TaskOptions emptyOptions = new TaskOptions();
        emptyOptions.setTrackOnlyRoot(false);
        Collections.sort(optionsList, (o1, o2) -> StringUtil.compare((String)((TaskOptions)o1.getFirst()).getName(), (String)((TaskOptions)o2.getFirst()).getName(), (boolean)true));
        optionsList.add(0, Pair.create((Object)emptyOptions, null));
        if (!optionsList.isEmpty()) {
            JBList list = new JBList(optionsList);
            list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    Pair pair = (Pair)value;
                    String description = ((TaskOptions)pair.getFirst()).getDescription();
                    this.setText(WatchersPanel.extractName((Pair<TaskOptions, BackgroundTaskConsumer>)pair));
                    if (!StringUtil.isEmpty((String)description)) {
                        this.setToolTipText(description);
                    }
                    this.setBorder(JBUI.Borders.empty((int)3));
                    this.setIcon(((TaskOptions)pair.getFirst()).getFileType().getIcon());
                    return result;
                }
            });
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Template").setMovable(true).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> WatchersPanel.lambda$suggestOptions$5((JList)list, project, processor)).setFilteringEnabled(o -> WatchersPanel.extractName((Pair<TaskOptions, BackgroundTaskConsumer>)((Pair)o))).createPopup();
            RelativePoint preferredPopupPoint = button.getPreferredPopupPoint();
            if (preferredPopupPoint != null) {
                popup.show(preferredPopupPoint);
            } else {
                popup.showInBestPositionFor(button.getDataContext());
            }
        } else {
            processor.process((Object)emptyOptions);
        }
    }

    private static String extractName(Pair<TaskOptions, BackgroundTaskConsumer> pair) {
        String name = ((TaskOptions)pair.getFirst()).getName();
        return StringUtil.isEmpty((String)name) ? "<custom>" : name;
    }

    public void selectTaskByName(@NotNull String taskOptionsName) {
        if (taskOptionsName == null) {
            WatchersPanel.$$$reportNull$$$0(2);
        }
        this.myEditor.selectItemByName(taskOptionsName);
    }

    @NotNull
    public FileWatchersState getState() {
        List tasks = this.myEditor.apply();
        FileWatchersState fileWatchersState = new FileWatchersState(tasks, (List<String>)this.mySuppressedTaskNames);
        if (fileWatchersState == null) {
            WatchersPanel.$$$reportNull$$$0(3);
        }
        return fileWatchersState;
    }

    public boolean isModified() {
        return this.myEditor.isModified(ProjectTasksOptions.getInstance(this.myProject).getTasks());
    }

    public void reset(@NotNull FileWatchersState state) {
        if (state == null) {
            WatchersPanel.$$$reportNull$$$0(4);
        }
        this.myEditor.reset(state.getTasks());
        this.mySuppressedTaskNames = state.getSuppressedTaskNames();
    }

    private void insertNewTool(TaskOptions options, boolean select) {
        this.myEditor.getList().addItem((Object)options, options.getName(), select);
    }

    @NotNull
    private static String getDefaultExportFilePath() {
        String string = SystemProperties.getUserHome() + "/watchers.xml";
        if (string == null) {
            WatchersPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void lambda$suggestOptions$5(JList list, @NotNull Project project, Processor processor) {
        Pair pair;
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(6);
        }
        if ((pair = (Pair)list.getSelectedValue()) == null) {
            return;
        }
        TaskOptions options = (TaskOptions)pair.getFirst();
        BackgroundTaskConsumer consumer = (BackgroundTaskConsumer)pair.getSecond();
        if (consumer != null) {
            Pair<TaskOptions, Boolean> lastTask = ApplicationTasksOptions.getInstance().findTaskByName(options.getName());
            TaskOptions lastOptions = lastTask != null ? (TaskOptions)lastTask.getFirst() : null;
            consumer.additionalConfiguration(project, null, options);
            consumer.configureWithLastOptions(options, lastOptions);
        }
        processor.process((Object)options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskOptionsName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/ui/WatchersPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExportFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "suggestOptions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectTaskByName";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestOptions$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExportWatchersActionButton
    extends AnActionButton {
        private ExportWatchersActionButton() {
            super("Export", PlatformIcons.EXPORT_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportWatchersActionButton.$$$reportNull$$$0(0);
            }
            ChooseOptionsToExportDialog dialog = new ChooseOptionsToExportDialog();
            dialog.show();
            List<TaskOptions> elements = dialog.getMarkedElements();
            if (!dialog.isOK() || elements.isEmpty()) {
                return;
            }
            Element root = TasksPersistentComponent.getElement(ContainerUtil.map(elements, options -> Pair.create((Object)options, null)), Collections.emptyList());
            try {
                int yesNo;
                File exportFile = dialog.getExportFile();
                if (exportFile.exists() && (yesNo = Messages.showYesNoDialog((String)BackgroundTaskBundle.message("watcher.export.overwrite.file", new Object[0]), (String)BackgroundTaskBundle.message("watcher.export", new Object[0]), null)) == 1) {
                    return;
                }
                JDOMUtil.write((Parent)root, (File)exportFile, (String)SystemProperties.getLineSeparator());
                LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(exportFile), true, false, null);
            }
            catch (IOException ex) {
                Messages.showErrorDialog((String)ex.getMessage(), (String)"Error");
                return;
            }
            Messages.showInfoMessage((String)BackgroundTaskBundle.message("watcher.export.successfully", new Object[0]), (String)"Info");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/watcher/config/ui/WatchersPanel$ExportWatchersActionButton", "actionPerformed"));
        }

        public class ChooseOptionsToExportDialog
        extends DialogWrapper {
            private final ElementsChooser<TaskOptions> myChooser;
            private final FieldPanel myFieldPanel;

            protected ChooseOptionsToExportDialog() {
                super(WatchersPanel.this.myProject);
                this.myChooser = new ElementsChooser<TaskOptions>(WatchersPanel.this.myEditor.getItems(), true){

                    protected String getItemText(@NotNull TaskOptions value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return value.getName();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/plugins/watcher/config/ui/WatchersPanel$ExportWatchersActionButton$ChooseOptionsToExportDialog$1", "getItemText"));
                    }
                };
                this.myChooser.setColorUnmarkedElements(false);
                this.myFieldPanel = new FieldPanel("Export watchers to:", null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
                        chooserDescriptor.setDescription(BackgroundTaskBundle.message("watcher.export.choose.file.description", new Object[0]));
                        chooserDescriptor.setHideIgnored(false);
                        chooserDescriptor.setTitle(BackgroundTaskBundle.message("watcher.choose.file.or.dir", new Object[0]));
                        FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)WatchersPanel.this.myProject, null, file -> {
                            String path = file.getPath();
                            if (file.isDirectory()) {
                                path = path + "/watchers.xml";
                            }
                            ChooseOptionsToExportDialog.this.myFieldPanel.setText(FileUtil.toSystemIndependentName((String)path));
                        });
                    }
                }, null);
                this.myFieldPanel.setText(FileUtil.toSystemDependentName((String)WatchersPanel.getDefaultExportFilePath()));
                this.setTitle(BackgroundTaskBundle.message("watcher.export", new Object[0]));
                this.setOKButtonText("Save");
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return this.myChooser;
            }

            @Nullable
            protected JComponent createNorthPanel() {
                return this.myFieldPanel;
            }

            public List<TaskOptions> getMarkedElements() {
                return this.myChooser.getMarkedElements();
            }

            public File getExportFile() {
                return new File(FileUtil.toSystemDependentName((String)this.myFieldPanel.getText()));
            }
        }
    }

    private class ImportWatchersActionButton
    extends AnActionButton {
        private ImportWatchersActionButton() {
            super("Import", PlatformIcons.IMPORT_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportWatchersActionButton.$$$reportNull$$$0(0);
            }
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)StdFileTypes.XML);
            chooserDescriptor.setHideIgnored(false);
            chooserDescriptor.setTitle(BackgroundTaskBundle.message("watcher.import.choose.file", new Object[0]));
            VirtualFile toSelect = LocalFileSystem.getInstance().findFileByPath(WatchersPanel.getDefaultExportFilePath());
            if (toSelect == null) {
                toSelect = LocalFileSystem.getInstance().findFileByPath(PathUtil.getParentPath((String)WatchersPanel.getDefaultExportFilePath()));
            }
            FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)WatchersPanel.this.myProject, (VirtualFile)toSelect, file -> {
                file.refresh(false, false);
                try {
                    Document document = JDOMUtil.loadDocument((InputStream)file.getInputStream());
                    DefaultListModel listModel = WatchersPanel.this.myEditor.getModel();
                    THashMap nameToElement = new THashMap();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        nameToElement.put(((TaskOptions)WatchersPanel.this.myEditor.getList().getItemAt(i)).getName(), listModel.get(i));
                    }
                    FileWatchersState stateToImport = TasksPersistentComponent.getTaskOptions(document.getRootElement());
                    List<Pair<TaskOptions, Boolean>> taskOptionsToImport = stateToImport.getTasks();
                    if (taskOptionsToImport.isEmpty()) {
                        Messages.showInfoMessage((String)BackgroundTaskBundle.message("watcher.import.empty", new Object[0]), (String)"Info");
                        return;
                    }
                    for (Pair<TaskOptions, Boolean> pair : taskOptionsToImport) {
                        TaskOptions options = (TaskOptions)pair.getFirst();
                        if (nameToElement.containsKey(options.getName())) {
                            if (Messages.showYesNoDialog((String)BackgroundTaskBundle.message("watcher.import.replace", options.getName()), (String)BackgroundTaskBundle.message("watcher.import", new Object[0]), null) != 0) continue;
                            listModel.removeElement(nameToElement.get(options.getName()));
                        }
                        WatchersPanel.this.insertNewTool(options, true);
                    }
                }
                catch (JDOMException ex) {
                    Messages.showErrorDialog((String)ex.getMessage(), (String)"Error");
                }
                catch (IOException ex) {
                    Messages.showErrorDialog((String)ex.getMessage(), (String)"Error");
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/watcher/config/ui/WatchersPanel$ImportWatchersActionButton", "actionPerformed"));
        }
    }
}

