/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.FileWatchersState;
import com.intellij.plugins.watcher.config.ui.WatchersPanel;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.ui.EditorNotifications;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchersConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private WatchersPanel myPanel;

    public WatchersConfigurable(@NotNull Project project) {
        if (project == null) {
            WatchersConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String getDisplayName() {
        return BackgroundTaskBundle.message("settings.name", new Object[0]);
    }

    @NotNull
    public String getId() {
        if ("watcher.settings" == null) {
            WatchersConfigurable.$$$reportNull$$$0(1);
        }
        return "watcher.settings";
    }

    public String getHelpTopic() {
        return "settings.project.settings.file.watchers";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new WatchersPanel(this.myProject);
        }
        return this.myPanel.getComponent();
    }

    public WatchersPanel getPanel() {
        this.createComponent();
        return this.myPanel;
    }

    public boolean isModified() {
        FileWatchersState savedState;
        if (this.myPanel == null) {
            return false;
        }
        FileWatchersState uiState = this.myPanel.getState();
        return !uiState.equals(savedState = ProjectTasksOptions.getInstance(this.myProject).getWatchersState());
    }

    public void apply() {
        if (this.myPanel != null) {
            FileWatchersState state = this.myPanel.getState();
            ProjectTasksOptions.getInstance(this.myProject).setWatchersState(state);
            ApplicationTasksOptions.getInstance().addOrUpdate(state.getTasks());
            EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        }
    }

    public void reset() {
        if (this.myPanel != null) {
            FileWatchersState savedState = ProjectTasksOptions.getInstance(this.myProject).getWatchersState();
            this.myPanel.reset(savedState);
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/WatchersConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/WatchersConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

