/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.TaskProblemsHolder;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.BackgroundTaskFilterFactory;
import com.intellij.plugins.watcher.config.FileDependencyFinder;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.OutputFilesHandler;
import com.intellij.plugins.watcher.config.WatchersConfigurable;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.plugins.watcher.problems.TaskProblemFinder;
import com.intellij.plugins.watcher.util.HistoryProcessListener;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.plugins.watcher.util.WatchedFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class TaskRunnerImpl
extends TaskRunner {
    private static final Logger LOG = Logger.getInstance(TaskRunner.class);
    private static final Key<Pair<TaskOptions, VirtualFile>> TASK_AND_FILE_KEY = Key.create((String)"task.and.file.key");
    private static final int MAX_RUNNING_JOBS = 10;
    private static final int FILE_INDEPENDENT_WATCHER_DELAY = 1000;
    private final ConcurrentMap<VirtualFile, Pair<DataContext, List<TaskOptions>>> jobsInProgress = ContainerUtil.newConcurrentMap();
    private final ConcurrentLinkedQueue<Pair<DataContext, List<TaskOptions>>> jobsInQueue = new ConcurrentLinkedQueue();
    private final TaskProblemsHolder myProblemsHolder = new TaskProblemsHolder();
    private final Set<String> myFilesInRefreshState = ContainerUtil.newConcurrentSet();
    private final Alarm myTasksScheduler = new Alarm(ApplicationManager.getApplication().isUnitTestMode() ? Alarm.ThreadToUse.SWING_THREAD : Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
    private final Map<List<TaskOptions>, Runnable> myFileIndependentTasksToRunnableMap = Collections.synchronizedMap(new THashMap());
    private final AtomicInteger myPendingRefreshes = new AtomicInteger(0);
    private volatile boolean myBatchFileChangeInProgress;

    public TaskRunnerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(@NotNull Project project, @Nullable String activityName) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                TaskRunnerImpl.this.myBatchFileChangeInProgress = true;
            }

            public void batchChangeCompleted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                TaskRunnerImpl.this.myBatchFileChangeInProgress = false;
                TaskRunnerImpl.this.processQueue();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public TaskProblemsHolder getProblemsHolder() {
        return this.myProblemsHolder;
    }

    @Override
    public boolean inRefreshState(@NotNull String fileUrl) {
        if (fileUrl == null) {
            TaskRunnerImpl.$$$reportNull$$$0(0);
        }
        return this.myFilesInRefreshState.contains(fileUrl);
    }

    @Override
    public void runTasksForFile(DataContext mainDataContext, List<TaskOptions> allOptions) {
        ArrayList<TaskOptions> fileSpecificOptions = new ArrayList<TaskOptions>(allOptions.size());
        ArrayList<TaskOptions> fileIndependentOptions = new ArrayList<TaskOptions>(allOptions.size());
        for (TaskOptions task : allOptions) {
            if (TaskRunnerImpl.dependOnFile(task)) {
                fileSpecificOptions.add(task);
                continue;
            }
            fileIndependentOptions.add(task);
        }
        if (!fileIndependentOptions.isEmpty()) {
            Runnable oldRunnable = this.myFileIndependentTasksToRunnableMap.remove(fileIndependentOptions);
            if (oldRunnable != null) {
                this.myTasksScheduler.cancelRequest(oldRunnable);
            }
            Runnable newRunnable = () -> {
                this.myFileIndependentTasksToRunnableMap.remove(fileIndependentOptions);
                this.doRunTasksForFile(mainDataContext, fileIndependentOptions);
            };
            this.myFileIndependentTasksToRunnableMap.put(fileIndependentOptions, newRunnable);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.myTasksScheduler.addRequest(newRunnable, 1000);
            } else {
                newRunnable.run();
            }
        }
        if (!fileSpecificOptions.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.myTasksScheduler.addRequest(() -> this.doRunTasksForFile(mainDataContext, fileSpecificOptions), 0);
            } else {
                this.doRunTasksForFile(mainDataContext, fileSpecificOptions);
            }
        }
    }

    @Override
    public boolean isBusy() {
        return !this.myTasksScheduler.isEmpty() || !this.jobsInProgress.isEmpty() || !this.jobsInQueue.isEmpty() || this.myPendingRefreshes.get() > 0;
    }

    private void doRunTasksForFile(DataContext mainDataContext, List<TaskOptions> allOptions) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(mainDataContext);
        assert (project != null);
        if (project.isDisposed()) {
            return;
        }
        VirtualFile initialFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(mainDataContext);
        if (initialFile == null || !initialFile.isValid()) {
            return;
        }
        LOG.debug(this.jobsInProgress.size() + " jobs are running at the moment.");
        Map<VirtualFile, List<TaskOptions>> data = TaskRunnerImpl.computeFilesAndTasksToPerform(project, initialFile, allOptions);
        for (Map.Entry<VirtualFile, List<TaskOptions>> entry : data.entrySet()) {
            VirtualFile file = entry.getKey();
            List<TaskOptions> options = entry.getValue();
            Map<String, VirtualFile> fileMap = Collections.singletonMap(CommonDataKeys.VIRTUAL_FILE.getName(), file);
            DataContext dataContext = SimpleDataContext.getSimpleContext(fileMap, (DataContext)mainDataContext);
            Pair job = Pair.create((Object)dataContext, options);
            if (this.myBatchFileChangeInProgress || this.jobsInProgress.size() >= 10) {
                LOG.debug("Suspend " + file.getName());
                this.jobsInQueue.add((Pair<DataContext, List<TaskOptions>>)job);
                continue;
            }
            if (this.jobsInProgress.put(file, (Pair<DataContext, List<TaskOptions>>)job) == null) {
                this.runTasksForFileImpl((Pair<DataContext, List<TaskOptions>>)job);
                continue;
            }
            LOG.debug("Queue " + file.getName());
        }
    }

    private static Map<VirtualFile, List<TaskOptions>> computeFilesAndTasksToPerform(@NotNull Project project, @NotNull VirtualFile initialFile, @NotNull List<TaskOptions> options) {
        if (project == null) {
            TaskRunnerImpl.$$$reportNull$$$0(1);
        }
        if (initialFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(2);
        }
        if (options == null) {
            TaskRunnerImpl.$$$reportNull$$$0(3);
        }
        THashMap result = new THashMap();
        for (TaskOptions option : options) {
            String optionName = StringUtil.notNullize((String)option.getName());
            if (!TaskRunnerImpl.dependOnFile(option)) {
                if (optionName.equals(TaskUtils.extractCreatedTaskName(initialFile))) continue;
                LOG.debug("Options don't depend on any file " + options.toString());
                if (option.isCheckSyntaxErrors() && PsiErrorElementUtil.hasErrors((Project)project, (VirtualFile)initialFile)) {
                    LOG.debug(initialFile.getName() + " has syntax errors. Skip task " + optionName);
                    continue;
                }
                TaskRunnerImpl.addTask((Map<VirtualFile, List<TaskOptions>>)result, initialFile, option);
                continue;
            }
            List<VirtualFile> roots = TaskUtils.findRoots(initialFile, project, option);
            for (VirtualFile rootFile : roots) {
                if (optionName.equals(TaskUtils.extractCreatedTaskName(rootFile))) continue;
                if (option.isCheckSyntaxErrors() && PsiErrorElementUtil.hasErrors((Project)project, (VirtualFile)rootFile)) {
                    LOG.debug(rootFile.getName() + " has syntax errors. Skip task " + optionName);
                    continue;
                }
                TaskRunnerImpl.addTask((Map<VirtualFile, List<TaskOptions>>)result, rootFile, option);
            }
        }
        return result;
    }

    private static boolean dependOnFile(TaskOptions option) {
        String fileBasedMacroPrefix = "$File";
        return StringUtil.notNullize((String)option.getArguments()).contains(fileBasedMacroPrefix) || StringUtil.notNullize((String)option.getWorkingDir()).contains(fileBasedMacroPrefix);
    }

    private static void addTask(Map<VirtualFile, List<TaskOptions>> result, VirtualFile file, TaskOptions option) {
        List<TaskOptions> options = result.get(file);
        if (options == null) {
            options = new ArrayList<TaskOptions>();
            result.put(file, options);
        }
        options.add(option);
    }

    private void runTasksForFileImpl(@Nullable Pair<DataContext, List<TaskOptions>> job) {
        if (job == null) {
            return;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataContext)job.getFirst());
        if (file == null) {
            return;
        }
        if (!file.isValid()) {
            this.jobsInProgress.remove(file);
            return;
        }
        LOG.debug("Run tasks " + TaskUtils.getPresentableNames((List)job.getSecond()) + " for " + file.getName());
        AtomicInteger tasksToFinish = new AtomicInteger(((List)job.getSecond()).size());
        for (TaskOptions taskOptions : (List)job.getSecond()) {
            FileTypeBackgroundTaskConsumer consumer;
            if (TaskRunnerImpl.dependOnFile(taskOptions) && (consumer = BackgroundTaskConsumer.findConsumerByFileType(file.getFileType())) != null && !consumer.isAvailable(file, taskOptions.getEnvData())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skip task " + taskOptions.getName() + " for " + file.getName());
                }
                Runnable removeJob = this.createRemoveJob(file, job, tasksToFinish);
                removeJob.run();
                continue;
            }
            try {
                this.runTask(file, job, taskOptions, tasksToFinish);
            }
            catch (Throwable e) {
                LOG.info("Cannot run " + taskOptions.getName() + " file watcher", e);
            }
        }
    }

    @NotNull
    private Runnable createRemoveJob(@NotNull VirtualFile file, @NotNull Pair<DataContext, List<TaskOptions>> job, @NotNull AtomicInteger tasksToFinish) {
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(4);
        }
        if (job == null) {
            TaskRunnerImpl.$$$reportNull$$$0(5);
        }
        if (tasksToFinish == null) {
            TaskRunnerImpl.$$$reportNull$$$0(6);
        }
        Runnable runnable = () -> {
            if (tasksToFinish == null) {
                TaskRunnerImpl.$$$reportNull$$$0(20);
            }
            if (file == null) {
                TaskRunnerImpl.$$$reportNull$$$0(21);
            }
            if (job == null) {
                TaskRunnerImpl.$$$reportNull$$$0(22);
            }
            if (tasksToFinish.decrementAndGet() > 0) {
                return;
            }
            if (!this.jobsInProgress.remove(file, job)) {
                LOG.debug(file.getName() + " is dirty. Rerun job.");
                Pair lastJob = (Pair)this.jobsInProgress.get(file);
                this.runTasksForFileImpl((Pair<DataContext, List<TaskOptions>>)lastJob);
            } else if (!this.myBatchFileChangeInProgress) {
                this.processQueue();
            }
        };
        if (runnable == null) {
            TaskRunnerImpl.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    private void processQueue() {
        while (!this.jobsInQueue.isEmpty() && this.jobsInProgress.size() < 10) {
            VirtualFile virtualFile;
            Pair<DataContext, List<TaskOptions>> jobInQueue = this.jobsInQueue.poll();
            if (jobInQueue == null || (virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataContext)jobInQueue.getFirst())) == null) continue;
            LOG.debug("Resume job " + virtualFile.getName());
            if (this.jobsInProgress.put(virtualFile, jobInQueue) != null) continue;
            this.runTasksForFileImpl(jobInQueue);
        }
    }

    private void runTask(final @NotNull VirtualFile file, Pair<DataContext, List<TaskOptions>> job, final TaskOptions taskOptions, AtomicInteger tasksToFinish) {
        GeneralCommandLine commandLine;
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(8);
        }
        final DataContext dataContext = (DataContext)job.getFirst();
        final Runnable removeJob = this.createRemoveJob(file, job, tasksToFinish);
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            LOG.warn("No project!");
            removeJob.run();
            return;
        }
        try {
            commandLine = TaskRunnerImpl.createCommandLine(dataContext, taskOptions);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            TaskRunnerImpl.disableWatcherAndNotify(e, project, taskOptions);
            removeJob.run();
            return;
        }
        File workingIoDir = commandLine.getWorkDirectory();
        final VirtualFile workingDir = workingIoDir != null ? LocalFileSystem.getInstance().findFileByIoFile(workingIoDir) : null;
        LOG.debug("Run task " + taskOptions.getName() + " for " + file.getName());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    removeJob.run();
                    return;
                }
                new Task.Backgroundable(project, "Executing Tasks", true){
                    private ProcessOutput output;
                    private CapturingProcessHandler myProcessHandler;
                    private HistoryProcessListener myHistoryProcessListener;
                    {
                        this.output = null;
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator.setText("Executing '" + taskOptions.getName() + "' task...");
                        indicator.setIndeterminate(true);
                        try {
                            this.myProcessHandler = new CapturingProcessHandler(commandLine);
                            ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
                            this.myHistoryProcessListener = new HistoryProcessListener();
                            this.myProcessHandler.addProcessListener((ProcessListener)this.myHistoryProcessListener);
                            this.output = this.myProcessHandler.runProcessWithProgressIndicator(indicator);
                        }
                        catch (ExecutionException e) {
                            LOG.info((Throwable)e);
                            TaskRunnerImpl.disableWatcherAndNotify((Exception)((Object)e), project, taskOptions);
                        }
                    }

                    public void onSuccess() {
                        if (!project.isDisposed()) {
                            TransactionGuard.submitTransaction((Disposable)project, this::handleSuccess);
                        }
                        removeJob.run();
                    }

                    public void handleSuccess() {
                        if (this.output == null) {
                            return;
                        }
                        LOG.debug(commandLine.getCommandLineString() + " exited with exit code: " + this.output.getExitCode());
                        LOG.debug(this.output.getStdout());
                        LOG.debug(this.output.getStderr());
                        if (taskOptions.getOutputFilters().length > 0 && file.isValid()) {
                            TaskRunnerImpl.this.processFilters(project, this.output, taskOptions, file, workingDir);
                        }
                        this.showOrHideRunWindowIfNeeded();
                        List outputFiles = (List)WriteAction.compute(() -> {
                            try {
                                return this.refreshOutputFiles(TaskRunnerImpl.isBadExitCode(this.output));
                            }
                            catch (Macro.ExecutionCancelledException e) {
                                LOG.debug((Throwable)e);
                                TaskRunnerImpl.disableWatcherAndNotify((Exception)((Object)e), project, taskOptions);
                                return Collections.emptyList();
                            }
                        });
                        for (OutputFilesHandler outputFilesHandler : (OutputFilesHandler[])OutputFilesHandler.EP_NAME.getExtensions()) {
                            outputFilesHandler.handleRefresh(dataContext, file, taskOptions, outputFiles);
                        }
                        this.updateOutputFilesOfDependencies();
                    }

                    private void showOrHideRunWindowIfNeeded() {
                        if (this.myProject == null || this.myProject.isDisposed()) {
                            return;
                        }
                        Pair taskAndFilePair = Pair.create((Object)taskOptions, (Object)file);
                        if (taskOptions.getExitCodeBehavior() == TaskOptions.ExitCodeBehavior.ALWAYS || TaskRunnerImpl.isBadExitCode(this.output) && taskOptions.getExitCodeBehavior() == TaskOptions.ExitCodeBehavior.ERROR) {
                            ColoredProcessHandler handler = new ColoredProcessHandler(this.myProcessHandler.getProcess(), commandLine.getCommandLineString());
                            handler.putUserData(TASK_AND_FILE_KEY, (Object)taskAndFilePair);
                            RunContentExecutor runContentExecutor = new RunContentExecutor(project, (ProcessHandler)handler);
                            runContentExecutor = runContentExecutor.withActivateToolWindow(false);
                            for (BackgroundTaskFilterFactory backgroundTaskFilterFactory : (BackgroundTaskFilterFactory[])BackgroundTaskFilterFactory.EP_NAME.getExtensions()) {
                                Filter filter = backgroundTaskFilterFactory.createFilter(project, file, workingDir);
                                if (filter == null) continue;
                                runContentExecutor = runContentExecutor.withFilter(filter);
                            }
                            for (BackgroundTaskFilterFactory backgroundTaskFilterFactory : taskOptions.getOutputFilters()) {
                                TaskProblemFinder taskProblemFinder = new TaskProblemFinder(backgroundTaskFilterFactory.getRegExp(), taskOptions.getOutputSettings());
                                runContentExecutor = runContentExecutor.withFilter(taskProblemFinder.getFilter(project, workingDir, file));
                            }
                            runContentExecutor.run();
                            Disposer.register((Disposable)this.myProject, (Disposable)runContentExecutor);
                            this.myHistoryProcessListener.apply((ProcessHandler)handler);
                        } else {
                            RunContentDescriptor runContentDescriptor = (RunContentDescriptor)ContainerUtil.find((Iterable)ExecutionManager.getInstance((Project)this.myProject).getContentManager().getAllDescriptors(), descriptor -> {
                                ProcessHandler processHandler = descriptor.getProcessHandler();
                                if (processHandler == null) {
                                    return false;
                                }
                                Pair data = (Pair)processHandler.getUserData(TASK_AND_FILE_KEY);
                                if (data != null && ((VirtualFile)data.getSecond()).equals(taskAndFilePair.getSecond())) {
                                    if (((TaskOptions)data.getFirst()).equals(taskAndFilePair.getFirst())) {
                                        return true;
                                    }
                                    if (!ProjectTasksOptions.getInstance(project).containsTask((TaskOptions)data.getFirst())) {
                                        return true;
                                    }
                                }
                                return false;
                            });
                            if (runContentDescriptor != null) {
                                RunContentManager runContentManager = ExecutionManager.getInstance((Project)project).getContentManager();
                                Executor executor = DefaultRunExecutor.getRunExecutorInstance();
                                runContentManager.removeRunContent(executor, runContentDescriptor);
                            }
                        }
                    }

                    public void onCancel() {
                        super.onCancel();
                        removeJob.run();
                    }

                    private List<VirtualFile> refreshOutputFiles(boolean badExitCode) throws Macro.ExecutionCancelledException {
                        String pathToWrite;
                        String pathToWritePath;
                        String workingDirPath = TaskRunnerImpl.expandMacros(taskOptions.getWorkingDir(), dataContext);
                        String[] outputPaths = taskOptions.getOutput().split(":");
                        if (!badExitCode && taskOptions.isOutputFromStdout() && outputPaths.length > 0 && (pathToWritePath = TaskRunnerImpl.getOutputFilePath(file, workingDirPath, pathToWrite = TaskRunnerImpl.expandMacros(outputPaths[0], dataContext))) != null) {
                            File fileToRefresh = new File(FileUtil.toSystemDependentName((String)pathToWritePath));
                            try {
                                FileUtil.writeToFile((File)fileToRefresh, (String)this.output.getStdout());
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                        ArrayList<VirtualFile> outputFiles = new ArrayList<VirtualFile>(outputPaths.length);
                        for (String outputFilePath : outputPaths) {
                            VirtualFile outputFile = TaskRunnerImpl.this.refreshOutput(file, workingDirPath, outputFilePath = TaskRunnerImpl.expandMacros(outputFilePath, dataContext), taskOptions.getName(), (Project)CommonDataKeys.PROJECT.getData(dataContext));
                            if (outputFile == null) continue;
                            outputFiles.add(outputFile);
                        }
                        return outputFiles;
                    }

                    private void updateOutputFilesOfDependencies() {
                        if (project.isDisposed()) {
                            return;
                        }
                        String extension = file.getExtension();
                        GlobalSearchScope scope = taskOptions.getFileScope(project);
                        for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
                            if (!dependencyFinder.updateGeneratedFilesOfDependencies() || !dependencyFinder.accept(extension)) continue;
                            dependencyFinder.findDependenciesAsync(project, file, scope, true, (Consumer<Set<VirtualFile>>)((Consumer)dependencies -> this.handleOutputFilesOfDependencies((Set<VirtualFile>)dependencies)));
                            break;
                        }
                    }

                    private void handleOutputFilesOfDependencies(@NotNull Set<VirtualFile> dependencies) {
                        if (dependencies == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (dependencies.isEmpty()) {
                            return;
                        }
                        ArrayList watchedFiles = ContainerUtil.newArrayList();
                        for (VirtualFile dependency : dependencies) {
                            try {
                                WatchedFile watchedFile = this.createWatchedFile(dependency);
                                watchedFiles.add(watchedFile);
                            }
                            catch (Macro.ExecutionCancelledException e) {
                                LOG.debug((Throwable)e);
                                TaskRunnerImpl.disableWatcherAndNotify((Exception)((Object)e), project, taskOptions);
                                return;
                            }
                        }
                        ArrayList filesToRefresh = ContainerUtil.newArrayList();
                        VirtualFileManager fileManager = VirtualFileManager.getInstance();
                        ArrayList foundFilesToRefresh = ContainerUtil.newArrayList();
                        for (WatchedFile watchedFile : watchedFiles) {
                            for (WatchedFile.GeneratedFile generatedFile : watchedFile.getGeneratedFiles()) {
                                VirtualFile file = fileManager.findFileByUrl(generatedFile.getUrl());
                                if (file != null && file.isValid()) {
                                    generatedFile.setFile(file);
                                    foundFilesToRefresh.add(file);
                                    continue;
                                }
                                filesToRefresh.add(generatedFile);
                            }
                        }
                        RefreshQueue.getInstance().refresh(true, true, null, (Collection)foundFilesToRefresh);
                        Runnable update = () -> {
                            if (file == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            ArrayList outputFiles = ContainerUtil.newArrayList();
                            for (WatchedFile watchedFile : watchedFiles) {
                                VirtualFile sourceFile = watchedFile.getSourceFile();
                                for (WatchedFile.GeneratedFile generatedFile : watchedFile.getGeneratedFiles()) {
                                    VirtualFile file12 = generatedFile.getFile();
                                    if (file12 == null || !file12.isValid() || file12.isDirectory()) continue;
                                    outputFiles.add(file12);
                                    TaskUtils.saveOutputFileInfo(file12, taskOptions.getName(), sourceFile);
                                }
                            }
                            for (OutputFilesHandler outputFilesHandler : (OutputFilesHandler[])OutputFilesHandler.EP_NAME.getExtensions()) {
                                outputFilesHandler.handleRefresh(dataContext, file, taskOptions, outputFiles);
                            }
                        };
                        if (!filesToRefresh.isEmpty()) {
                            GuiUtils.invokeLaterIfNeeded(() -> {
                                for (WatchedFile.GeneratedFile generatedFile : filesToRefresh) {
                                    VirtualFile file1 = fileManager.refreshAndFindFileByUrl(generatedFile.getUrl());
                                    if (file1 == null) continue;
                                    generatedFile.setFile(file1);
                                }
                                update.run();
                            }, (ModalityState)ModalityState.defaultModalityState());
                        } else {
                            GuiUtils.invokeLaterIfNeeded((Runnable)update, (ModalityState)ModalityState.defaultModalityState());
                        }
                    }

                    private WatchedFile createWatchedFile(@NotNull VirtualFile file) throws Macro.ExecutionCancelledException {
                        if (file == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        String[] outputPaths = taskOptions.getOutput().split(":");
                        WatchedFile watchedFile = new WatchedFile(file);
                        for (String outputFilePath : outputPaths) {
                            Map<String, VirtualFile> fileMap = Collections.singletonMap(CommonDataKeys.VIRTUAL_FILE.getName(), file);
                            DataContext newDataContext = SimpleDataContext.getSimpleContext(fileMap, (DataContext)dataContext);
                            String expandedOutputPath = TaskRunnerImpl.expandMacros(outputFilePath, newDataContext);
                            String newOutputFilePath = TaskRunnerImpl.getOutputFilePath(file, "", expandedOutputPath);
                            if (!StringUtil.isNotEmpty((String)newOutputFilePath)) continue;
                            watchedFile.addUrl(VfsUtilCore.pathToUrl((String)newOutputFilePath));
                        }
                        return watchedFile;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "dependencies";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "file";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleOutputFilesOfDependencies";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "createWatchedFile";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$handleOutputFilesOfDependencies$3";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.setCancelText("Stop").queue();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode() && ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any());
        }
    }

    @Nullable
    private static String expandMacros(String macrosString, DataContext dataContext) throws Macro.ExecutionCancelledException {
        String expandedString = MacroManager.getInstance().expandSilentMacros(macrosString, false, dataContext);
        return expandedString == null ? null : FileUtil.toSystemIndependentName((String)expandedString);
    }

    private static void disableWatcherAndNotify(Exception e, final Project project, final TaskOptions taskOptions) {
        ProjectTasksOptions.getInstance(project).setEnabledForTask(taskOptions.getName(), false);
        new Notification(BackgroundTaskBundle.message("inspections.group.name", new Object[0]), BackgroundTaskBundle.message("execution.exception.title", taskOptions.getName()), BackgroundTaskBundle.message("execution.exception.message", e.getMessage()), NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                WatchersConfigurable configurable = new WatchersConfigurable(project);
                ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> configurable.getPanel().selectTaskByName(taskOptions.getName()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/plugins/watcher/TaskRunnerImpl$3";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private void processFilters(@NotNull Project project, ProcessOutput output, TaskOptions taskOptions, VirtualFile file, @Nullable VirtualFile workingDir) {
        PsiFile psiFile;
        if (project == null) {
            TaskRunnerImpl.$$$reportNull$$$0(9);
        }
        this.getProblemsHolder().clearByInitializer(file, taskOptions.getName());
        List<TaskProblemDescription> problems = TaskProblemFinder.findProblems(output.getStderrLines(false), taskOptions);
        if (!taskOptions.isOutputFromStdout() || TaskRunnerImpl.isBadExitCode(output)) {
            problems.addAll(TaskProblemFinder.findProblems(output.getStdoutLines(false), taskOptions));
        }
        if (!problems.isEmpty()) {
            this.processFilters(project, problems, taskOptions, file, workingDir);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        }
    }

    private static boolean isBadExitCode(ProcessOutput output) {
        return output.getExitCode() != 0 && output.getExitCode() != 137;
    }

    public void processFilters(@NotNull Project project, List<TaskProblemDescription> problems, TaskOptions taskOptions, @NotNull VirtualFile file, @Nullable VirtualFile workingDir) {
        if (project == null) {
            TaskRunnerImpl.$$$reportNull$$$0(10);
        }
        if (file == null) {
            TaskRunnerImpl.$$$reportNull$$$0(11);
        }
        THashMap file2problems = new THashMap();
        for (TaskProblemDescription taskProblemDescription : problems) {
            VirtualFile fileWithProblem = TaskRunnerImpl.findFile(taskProblemDescription, workingDir, file);
            if (fileWithProblem == null) continue;
            TaskRunnerImpl.addProblem((Map<VirtualFile, List<TaskProblemDescription>>)file2problems, fileWithProblem, taskProblemDescription);
        }
        for (Map.Entry entry : file2problems.entrySet()) {
            VirtualFile currentFile = (VirtualFile)entry.getKey();
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(currentFile);
            if (psiFile == null) continue;
            this.getProblemsHolder().addProblems(currentFile, psiFile.getModificationStamp(), file, taskOptions.getName(), (List)entry.getValue());
            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        }
    }

    private static void addProblem(Map<VirtualFile, List<TaskProblemDescription>> file2problem, VirtualFile virtualFile, TaskProblemDescription problem) {
        List<TaskProblemDescription> problems = file2problem.get(virtualFile);
        if (problems == null) {
            problems = new ArrayList<TaskProblemDescription>();
            file2problem.put(virtualFile, problems);
        }
        problems.add(problem);
    }

    @Nullable
    public static VirtualFile findFile(@NotNull TaskProblemDescription problem, @Nullable VirtualFile workingDir, @NotNull VirtualFile currentFile) {
        if (problem == null) {
            TaskRunnerImpl.$$$reportNull$$$0(12);
        }
        if (currentFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmptyOrSpaces((String)problem.getPath())) {
            return currentFile;
        }
        String path = FileUtil.toSystemIndependentName((String)problem.getPath());
        VirtualFile result = LocalFileFinder.findFile((String)path);
        return result != null ? result : VfsUtil.findRelativeFile((VirtualFile)workingDir, (String[])path.split("/"));
    }

    @Nullable
    private VirtualFile refreshOutput(@NotNull VirtualFile sourceFile, String workingDirPath, String outputFilePath, String watcherName, @Nullable Project project) {
        if (sourceFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(14);
        }
        if ((outputFilePath = TaskRunnerImpl.getOutputFilePath(sourceFile, workingDirPath, outputFilePath)) != null) {
            String url = VfsUtilCore.pathToUrl((String)outputFilePath);
            this.myFilesInRefreshState.add(url);
            VirtualFile outputFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
            if (outputFile != null) {
                if (outputFile instanceof NewVirtualFile) {
                    ((NewVirtualFile)outputFile).markDirtyRecursively();
                }
                boolean asyncRefresh = !ApplicationManager.getApplication().isUnitTestMode();
                outputFile.putUserData(UndoConstants.FORCE_RECORD_UNDO, (Object)true);
                TaskRunnerImpl.updateDocumentTextIfNeeded(sourceFile, watcherName, project, outputFile);
                this.myPendingRefreshes.incrementAndGet();
                outputFile.refresh(asyncRefresh, true, () -> {
                    if (sourceFile == null) {
                        TaskRunnerImpl.$$$reportNull$$$0(19);
                    }
                    this.myPendingRefreshes.decrementAndGet();
                    this.myFilesInRefreshState.remove(url);
                    if (!outputFile.isDirectory() && !sourceFile.equals(outputFile) && project != null) {
                        this.myTasksScheduler.addRequest(() -> FwTaskRunner.tryFindTasksAndRun(project, outputFile, (Condition<TaskOptions>)((Condition)task -> task.isRunOnExternalChanges())), 0);
                    }
                    outputFile.putUserData(UndoConstants.FORCE_RECORD_UNDO, null);
                });
                if (!outputFile.isDirectory()) {
                    TaskUtils.saveOutputFileInfo(outputFile, watcherName, sourceFile);
                }
            } else {
                this.myFilesInRefreshState.remove(url);
            }
            return outputFile;
        }
        return null;
    }

    private static void updateDocumentTextIfNeeded(@NotNull VirtualFile sourceFile, @NotNull String watcherName, @Nullable Project project, @Nullable VirtualFile outputFile) {
        if (sourceFile == null) {
            TaskRunnerImpl.$$$reportNull$$$0(15);
        }
        if (watcherName == null) {
            TaskRunnerImpl.$$$reportNull$$$0(16);
        }
        if (sourceFile.equals(outputFile)) {
            boolean undoInProgress;
            Document document = FileDocumentManager.getInstance().getDocument(outputFile);
            UndoManager undoManager = project != null ? UndoManager.getInstance((Project)project) : null;
            boolean bl = undoInProgress = undoManager != null && (undoManager.isUndoInProgress() || undoManager.isRedoInProgress());
            if (document != null && !undoInProgress) {
                Runnable runnable = () -> {
                    CharSequence newText = LoadTextUtil.loadText((VirtualFile)outputFile);
                    if (!StringUtil.equals((CharSequence)document.getCharsSequence(), (CharSequence)newText)) {
                        document.setText(newText);
                    }
                };
                CommandProcessor.getInstance().executeCommand(project, () -> outputFile.refresh(false, false, runnable), "File watcher: " + watcherName, null, document);
            }
        }
    }

    @Nullable
    private static String getOutputFilePath(VirtualFile virtualFile, String workingDirPath, String outputFilePath) {
        if (!FileUtil.isAbsolute((String)outputFilePath)) {
            String baseFile = StringUtil.isEmpty((String)workingDirPath) ? virtualFile.getParent().getPath() : workingDirPath;
            outputFilePath = TaskUtils.getPathByRelativePath(baseFile, outputFilePath, "/");
        }
        return outputFilePath;
    }

    private static GeneralCommandLine createCommandLine(final DataContext dataContext, final TaskOptions options) throws Exception {
        return (GeneralCommandLine)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<GeneralCommandLine, Exception>(){

            public GeneralCommandLine compute() throws Exception {
                return TaskRunnerImpl.doCreateCommandLine(dataContext, options);
            }
        });
    }

    @NotNull
    private static GeneralCommandLine doCreateCommandLine(DataContext dataContext, TaskOptions options) throws ExecutionException, Macro.ExecutionCancelledException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        EnvironmentVariablesData data = options.getEnvData();
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        MacroManager macroManager = MacroManager.getInstance();
        for (Map.Entry entry : data.getEnvs().entrySet()) {
            map.put(entry.getKey(), macroManager.expandSilentMacros((String)entry.getValue(), true, dataContext));
        }
        EnvironmentVariablesData.create((Map)map, (boolean)data.isPassParentEnvs()).configureCommandLine(commandLine, true);
        commandLine.setRedirectErrorStream(true);
        commandLine.withCharset(TaskRunnerImpl.getCharset((Project)CommonDataKeys.PROJECT.getData(dataContext)));
        String workingDir = macroManager.expandSilentMacros(options.getWorkingDir(), true, dataContext);
        String exePath = macroManager.expandSilentMacros(options.getProgram(), true, dataContext);
        List rawArguments = ParametersListUtil.parse((String)options.getArguments());
        for (String rawArgument : rawArguments) {
            String expanded = macroManager.expandSilentMacros(rawArgument, true, dataContext);
            String result = macroManager.expandSilentMacros(expanded, false, dataContext);
            commandLine.addParameter(StringUtil.notNullize((String)result));
        }
        EnvironmentUtil.inlineParentOccurrences((Map)commandLine.getEnvironment());
        String workDirExpanded = TaskRunnerImpl.expandMacros(workingDir, dataContext);
        if (!StringUtil.isEmpty((String)workDirExpanded)) {
            commandLine.withWorkDirectory(workDirExpanded);
        }
        if ((exePath = TaskRunnerImpl.expandMacros(exePath, dataContext)) == null || StringUtil.isEmpty((String)exePath)) {
            throw new ExecutionException(BackgroundTaskBundle.message("invalid.executable", new Object[0]));
        }
        File exeFile = NewWatcherDialog.findProgramFile(exePath, dataContext, data);
        if (exeFile == null || !exeFile.exists()) {
            throw new ExecutionException(BackgroundTaskBundle.message("invalid.executable", new Object[0]));
        }
        exePath = exeFile.getAbsolutePath();
        String basename = exeFile.getName();
        if (SystemInfo.isMac && exeFile.isDirectory() && basename.endsWith(".app")) {
            commandLine.setExePath("open");
            commandLine.getParametersList().prependAll(new String[]{"-a", exePath});
        } else if (StringUtil.endsWithIgnoreCase((String)basename, (String)".jar")) {
            commandLine.setExePath(TaskRunnerImpl.getJDKExecutablePath());
            commandLine.getParametersList().prependAll(new String[]{"-jar", exePath});
        } else if (SystemInfo.isWindows && (StringUtil.endsWithIgnoreCase((String)basename, (String)".cmd") || StringUtil.endsWithIgnoreCase((String)basename, (String)".bat"))) {
            commandLine.setExePath("cmd.exe");
            commandLine.getParametersList().prependAll(new String[]{"/D", "/C", "call", exePath});
        } else {
            commandLine.setExePath(exePath);
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            TaskRunnerImpl.$$$reportNull$$$0(17);
        }
        return generalCommandLine;
    }

    @NotNull
    private static Charset getCharset(@Nullable Project project) {
        Charset charset = project != null ? EncodingProjectManager.getInstance((Project)project).getDefaultCharset() : EncodingManager.getInstance().getDefaultCharset();
        if (charset == null) {
            TaskRunnerImpl.$$$reportNull$$$0(18);
        }
        return charset;
    }

    private static String getJDKExecutablePath() {
        return SystemProperties.getJavaHome() + "/bin/java";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksToFinish";
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/TaskRunnerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 14: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcherName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/TaskRunnerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveJob";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateCommandLine";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inRefreshState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeFilesAndTasksToPerform";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveJob";
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processFilters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refreshOutput";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentTextIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshOutput$5";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRemoveJob$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

