/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.plugins.watcher.FwTaskRunner;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FwProjectChangeTracker {
    private static final Logger LOG = Logger.getInstance(FwProjectChangeTracker.class);
    private static final ExtensionPointName<PairProcessor<VirtualFile, Project>> IS_CUSTOM_HANDLER_EP_NAME = ExtensionPointName.create((String)"com.intellij.plugins.watcher.isCustomCondition");
    private static final String VFS_CHANGES_PREFIX = "[tracking vfs changes] ";
    private static final String UNSAVED_DOCUMENTS_PREFIX = "[tracking unsaved documents] ";
    private final Project myProject;
    private MessageBusConnection myConnection;
    private ScheduledFuture myUnsavedDocumentsTrackerFuture;
    private boolean myProjectDisposeHookRegistered;

    public FwProjectChangeTracker(@NotNull Project project) {
        if (project == null) {
            FwProjectChangeTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void startTrackingVfsChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myConnection != null || this.myProject.isDefault() || this.myProject.isDisposed()) {
            String message = "[tracking vfs changes] start aborted";
            if (this.myConnection != null) {
                message = message + ": already running";
            }
            LOG.info(message);
            return;
        }
        PathMacros.getInstance().addIgnoredMacro("MESSAGE");
        PathMacros.getInstance().addIgnoredMacro("FILE_PATH");
        PathMacros.getInstance().addIgnoredMacro("LINE");
        PathMacros.getInstance().addIgnoredMacro("COLUMN");
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new FwVirtualFileListener());
        this.myConnection = connection;
        LOG.info("[tracking vfs changes] started");
        this.registerProjectDisposeHook();
    }

    public void stopTrackingVfsChanges() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myConnection != null) {
            LOG.info("[tracking vfs changes] stopped");
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    public void startTrackingUnsavedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUnsavedDocumentsTrackerFuture != null || this.myProject.isDefault() || this.myProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            String message = "[tracking unsaved documents] start aborted";
            if (this.myUnsavedDocumentsTrackerFuture != null) {
                message = message + ": already running";
            }
            LOG.info(message);
            return;
        }
        this.myUnsavedDocumentsTrackerFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(new UnsavedDocumentsTracker(), 2L, 2L, TimeUnit.SECONDS);
        LOG.info("[tracking unsaved documents] started");
        this.registerProjectDisposeHook();
    }

    private void registerProjectDisposeHook() {
        if (!this.myProjectDisposeHookRegistered) {
            this.myProjectDisposeHookRegistered = true;
            Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

                public void dispose() {
                    FwProjectChangeTracker.this.stopTrackingVfsChanges();
                    FwProjectChangeTracker.this.stopTrackingUnsavedDocuments();
                }
            });
        }
    }

    public void stopTrackingUnsavedDocuments() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUnsavedDocumentsTrackerFuture != null) {
            LOG.info("[tracking unsaved documents] stopped");
            this.myUnsavedDocumentsTrackerFuture.cancel(false);
            this.myUnsavedDocumentsTrackerFuture = null;
        }
    }

    private boolean needImmediateSync(@NotNull List<TaskOptions> options, @NotNull VirtualFile virtualFile) {
        if (options == null) {
            FwProjectChangeTracker.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            FwProjectChangeTracker.$$$reportNull$$$0(2);
        }
        Boolean syntaxErrors = null;
        for (TaskOptions option : options) {
            if (!option.isImmediateSync()) continue;
            if (!option.isCheckSyntaxErrors()) {
                return true;
            }
            if (syntaxErrors == null) {
                syntaxErrors = PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)virtualFile);
            }
            if (syntaxErrors.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/FwProjectChangeTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "needImmediateSync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UnsavedDocumentsTracker
    implements Runnable {
        private UnsavedDocumentsTracker() {
        }

        @Override
        public void run() {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Document[] unsavedDocuments = fileDocumentManager.getUnsavedDocuments();
            List documentsToSave = null;
            for (Document unsavedDocument : unsavedDocuments) {
                if (!this.shouldSave(unsavedDocument, fileDocumentManager)) continue;
                if (documentsToSave == null) {
                    documentsToSave = ContainerUtil.newArrayListWithCapacity((int)unsavedDocuments.length);
                }
                documentsToSave.add(unsavedDocument);
            }
            if (documentsToSave != null) {
                this.batchSave((ImmutableList<Document>)ImmutableList.copyOf(documentsToSave), fileDocumentManager);
            }
        }

        private void batchSave(@NotNull ImmutableList<Document> documentsToSave, @NotNull FileDocumentManager fileDocumentManager) {
            if (documentsToSave == null) {
                UnsavedDocumentsTracker.$$$reportNull$$$0(0);
            }
            if (fileDocumentManager == null) {
                UnsavedDocumentsTracker.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (documentsToSave == null) {
                    UnsavedDocumentsTracker.$$$reportNull$$$0(4);
                }
                if (fileDocumentManager == null) {
                    UnsavedDocumentsTracker.$$$reportNull$$$0(5);
                }
                for (Document document : documentsToSave) {
                    fileDocumentManager.saveDocument(document);
                }
            }, FwProjectChangeTracker.this.myProject.getDisposed());
        }

        private boolean shouldSave(@NotNull Document document, @NotNull FileDocumentManager fileDocumentManager) {
            List<TaskOptions> options;
            VirtualFile file;
            if (document == null) {
                UnsavedDocumentsTracker.$$$reportNull$$$0(2);
            }
            if (fileDocumentManager == null) {
                UnsavedDocumentsTracker.$$$reportNull$$$0(3);
            }
            if ((file = fileDocumentManager.getFile(document)) == null) {
                return false;
            }
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)FwProjectChangeTracker.this.myProject);
            if (!index.isInContent(file) && !ScratchUtil.isScratch((VirtualFile)file)) {
                return false;
            }
            for (PairProcessor isCustom : (PairProcessor[])IS_CUSTOM_HANDLER_EP_NAME.getExtensions()) {
                if (!isCustom.process((Object)file, (Object)FwProjectChangeTracker.this.myProject)) continue;
                return false;
            }
            LookupEx activeLookup = LookupManager.getInstance((Project)FwProjectChangeTracker.this.myProject).getActiveLookup();
            if (activeLookup != null && activeLookup.isCompletion()) {
                return false;
            }
            return !DumbService.isDumb((Project)FwProjectChangeTracker.this.myProject) && FwProjectChangeTracker.this.needImmediateSync(options = ProjectTasksOptions.getInstance(FwProjectChangeTracker.this.myProject).findTasksForFile(file), file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "documentsToSave";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileDocumentManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/plugins/watcher/FwProjectChangeTracker$UnsavedDocumentsTracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "batchSave";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldSave";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$batchSave$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FwVirtualFileListener
    implements BulkFileListener,
    VirtualFileListener {
        private final QueueProcessor<Runnable> myQueueProcessor = QueueProcessor.createRunnableQueueProcessor((QueueProcessor.ThreadToUse)QueueProcessor.ThreadToUse.POOLED);

        private FwVirtualFileListener() {
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FwVirtualFileListener.$$$reportNull$$$0(0);
            }
            VirtualFile file = event.getFile();
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            if (fileDocumentManager.isFileModified(file) && TaskUtils.isGenerated(file)) {
                fileDocumentManager.reloadFiles(new VirtualFile[]{file});
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FwVirtualFileListener.$$$reportNull$$$0(1);
            }
            this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> {
                if (event == null) {
                    FwVirtualFileListener.$$$reportNull$$$0(17);
                }
                FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file, (Condition<TaskOptions>)((Condition)task -> {
                    if (event == null) {
                        FwVirtualFileListener.$$$reportNull$$$0(18);
                    }
                    return task.isRunOnExternalChanges() || !event.isFromRefresh();
                }));
            }));
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                FwVirtualFileListener.$$$reportNull$$$0(2);
            }
            if ("name".equals(event.getPropertyName())) {
                boolean same = ComparatorUtil.equalsNullable((Object)event.getOldValue(), (Object)event.getNewValue());
                if (same) {
                    return;
                }
                this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> {
                    if (event == null) {
                        FwVirtualFileListener.$$$reportNull$$$0(15);
                    }
                    if (!TaskUtils.isGenerated(file)) {
                        FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file, (Condition<TaskOptions>)((Condition)task -> {
                            if (event == null) {
                                FwVirtualFileListener.$$$reportNull$$$0(16);
                            }
                            return task.isRunOnExternalChanges() || !event.isFromRefresh();
                        }));
                    }
                }));
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                FwVirtualFileListener.$$$reportNull$$$0(3);
            }
            this.scheduleTask(FwProjectChangeTracker.this.myProject, event.getFile(), (Consumer<VirtualFile>)((Consumer)file -> {
                if (event == null) {
                    FwVirtualFileListener.$$$reportNull$$$0(13);
                }
                if (file.isDirectory()) {
                    ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)FwProjectChangeTracker.this.myProject);
                    index.iterateContentUnderDirectory(file, descendant -> {
                        if (event == null) {
                            FwVirtualFileListener.$$$reportNull$$$0(14);
                        }
                        if (!descendant.isDirectory()) {
                            this.tryFindTaskAndRunForCreatedFile(descendant, event.isFromRefresh());
                        }
                        return !FwProjectChangeTracker.this.myProject.isDisposed();
                    });
                } else {
                    this.tryFindTaskAndRunForCreatedFile((VirtualFile)file, event.isFromRefresh());
                }
            }));
        }

        private void scheduleTask(@NotNull Project project, @NotNull VirtualFile file, @NotNull Consumer<VirtualFile> task) {
            if (project == null) {
                FwVirtualFileListener.$$$reportNull$$$0(4);
            }
            if (file == null) {
                FwVirtualFileListener.$$$reportNull$$$0(5);
            }
            if (task == null) {
                FwVirtualFileListener.$$$reportNull$$$0(6);
            }
            this.myQueueProcessor.add(() -> {
                if (file == null) {
                    FwVirtualFileListener.$$$reportNull$$$0(10);
                }
                if (project == null) {
                    FwVirtualFileListener.$$$reportNull$$$0(11);
                }
                if (task == null) {
                    FwVirtualFileListener.$$$reportNull$$$0(12);
                }
                if (file.isValid() && !project.isDisposed()) {
                    task.consume((Object)file);
                }
            });
        }

        private void tryFindTaskAndRunForCreatedFile(@NotNull VirtualFile file, boolean externalChange) {
            if (file == null) {
                FwVirtualFileListener.$$$reportNull$$$0(7);
            }
            if (!TaskRunner.getInstance().inRefreshState(file.getUrl()) && file.isValid() && !TaskUtils.isGenerated(file)) {
                FwTaskRunner.tryFindTasksAndRun(FwProjectChangeTracker.this.myProject, file, (Condition<TaskOptions>)((Condition)task -> !externalChange || task.isRunOnExternalChanges()));
            }
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                FwVirtualFileListener.$$$reportNull$$$0(8);
            }
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                FwVirtualFileListener.$$$reportNull$$$0(9);
            }
            for (VFileEvent vFileEvent : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/plugins/watcher/FwProjectChangeTracker$FwVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleTask";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryFindTaskAndRunForCreatedFile";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$scheduleTask$6";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$fileCreated$5";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$4";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$propertyChanged$3";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$2";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$contentsChanged$1";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

