/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.tool.panels;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.debugger.PyConcurrencyService;
import com.jetbrains.python.debugger.concurrency.PyConcurrencyServiceImpl;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyToolWindowPanel;
import java.awt.Component;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyTab
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final ConcurrencyGraphModel myThreadingGraphModel;
    @NotNull
    private final ConcurrencyGraphModel myAsyncioGraphModel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final XDebugSession mySession;
    private final JTabbedPane myTabbedPane;
    private static final int THREADING_INDEX = 0;
    private static final int ASYNCIO_INDEX = 1;

    public ConcurrencyTab(@NotNull Project project, @NotNull XDebugSession session) {
        if (project == null) {
            ConcurrencyTab.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ConcurrencyTab.$$$reportNull$$$0(1);
        }
        super(false);
        this.myProject = project;
        this.mySession = session;
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabLayoutPolicy(0);
        this.myThreadingGraphModel = ((PyConcurrencyServiceImpl)PyConcurrencyService.getInstance((Project)this.myProject)).getThreadingInstance(session);
        this.myTabbedPane.insertTab("Threading graph", null, (Component)((Object)new ConcurrencyToolWindowPanel(this.myProject, this.myThreadingGraphModel, "Threading")), "", 0);
        this.myAsyncioGraphModel = ((PyConcurrencyServiceImpl)PyConcurrencyService.getInstance((Project)this.myProject)).getAsyncioInstance(session);
        this.myTabbedPane.insertTab("Asyncio graph", null, (Component)((Object)new ConcurrencyToolWindowPanel(this.myProject, this.myAsyncioGraphModel, "Asyncio")), "", 1);
        this.add(this.myTabbedPane);
    }

    @NotNull
    public ConcurrencyGraphModel getThreadingGraphModel() {
        ConcurrencyGraphModel concurrencyGraphModel = this.myThreadingGraphModel;
        if (concurrencyGraphModel == null) {
            ConcurrencyTab.$$$reportNull$$$0(2);
        }
        return concurrencyGraphModel;
    }

    public void dispose() {
        PyConcurrencyService.getInstance((Project)this.myProject).removeSession(this.mySession);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/tool/panels/ConcurrencyTab";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadingGraphModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

