/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.model;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyLockEvent;
import com.jetbrains.python.debugger.PyThreadEvent;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphElement;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyThreadState;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyGraphAnalyser;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyStat;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrencyGraphModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel");
    @NotNull
    private List<PyConcurrencyEvent> myLog;
    @NotNull
    private final Object myLogUpdateObject = new Object();
    @NotNull
    private ArrayList<ArrayList<ConcurrencyGraphElement>> myGraphScheme;
    @NotNull
    private final Object myGraphUpdateObject = new Object();
    @NotNull
    private Map<String, Integer> threadIndexToId;
    @NotNull
    private ArrayList<Pair<String, String>> threadNames;
    @NotNull
    private HashMap<Integer, Point> relations;
    @NotNull
    private final List<GraphListener> myListeners = new ArrayList<GraphListener>();
    private final Object myListenersObject = new Object();
    @NotNull
    private ConcurrencyGraphAnalyser myGraphAnalyser;
    @Nullable
    private XDebugSession lastSession;
    @Nullable
    private String myFilterLockId;
    @Nullable
    private ScheduledFuture<?> myTimer;
    @NotNull
    private HashMap<String, ConcurrencyStat> myStatInfo;
    private int myCurrentMaxThread = 0;
    @NotNull
    private HashMap<String, Long> myTimeSinceStartForProcess;
    private long myStartTime;
    private long myFinishTime;
    private long myTimerPeriod = 10L;
    private int myTimeCursor = 0;
    private boolean myLastSessionStopped = false;
    private int myLastInserted = 0;
    private boolean myShowPid = false;

    public ConcurrencyGraphModel() {
        this.myLog = new ArrayList<PyConcurrencyEvent>();
        this.threadIndexToId = new HashMap();
        this.myTimeSinceStartForProcess = new HashMap();
        this.threadNames = new ArrayList();
        this.myGraphScheme = new ArrayList();
        this.myGraphAnalyser = new ConcurrencyGraphAnalyser(this);
        this.relations = new HashMap();
        this.myStatInfo = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGraph() {
        Object object = this.myGraphUpdateObject;
        synchronized (object) {
            this.threadIndexToId = new HashMap();
            this.myTimeSinceStartForProcess = new HashMap();
            this.threadNames = new ArrayList();
            this.myGraphScheme = new ArrayList();
            this.myGraphAnalyser = new ConcurrencyGraphAnalyser(this);
            this.myCurrentMaxThread = 0;
            this.relations = new HashMap();
            this.myStatInfo = new HashMap();
            this.myShowPid = false;
            this.notifyListeners();
        }
    }

    private void addSessionListener() {
        if (this.lastSession == null) {
            return;
        }
        this.lastSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ConcurrencyGraphModel.this.myFinishTime = System.currentTimeMillis();
                ConcurrencyGraphModel.this.myLastSessionStopped = true;
            }
        });
    }

    @Nullable
    public XDebugSession getLastSession() {
        return this.lastSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordToLog(@NotNull PyConcurrencyEvent event) {
        if (event == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(0);
        }
        Object object = this.myLogUpdateObject;
        synchronized (object) {
            int i;
            for (i = this.myLog.size() - 1; i >= 0 && this.myLog.get(i).getTime() > event.getTime(); --i) {
            }
            this.myLog.add(i + 1, event);
            return i + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initNewSession(@NotNull XDebugSession debugSession) {
        if (debugSession == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(1);
        }
        Object object = this.myLogUpdateObject;
        synchronized (object) {
            this.lastSession = debugSession;
            this.myLog = new ArrayList<PyConcurrencyEvent>();
            this.addSessionListener();
            this.createGraph();
            this.startTimer();
        }
    }

    public void recordEvent(@NotNull PyConcurrencyEvent event) {
        if (event == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(2);
        }
        String pid = event.getPid();
        if (this.getLogSize() == 0) {
            this.myStartTime = System.currentTimeMillis();
            this.myTimeSinceStartForProcess.put((Object)pid, (Object)new Long(0L));
        } else if (event.getTime() == 0L) {
            this.myTimeSinceStartForProcess.put((Object)pid, (Object)(System.currentTimeMillis() - this.myStartTime));
        }
        if (this.myTimeSinceStartForProcess.size() > 1) {
            Long timeSinceStart = (Long)this.myTimeSinceStartForProcess.get((Object)pid);
            if (timeSinceStart != null) {
                event.setTime(event.getTime() + timeSinceStart * 1000L);
            }
            this.myShowPid = true;
        }
        this.myLastInserted = Math.min(this.myLastInserted, this.recordToLog(event));
    }

    @Nullable
    public PyConcurrencyEvent getEventAt(int index) {
        if (index < 0 || index > this.getLogSize() || this.getLogSize() == 0) {
            return null;
        }
        if (index == this.getLogSize()) {
            PyConcurrencyEvent lastEvent = this.myLog.get(this.getLogSize() - 1);
            return new FakeEvent((this.myFinishTime - this.getStartTime()) * 1000L, lastEvent);
        }
        return this.myLog.get(index);
    }

    public int getSize() {
        int logSize = this.getLogSize();
        return logSize > 0 ? logSize + 1 : logSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLogSize() {
        Object object = this.myLogUpdateObject;
        synchronized (object) {
            return this.myLog.size();
        }
    }

    @NotNull
    public String getStringRepresentation() {
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append("<html>Size: ").append(this.getLogSize()).append("<br>");
        for (PyConcurrencyEvent event : this.myLog) {
            resultBuilder.append(event.toString());
        }
        resultBuilder.append("</html>");
        String string = resultBuilder.toString();
        if (string == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    private long getStartTime() {
        return this.myStartTime;
    }

    @NotNull
    public ConcurrencyStat getStatisticsByThreadId(@NotNull String threadId) {
        PyConcurrencyEvent event;
        ConcurrencyStat result;
        if (threadId == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(4);
        }
        if ((result = (ConcurrencyStat)this.myStatInfo.get((Object)threadId)) == null) {
            result = new ConcurrencyStat(this.myStartTime);
            this.myStatInfo.put((Object)threadId, (Object)result);
        }
        if (result.getFinishTime() == 0L && (event = this.getEventAt(this.getLogSize())) != null) {
            result.setPauseTime(event.getTime());
        }
        ConcurrencyStat concurrencyStat = result;
        if (concurrencyStat == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(5);
        }
        return concurrencyStat;
    }

    @NotNull
    public HashMap<String, ConcurrencyStat> getStatInfo() {
        HashMap<String, ConcurrencyStat> hashMap = this.myStatInfo;
        if (hashMap == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    public boolean isLockSelected() {
        return this.myFilterLockId != null;
    }

    public boolean isLastSessionStopped() {
        return this.myLastSessionStopped;
    }

    public int getMaxThread() {
        return this.myCurrentMaxThread;
    }

    @NotNull
    public String getThreadNameByNumber(int ind) {
        Pair<String, String> fullName = this.threadNames.get(ind);
        if (fullName == null) {
            if ("" == null) {
                ConcurrencyGraphModel.$$$reportNull$$$0(7);
            }
            return "";
        }
        String string = this.myShowPid ? (String)fullName.first + " (" + (String)fullName.second + ")" : (String)fullName.first;
        if (string == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    public int getLastEventIndexBeforeMoment(long time) {
        for (int i = 0; i < this.getSize(); ++i) {
            PyConcurrencyEvent event = this.getEventAt(i);
            if (event == null || event.getTime() < time) continue;
            return Math.max(0, i - 1);
        }
        return this.getSize() - 1;
    }

    public long getDuration() {
        if (this.getLogSize() > 0) {
            return (this.myFinishTime - this.getStartTime()) * 1000L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ArrayList<ConcurrencyGraphElement> getDrawElementsForRow(int row) {
        Object object = this.myGraphUpdateObject;
        // MONITORENTER : object
        if (row >= this.myGraphScheme.size()) {
            ArrayList<ConcurrencyGraphElement> arrayList = new ArrayList<ConcurrencyGraphElement>();
            // MONITOREXIT : object
            if (arrayList != null) return arrayList;
            ConcurrencyGraphModel.$$$reportNull$$$0(9);
            return arrayList;
        }
        ArrayList<ConcurrencyGraphElement> arrayList = new ArrayList<ConcurrencyGraphElement>((Collection)this.myGraphScheme.get(row));
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        ConcurrencyGraphModel.$$$reportNull$$$0(10);
        return arrayList;
    }

    @NotNull
    private ConcurrencyGraphElement getNextElementForEvent(@NotNull PyConcurrencyEvent event, @NotNull ConcurrencyThreadState threadState, int index) {
        if (event == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(11);
        }
        if (threadState == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(12);
        }
        switch (event.getType()) {
            case CREATE: {
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(threadState, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(13);
                }
                return concurrencyGraphElement;
            }
            case START: {
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.Run, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(14);
                }
                return concurrencyGraphElement;
            }
            case JOIN: {
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(threadState, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(15);
                }
                return concurrencyGraphElement;
            }
            case STOP: {
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.Stopped, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(16);
                }
                return concurrencyGraphElement;
            }
            case ACQUIRE_BEGIN: {
                PyLockEvent lockEvent;
                if (this.myFilterLockId != null && event instanceof PyLockEvent && (lockEvent = (PyLockEvent)event).getLockId().equals(this.myFilterLockId)) {
                    ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.LockWaitSelected, index);
                    if (concurrencyGraphElement == null) {
                        ConcurrencyGraphModel.$$$reportNull$$$0(17);
                    }
                    return concurrencyGraphElement;
                }
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.LockWait, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(18);
                }
                return concurrencyGraphElement;
            }
            case ACQUIRE_END: {
                ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.LockOwn, index);
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(19);
                }
                return concurrencyGraphElement;
            }
            case RELEASE: {
                ConcurrencyGraphElement concurrencyGraphElement = this.myGraphAnalyser.getThreadStateAt(index, event.getThreadId());
                if (concurrencyGraphElement == null) {
                    ConcurrencyGraphModel.$$$reportNull$$$0(20);
                }
                return concurrencyGraphElement;
            }
        }
        ConcurrencyGraphElement concurrencyGraphElement = new ConcurrencyGraphElement(ConcurrencyThreadState.Stopped, index);
        if (concurrencyGraphElement == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(21);
        }
        return concurrencyGraphElement;
    }

    private void addRelation(int index, int parent, int child) {
        this.relations.put((Object)index, (Object)new Point(parent, child));
    }

    @Nullable
    public Point getRelationForRow(int row) {
        Point relation = (Point)this.relations.get((Object)row);
        if (relation == null || relation.x == 0 && relation.y == 0) {
            return null;
        }
        return relation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull GraphListener logListener) {
        if (logListener == null) {
            ConcurrencyGraphModel.$$$reportNull$$$0(22);
        }
        Object object = this.myListenersObject;
        synchronized (object) {
            this.myListeners.add(logListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.myListenersObject;
        synchronized (object) {
            for (GraphListener logListener : this.myListeners) {
                logListener.graphChanged();
            }
        }
    }

    @Nullable
    public ConcurrencyThreadState getThreadStateForEvent(int eventId, int threadIndex) {
        ArrayList<ConcurrencyGraphElement> elements;
        if (eventId < this.myGraphScheme.size() && threadIndex < (elements = this.myGraphScheme.get(eventId)).size()) {
            return elements.get(threadIndex).getThreadState();
        }
        return null;
    }

    @Nullable
    public String getThreadIdByIndex(int index) {
        for (Map.Entry<String, Integer> entry : this.threadIndexToId.entrySet()) {
            if (entry.getValue() != index) continue;
            return entry.getKey();
        }
        return null;
    }

    public int getTimeCursor() {
        return this.myTimeCursor;
    }

    public void setTimeCursor(int timeCursor) {
        this.myTimeCursor = timeCursor;
    }

    public void setFilterLockId(@Nullable String filterLockId) {
        this.myFilterLockId = filterLockId;
        this.createGraph();
        this.updateGraph(0);
        this.notifyListeners();
    }

    public void setTimerPeriod(long timerPeriod) {
        this.myTimerPeriod = timerPeriod;
    }

    private void startTimer() {
        this.myTimeCursor = 0;
        this.myLastSessionStopped = false;
        this.myTimer = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            if (this.myLastSessionStopped) {
                this.updateGraph(this.myLastInserted);
                this.myLastInserted = Math.max(0, this.myGraphScheme.size() - 1);
                this.notifyListeners();
                this.myTimer.cancel(false);
                return;
            }
            this.myFinishTime = System.currentTimeMillis();
            this.updateGraph(this.myLastInserted);
            this.myLastInserted = Math.max(0, this.myGraphScheme.size() - 1);
            this.notifyListeners();
        }, 0L, this.myTimerPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGraph(int indexInserted) {
        Object object = this.myGraphUpdateObject;
        synchronized (object) {
            int oldSize = this.myGraphScheme.size();
            if (indexInserted < oldSize && this.myCurrentMaxThread != 0) {
                this.myCurrentMaxThread = indexInserted > 0 ? this.myGraphScheme.get(indexInserted - 1).size() : 0;
                for (int i = indexInserted; i < this.myGraphScheme.size(); ++i) {
                    if (!this.relations.containsKey((Object)i)) continue;
                    this.relations.remove((Object)i);
                }
            }
            indexInserted = Math.min(this.myGraphScheme.size(), indexInserted);
            int currentLogSize = this.getLogSize();
            this.myGraphAnalyser.prepareThreadStatesAndUpdateStatistics(currentLogSize);
            for (int i = indexInserted; i < currentLogSize; ++i) {
                HashSet<String> deadlocked;
                int eventThreadIdInt;
                String parentId;
                PyConcurrencyEvent event = this.getEventAt(i);
                if (event == null) continue;
                String eventThreadId = event.getThreadId();
                if (event.isThreadEvent() && event.getType() == PyConcurrencyEvent.EventType.START) {
                    ConcurrencyGraphElement element = new ConcurrencyGraphElement(ConcurrencyThreadState.Run, i);
                    ++this.myCurrentMaxThread;
                    this.threadIndexToId.put(eventThreadId, this.myCurrentMaxThread - 1);
                    this.threadNames.add(this.myCurrentMaxThread - 1, (Pair<String, String>)Pair.create((Object)event.getThreadName(), (Object)event.getPid()));
                    parentId = ((PyThreadEvent)event).getParentThreadId();
                    if (!parentId.isEmpty() && this.threadIndexToId.containsKey(parentId)) {
                        int parentNum = this.threadIndexToId.get(parentId);
                        int eventNum = this.myCurrentMaxThread - 1;
                        this.addRelation(i, parentNum, eventNum);
                    }
                    if (i < this.myGraphScheme.size()) {
                        this.myGraphScheme.set(i, new ArrayList(this.myCurrentMaxThread));
                    } else {
                        this.myGraphScheme.add(new ArrayList(this.myCurrentMaxThread));
                    }
                    for (int j = 0; j < this.myCurrentMaxThread - 1; ++j) {
                        this.myGraphScheme.get(i).add(j, this.myGraphScheme.get(i - 1).get(j));
                    }
                    this.myGraphScheme.get(i).add(this.myCurrentMaxThread - 1, element);
                    continue;
                }
                int n = eventThreadIdInt = this.threadIndexToId.containsKey(eventThreadId) ? this.threadIndexToId.get(eventThreadId) : 0;
                if (event instanceof PyThreadEvent && !(parentId = ((PyThreadEvent)event).getParentThreadId()).isEmpty() && this.threadIndexToId.containsKey(parentId)) {
                    int parentNum = this.threadIndexToId.get(((PyThreadEvent)event).getParentThreadId());
                    this.addRelation(i, parentNum, eventThreadIdInt);
                }
                if (i < this.myGraphScheme.size()) {
                    this.myGraphScheme.set(i, new ArrayList());
                } else {
                    this.myGraphScheme.add(new ArrayList());
                }
                for (int j = 0; j < this.myCurrentMaxThread; ++j) {
                    if (j != eventThreadIdInt) {
                        this.myGraphScheme.get(i).add(j, this.myGraphScheme.get(i - 1).get(j));
                        continue;
                    }
                    this.myGraphScheme.get(i).add(eventThreadIdInt, this.getNextElementForEvent(event, this.myGraphScheme.get(i - 1).get(eventThreadIdInt).getThreadState(), i));
                }
                if (event.getType() != PyConcurrencyEvent.EventType.ACQUIRE_BEGIN || (deadlocked = this.myGraphAnalyser.checkForDeadlocks(i)) == null) continue;
                for (String threadId : deadlocked) {
                    this.myGraphScheme.get(i).set(this.threadIndexToId.get(threadId), new ConcurrencyGraphElement(ConcurrencyThreadState.Deadlock, i));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadState";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringRepresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatisticsByThreadId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadNameByNumber";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrawElementsForRow";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextElementForEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordToLog";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initNewSession";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recordEvent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStatisticsByThreadId";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNextElementForEvent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GraphListener {
        public void graphChanged();
    }

    private static class FakeEvent
    extends PyConcurrencyEvent {
        /*
         * WARNING - void declaration
         */
        public FakeEvent(long time, @NotNull PyConcurrencyEvent pyConcurrencyEvent) {
            void previousEvent;
            if (pyConcurrencyEvent == null) {
                FakeEvent.$$$reportNull$$$0(0);
            }
            super(time, previousEvent.getThreadId(), previousEvent.getThreadName(), previousEvent.isThreadEvent());
            this.setType(PyConcurrencyEvent.EventType.CREATE);
        }

        @NotNull
        public String getEventActionName() {
            if ("" == null) {
                FakeEvent.$$$reportNull$$$0(1);
            }
            return "";
        }

        public boolean isThreadEvent() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphModel$FakeEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphModel$FakeEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

