/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.concurrency.tool.ConcurrencyView;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyTab;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import icons.ConcurrencyVisualiserIcons;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PyConcurrencyDebugRunner
extends PyDebugRunner {
    public static final String PY_CONCURRENCY_DEBUG_RUNNER = "PyConcurrencyDebugRunner";
    public static final String WINDOW_ID = "Concurrent Activities Diagram";
    private static final Key<Boolean> PYTHON_CONCURRENCY_PROCESS_HANDLER = Key.create((String)"PYTHON_CONCURRENCY_PROCESS_HANDLER");
    private ArrayList<XBreakpoint> myDisabledBreakpoints;

    @NotNull
    public String getRunnerId() {
        if (PY_CONCURRENCY_DEBUG_RUNNER == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(0);
        }
        return PY_CONCURRENCY_DEBUG_RUNNER;
    }

    protected XDebugSession createSession(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(2);
        }
        Project project = environment.getProject();
        XDebugSession session = super.createSession(state, environment);
        session.getDebugProcess().getProcessHandler().putUserData(PYTHON_CONCURRENCY_PROCESS_HANDLER, (Object)true);
        final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        this.disableBreakpoints(project);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (XBreakpoint breakpoint : PyConcurrencyDebugRunner.this.myDisabledBreakpoints) {
                        breakpoint.setEnabled(true);
                    }
                });
                toolWindowManager.invokeLater(() -> toolWindowManager.getToolWindow(ToolWindowId.DEBUG).setAvailable(true, null));
            }
        });
        PyConcurrencyDebugRunner.initToolWindow(session, project);
        return session;
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(3);
        }
        if (debugParams == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(4);
        }
        if (pyState == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(5);
        }
        if (cmd == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(6);
        }
        super.configureDebugParameters(project, debugParams, pyState, cmd);
        debugParams.addParameter("--save-threading");
        debugParams.addParameter("--save-asyncio");
        cmd.getEnvironment().put("PYTHONASYNCIODEBUG", "1");
    }

    private void disableBreakpoints(@NotNull Project project) {
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(7);
        }
        this.myDisabledBreakpoints = new ArrayList();
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)project);
        for (XBreakpoint breakpoint : manager.getBreakpointManager().getAllBreakpoints()) {
            if (!breakpoint.isEnabled()) continue;
            breakpoint.setEnabled(false);
            this.myDisabledBreakpoints.add(breakpoint);
        }
    }

    private static void initToolWindow(@NotNull XDebugSession newSession, @NotNull Project project) {
        if (newSession == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(9);
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.invokeLater(() -> toolWindowManager.getToolWindow(ToolWindowId.DEBUG).setAvailable(false, null));
        ToolWindow toolWindow = toolWindowManager.getToolWindow(WINDOW_ID);
        if (toolWindow == null) {
            toolWindowManager.invokeLater(() -> {
                if (project == null) {
                    PyConcurrencyDebugRunner.$$$reportNull$$$0(15);
                }
                if (newSession == null) {
                    PyConcurrencyDebugRunner.$$$reportNull$$$0(16);
                }
                ToolWindow window = PyConcurrencyDebugRunner.createToolWindow(toolWindowManager);
                PyConcurrencyDebugRunner.createContent(project, window, newSession, 0);
                window.show(null);
            });
        } else {
            ConcurrencyTab selectedTab;
            XDebugSession session;
            JComponent component;
            ContentManager contentManager = toolWindow.getContentManager();
            Content content = contentManager.getSelectedContent();
            int contentIndex = contentManager.getContentCount();
            if (content != null && (component = content.getComponent()) instanceof ConcurrencyTab && (session = (selectedTab = (ConcurrencyTab)((Object)component)).getThreadingGraphModel().getLastSession()) != null && session.isStopped()) {
                contentIndex = contentManager.getIndexOfContent(content);
                contentManager.removeContent(content, true);
            }
            PyConcurrencyDebugRunner.createContent(project, toolWindow, newSession, contentIndex);
            toolWindow.show(null);
        }
    }

    private static void createContent(Project project, @NotNull ToolWindow toolWindow, @NotNull XDebugSession session, int index) {
        if (toolWindow == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(10);
        }
        if (session == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(11);
        }
        Content content = new ConcurrencyView(project).createContent(session);
        ContentManager myContentManager = toolWindow.getContentManager();
        myContentManager.addContent(content, index);
        myContentManager.setSelectedContent(content);
    }

    private static ToolWindow createToolWindow(@NotNull ToolWindowManager toolWindowManager) {
        if (toolWindowManager == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(12);
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(WINDOW_ID, false, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(ConcurrencyVisualiserIcons.ConcurrencyDiagramToolwindow);
        return toolWindow;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(13);
        }
        if (profile == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(14);
        }
        return executorId.equals("ConcurrencyExecutor") && profile instanceof AbstractPythonRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/PyConcurrencyDebugRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSession";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/PyConcurrencyDebugRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugParameters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "disableBreakpoints";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initToolWindow$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

