/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.remote.process;

import com.google.common.net.HostAndPort;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"CONTAINER_CHECK_INTERVAL_IN_MILLIS", "", "getDockerComposeContainer", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerApplicationRuntime;", "dockerRuntime", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;", "containerName", "", "toRemoteProcess", "Lcom/intellij/remote/RemoteProcess;", "process", "Ljava/lang/Process;", "waitForContainer", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerComposeProcessUtil")
public final class DockerComposeProcessUtil {
    private static final long CONTAINER_CHECK_INTERVAL_IN_MILLIS = 500L;

    @Deprecated(message="Temporary transition method in supporting `docker-compose` local execution")
    @NotNull
    public static final RemoteProcess toRemoteProcess(@NotNull Process process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        return new RemoteProcess(process){
            final /* synthetic */ Process $process;

            public void destroy() {
                this.$process.destroy();
            }

            public int exitValue() {
                return this.$process.exitValue();
            }

            public boolean isDisconnected() {
                return !this.$process.isAlive();
            }

            public int waitFor() {
                return this.$process.waitFor();
            }

            @Nullable
            public HostAndPort getLocalTunnel(int remotePort) {
                return HostAndPort.fromParts((String)"localhost", (int)remotePort);
            }

            @NotNull
            public OutputStream getOutputStream() {
                OutputStream outputStream = this.$process.getOutputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"process.outputStream");
                return outputStream;
            }

            @NotNull
            public InputStream getErrorStream() {
                InputStream inputStream = this.$process.getErrorStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.errorStream");
                return inputStream;
            }

            @NotNull
            public InputStream getInputStream() {
                InputStream inputStream = this.$process.getInputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"process.inputStream");
                return inputStream;
            }

            public boolean killProcessTree() {
                this.$process.destroy();
                return true;
            }
            {
                this.$process = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final RemoteDockerApplicationRuntime getDockerComposeContainer(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull String containerName) throws ServerRuntimeException, RemoteSdkException {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkParameterIsNotNull((Object)containerName, (String)"containerName");
        RemoteDockerApplicationRuntime serviceApplicationRuntime = dockerRuntime.findContainerByName(containerName);
        if (serviceApplicationRuntime == null) {
            throw (Throwable)new RemoteSdkException("Docker Compose container " + containerName + " has not been found");
        }
        return serviceApplicationRuntime;
    }

    @NotNull
    public static final RemoteDockerApplicationRuntime waitForContainer(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull String containerName) throws ServerRuntimeException, InterruptedException {
        Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkParameterIsNotNull((Object)containerName, (String)"containerName");
        RemoteDockerApplicationRuntime container;
        while ((container = dockerRuntime.findContainerByName(containerName)) == null) {
            Thread.sleep(500L);
        }
        return container;
    }
}

