/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.statistics;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.settings.PuppetProjectConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class PuppetUsagesCollector
extends AbstractProjectsUsagesCollector {
    private static final String GROUP_ID = "Puppet";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            PuppetUsagesCollector.$$$reportNull$$$0(0);
        }
        if (project.isDefault()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                PuppetUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (project.isDisposed()) {
            throw new CollectUsagesException("Project " + project + " is disposed");
        }
        if (!PuppetUsagesCollector.containsPuppetFiles(project).booleanValue()) {
            Set<UsageDescriptor> set = Collections.emptySet();
            if (set == null) {
                PuppetUsagesCollector.$$$reportNull$$$0(2);
            }
            return set;
        }
        PuppetProjectConfiguration configuration = PuppetProjectConfiguration.getInstance(project);
        if (configuration == null) {
            throw new CollectUsagesException("Configuration is null");
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Language version: " + (Object)((Object)configuration.getLanguageVersion()));
        TreeSet<UsageDescriptor> result = new TreeSet<UsageDescriptor>();
        for (String key : keys) {
            result.add(new UsageDescriptor(key, 1));
        }
        TreeSet<UsageDescriptor> treeSet = result;
        if (treeSet == null) {
            PuppetUsagesCollector.$$$reportNull$$$0(3);
        }
        return treeSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        if (groupDescriptor == null) {
            PuppetUsagesCollector.$$$reportNull$$$0(4);
        }
        return groupDescriptor;
    }

    private static Boolean containsPuppetFiles(@NotNull Project project) {
        if (project == null) {
            PuppetUsagesCollector.$$$reportNull$$$0(5);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project == null) {
                PuppetUsagesCollector.$$$reportNull$$$0(6);
            }
            return FileTypeIndex.containsFileOfType((FileType)PuppetFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/statistics/PuppetUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/statistics/PuppetUsagesCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsPuppetFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsPuppetFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

