/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.resolve;

import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactsIndex;
import com.intellij.lang.puppet.psi.PuppetCompositePsiElement;
import com.intellij.lang.puppet.psi.PuppetFullQualifiedNameOwner;
import com.intellij.lang.puppet.psi.PuppetParametrizedDeclaration;
import com.intellij.lang.puppet.psi.PuppetPolyNamedPsiElement;
import com.intellij.lang.puppet.psi.PuppetScopeHolder;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.resolve.PuppetVariableResolveProcessor;
import com.intellij.lang.puppet.psi.resolve.PuppetVariableScopeProcessor;
import com.intellij.lang.puppet.psi.stubs.PuppetStubBasedPsiElement;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetClassStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetNamespacesStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTopLevelVariablesStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTypeStubIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetResolveUtil {
    private static final Key<Set<PsiElement>> RECURSION_SET_KEY = new Key("puppet.resolve.recursion.map");
    private static final TokenSet NAMED_SYNONIMS_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{PuppetTokenTypes.CLASS_DEFINITION, PuppetTokenTypes.TYPE_DEFINITION, PuppetTokenTypes.NAMESPACE_DEFINITION});

    public static boolean treeWalkUp(@Nullable PsiElement originElement, @NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(0);
        }
        return PuppetResolveUtil.treeWalkUp(originElement, false, processor, ResolveState.initial().put(RECURSION_SET_KEY, (Object)new THashSet()));
    }

    public static boolean treeWalkUp(@Nullable PsiElement originElement, boolean processOrigin, @NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState) {
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(1);
        }
        if (resolveState == null) {
            PuppetResolveUtil.$$$reportNull$$$0(2);
        }
        Set recursionSet = (Set)resolveState.get(RECURSION_SET_KEY);
        assert (recursionSet != null);
        PsiElement lastChild = null;
        for (PsiElement currentElement = originElement; currentElement != null; currentElement = currentElement.getContext()) {
            if (recursionSet.add(currentElement) && (processOrigin || originElement != currentElement) && !currentElement.processDeclarations(processor, resolveState, lastChild, originElement)) {
                return false;
            }
            lastChild = currentElement;
        }
        return true;
    }

    public static boolean processChildren(@NotNull PsiElement parentElement, final @NotNull PsiScopeProcessor processor, final @NotNull ResolveState resolveState, @Nullable PsiElement lastChildElement, final @NotNull PsiElement originElement) {
        if (parentElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(4);
        }
        if (resolveState == null) {
            PuppetResolveUtil.$$$reportNull$$$0(5);
        }
        if (originElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(6);
        }
        final Set recursionSet = (Set)resolveState.get(RECURSION_SET_KEY);
        assert (recursionSet != null);
        PsiScopeProcessor proxyProcessor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement currentElement, @NotNull ResolveState state) {
                if (currentElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (recursionSet.add(currentElement)) {
                    if ((currentElement instanceof PsiNamedElement || currentElement instanceof PuppetPolyNamedPsiElement) && !processor.execute(currentElement, resolveState)) {
                        return false;
                    }
                    if (currentElement instanceof PuppetCompositePsiElement && !(currentElement instanceof PuppetScopeHolder) && !currentElement.processDeclarations(processor, resolveState, null, originElement)) {
                        return false;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "currentElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/puppet/psi/resolve/PuppetResolveUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        StubElement parentStubElement = PuppetResolveUtil.getStubFromElement(parentElement);
        StubElement lastChildStubElement = PuppetResolveUtil.getStubFromElement(lastChildElement);
        if (parentStubElement != null && (lastChildElement == null || lastChildStubElement != null)) {
            return PuppetResolveUtil.processChildrenWithStubs(parentStubElement, proxyProcessor, resolveState, lastChildStubElement);
        }
        return PuppetResolveUtil.processChildrenWithPsi(parentElement, proxyProcessor, resolveState, lastChildElement);
    }

    private static boolean processChildrenWithPsi(@NotNull PsiElement parentElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, @Nullable PsiElement lastChildElement) {
        PsiElement currentElement;
        if (parentElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(8);
        }
        if (resolveState == null) {
            PuppetResolveUtil.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = currentElement = lastChildElement == null ? parentElement.getLastChild() : lastChildElement.getPrevSibling();
        while (currentElement != null) {
            if (!processor.execute(currentElement, resolveState)) {
                return false;
            }
            currentElement = currentElement.getPrevSibling();
        }
        return true;
    }

    private static boolean processChildrenWithStubs(@NotNull StubElement parentStubElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, @Nullable StubElement lastChildStubElement) {
        int lastIndex;
        List childrenStubElements;
        if (parentStubElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(11);
        }
        if (resolveState == null) {
            PuppetResolveUtil.$$$reportNull$$$0(12);
        }
        if ((childrenStubElements = parentStubElement.getChildrenStubs()).isEmpty()) {
            return true;
        }
        int startIndex = childrenStubElements.size() - 1;
        if (lastChildStubElement != null && (lastIndex = childrenStubElements.lastIndexOf(lastChildStubElement)) != -1) {
            startIndex = lastIndex;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (processor.execute(((StubElement)childrenStubElements.get(i)).getPsi(), resolveState)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static StubElement getStubFromElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof StubBasedPsiElement) {
            return ((StubBasedPsiElement)element).getStub();
        }
        if (element instanceof PsiFileImpl) {
            return ((PsiFileImpl)element).getStub();
        }
        return null;
    }

    public static boolean processStubBasedChildrenWithSmartStop(final @NotNull PsiElement element, final @NotNull TokenSet typesToProcess, final @NotNull Processor<PuppetStubBasedPsiElement> processor) {
        StubElement stub;
        if (element == null) {
            PuppetResolveUtil.$$$reportNull$$$0(13);
        }
        if (typesToProcess == null) {
            PuppetResolveUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(15);
        }
        if ((stub = PuppetResolveUtil.getStubFromElement(element)) != null) {
            for (PuppetStubBasedPsiElement child : (PuppetStubBasedPsiElement[])stub.getChildrenByType(typesToProcess, (PsiElement[])new PuppetStubBasedPsiElement[0])) {
                if (processor.process((Object)child)) continue;
                return false;
            }
        } else {
            final boolean[] result = new boolean[]{true};
            element.acceptChildren(new PsiElementVisitor(){

                public void visitElement(PsiElement childElement) {
                    if (!result[0]) {
                        return;
                    }
                    if (childElement instanceof PuppetStubBasedPsiElement) {
                        PuppetStubBasedPsiElement stubBasedPsiElement = (PuppetStubBasedPsiElement)childElement;
                        if (typesToProcess.contains((IElementType)stubBasedPsiElement.getElementType()) && !processor.process((Object)stubBasedPsiElement)) {
                            result[0] = false;
                        }
                    } else if (element.equals(childElement) || !(childElement instanceof PuppetParametrizedDeclaration)) {
                        childElement.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return result[0];
        }
        return true;
    }

    @NotNull
    public static Collection<PsiElement> getLexicalVariableDeclaration(@NotNull PuppetVariable sourceVariable) {
        if (sourceVariable == null) {
            PuppetResolveUtil.$$$reportNull$$$0(16);
        }
        if (sourceVariable.isDeclaration()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PuppetResolveUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        String fullQualifiedName = sourceVariable.getFullQualifiedName();
        if (StringUtil.isEmpty((String)fullQualifiedName) || StringUtil.contains((CharSequence)fullQualifiedName, (CharSequence)"::")) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PuppetResolveUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        PuppetVariableResolveProcessor processor = new PuppetVariableResolveProcessor(fullQualifiedName);
        if (PuppetResolveUtil.treeWalkUp(sourceVariable, processor)) {
            PuppetResolveUtil.processTopScopeVariablesAndFacts(processor, sourceVariable);
        }
        Set<PsiElement> set = processor.getResult();
        if (set == null) {
            PuppetResolveUtil.$$$reportNull$$$0(19);
        }
        return set;
    }

    public static void processTopScopeVariablesAndFacts(@NotNull PuppetVariableScopeProcessor processor, @NotNull PsiElement scopeElement) {
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(20);
        }
        if (scopeElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(21);
        }
        Set<PsiFile> processedFiles = processor.getProcessedFiles();
        Project project = scopeElement.getProject();
        PuppetFactsIndex.processAllElements(project, scopeElement.getResolveScope(), processor);
        PuppetTopLevelVariablesStubsIndex.getInstance().processAllElements(project, scopeElement, variable -> {
            if (processor == null) {
                PuppetResolveUtil.$$$reportNull$$$0(26);
            }
            if (processedFiles.contains(variable.getContainingFile())) {
                return true;
            }
            return processor.execute(variable, ResolveState.initial());
        });
    }

    public static boolean processElementSynonims(@NotNull PsiElement targetElement, @NotNull PsiElement scopeProvider, @NotNull Set<String> processedNames, @NotNull PsiElementProcessor<PsiElement> processor) {
        if (targetElement == null) {
            PuppetResolveUtil.$$$reportNull$$$0(22);
        }
        if (scopeProvider == null) {
            PuppetResolveUtil.$$$reportNull$$$0(23);
        }
        if (processedNames == null) {
            PuppetResolveUtil.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            PuppetResolveUtil.$$$reportNull$$$0(25);
        }
        if (!NAMED_SYNONIMS_TOKENSET.contains(PsiUtilCore.getElementType((PsiElement)targetElement))) {
            return true;
        }
        assert (targetElement instanceof PuppetFullQualifiedNameOwner);
        String fullQualifiedName = ((PuppetFullQualifiedNameOwner)targetElement).getFullQualifiedName();
        if (StringUtil.isEmpty((String)fullQualifiedName) || !processedNames.add(fullQualifiedName)) {
            return true;
        }
        ArrayList allSynonims = new ArrayList(PuppetClassStubsIndex.getInstance().find(fullQualifiedName, scopeProvider));
        allSynonims.addAll(PuppetTypeStubIndex.getInstance().find(fullQualifiedName, scopeProvider));
        allSynonims.addAll(PuppetNamespacesStubsIndex.getInstance().find(fullQualifiedName, scopeProvider));
        for (PsiElement synonim : allSynonims) {
            if (processor.execute(synonim)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStubElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToProcess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceVariable";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/resolve/PuppetResolveUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeProvider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/resolve/PuppetResolveUtil";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexicalVariableDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenWithPsi";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processChildrenWithStubs";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processStubBasedChildrenWithSmartStop";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLexicalVariableDeclaration";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTopScopeVariablesAndFacts";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processElementSynonims";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTopScopeVariablesAndFacts$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

