/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PuppetProjectFilesListener
implements VirtualFileListener {
    private static final Set<String> KEY_FILE_NAMES = new THashSet(Arrays.asList("environment.conf", "Puppetfile", "metadata.json", ".fixtures.yml"));
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PuppetProjectManager myProjectManager;

    public PuppetProjectFilesListener(@NotNull Project project) {
        if (project == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myProjectManager = PuppetProjectManager.getInstance(project);
    }

    private static boolean isOurFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(1);
        }
        return !virtualFile.isDirectory() && KEY_FILE_NAMES.contains(virtualFile.getName());
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        VirtualFile eventFile;
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(2);
        }
        if (PuppetProjectFilesListener.isOurFile(eventFile = event.getFile())) {
            this.myProjectManager.updateMetadata(eventFile.getParent());
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(3);
        }
        if (KEY_FILE_NAMES.contains(event.getFileName())) {
            this.myProjectManager.updateMetadata(event.getParent());
        }
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        VirtualFile eventFile;
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(4);
        }
        if ((eventFile = event.getFile()).isDirectory()) {
            PuppetProjectManager puppetProjectManager = PuppetProjectManager.getInstance(this.myProject);
            for (VirtualFile root : puppetProjectManager.getAllRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)eventFile, (VirtualFile)root, (boolean)false)) continue;
                puppetProjectManager.clearMetaData(root);
            }
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        VirtualFile eventFile;
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(5);
        }
        if (PuppetProjectFilesListener.isOurFile(eventFile = event.getFile())) {
            this.myProjectManager.updateMetadata(eventFile.getParent());
        } else if (eventFile.isDirectory()) {
            PuppetProjectManager puppetProjectManager = PuppetProjectManager.getInstance(this.myProject);
            VirtualFile dependencyOwnerRoot = this.getPossibleDependencyOwnerRoot(eventFile);
            if (dependencyOwnerRoot != null) {
                puppetProjectManager.updateMetadata(dependencyOwnerRoot);
            }
        }
    }

    @Nullable
    private VirtualFile getPossibleDependencyOwnerRoot(@NotNull VirtualFile possibleDependency) {
        if (possibleDependency == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(6);
        }
        VirtualFile possibleDependencyRoot = possibleDependency.getParent();
        PuppetEntity containingEntity = PuppetProjectManager.getInstance(this.myProject).findExplicitModuleOrEnvironmentForFile(possibleDependencyRoot);
        if (containingEntity == null || !containingEntity.isValid()) {
            return null;
        }
        for (VirtualFile dependencyRoot : containingEntity.getAllDependenciesRoots()) {
            if (dependencyRoot == null || !dependencyRoot.equals(possibleDependencyRoot)) continue;
            return containingEntity.getRoot();
        }
        return null;
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(7);
        }
        PuppetProjectManager.getInstance(this.myProject).rescanProjectStructure();
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            PuppetProjectFilesListener.$$$reportNull$$$0(8);
        }
        PuppetProjectManager.getInstance(this.myProject).rescanProjectStructure();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleDependency";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/project/PuppetProjectFilesListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isOurFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contentsChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDeleted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeFileDeletion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileCreated";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPossibleDependencyOwnerRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileMoved";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

