/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetScopeManager;
import com.intellij.lang.puppet.project.meta.PuppetMetadata;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetEntity<T extends PuppetMetadata> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final T myMetadata;
    private final AtomicNullableLazyValue<Module> myModuleProvider;

    public PuppetEntity(@NotNull Project project, @NotNull VirtualFile root, @NotNull T metadata) {
        if (project == null) {
            PuppetEntity.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PuppetEntity.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            PuppetEntity.$$$reportNull$$$0(2);
        }
        this.myModuleProvider = new AtomicNullableLazyValue<Module>(){

            @Nullable
            protected Module compute() {
                return ModuleUtilCore.findModuleForFile((VirtualFile)PuppetEntity.this.getRoot(), (Project)PuppetEntity.this.getProject());
            }
        };
        this.myProject = project;
        this.myRoot = root;
        this.myMetadata = metadata;
    }

    @NotNull
    public String getName() {
        String name = this.getMetadata().getName();
        String string = name == null ? this.getRoot().getName() : name;
        if (string == null) {
            PuppetEntity.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Module getIdeaModule() {
        return (Module)this.myModuleProvider.getValue();
    }

    @NotNull
    public abstract String getLibrarianDependenciesRootName();

    public boolean isUnderDependenciesRoot(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PuppetEntity.$$$reportNull$$$0(4);
        }
        return this.isValid() && PuppetEntity.isUnderRoot(virtualFile, this.getAllDependenciesRoots());
    }

    protected static boolean isUnderRoot(@NotNull VirtualFile target, @NotNull List<VirtualFile> roots) {
        if (target == null) {
            PuppetEntity.$$$reportNull$$$0(5);
        }
        if (roots == null) {
            PuppetEntity.$$$reportNull$$$0(6);
        }
        return VfsUtilCore.isUnder((VirtualFile)target, (Set)ContainerUtil.newHashSet(roots));
    }

    @NotNull
    public abstract List<VirtualFile> getAllDependenciesRoots();

    @Nullable
    protected VirtualFile getLibrarianDependenciesRoot() {
        if (!this.isValid()) {
            return null;
        }
        return this.myRoot.findChild(this.getLibrarianDependenciesRootName());
    }

    public boolean isValid() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myRoot.isValid() && !this.myProject.isDisposed();
    }

    @NotNull
    public abstract String getDescriptiveName();

    @NotNull
    public abstract List<PuppetModule> getDependencies();

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PuppetEntity.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            PuppetEntity.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    @NotNull
    public T getMetadata() {
        T t = this.myMetadata;
        if (t == null) {
            PuppetEntity.$$$reportNull$$$0(9);
        }
        return t;
    }

    public GlobalSearchScope getResolveScope() {
        return PuppetScopeManager.getInstance(this.myProject).getResolveScope(this);
    }

    @NotNull
    protected abstract List<String> getMeaningfulSubDirectoryNames();

    @Nullable
    public VirtualFile getPuppetFile() {
        return this.isValid() ? this.getRoot().findChild("Puppetfile") : null;
    }

    @Nullable
    public PuppetDependencyManagerAdapter getDependencyManager() {
        for (PuppetDependencyManagerAdapter adapter : PuppetDependencyManagerAdapter.getExtensions()) {
            if (!adapter.isApplicable(this)) continue;
            return adapter;
        }
        return null;
    }

    @Nullable
    GlobalSearchScope calcResolveScope() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        GlobalSearchScope baseScope = this.getResolveScopeWithoutDependencies();
        for (PuppetModule dependency : this.getDependencies()) {
            GlobalSearchScope dependencyScope = super.getResolveScopeWithoutDependencies();
            if (dependencyScope == GlobalSearchScope.EMPTY_SCOPE) continue;
            baseScope = baseScope.uniteWith(dependencyScope);
        }
        VirtualFile stubsRoot = PuppetLibraryUtil.getStubsRoot();
        return stubsRoot == null ? baseScope : baseScope.uniteWith(GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)stubsRoot, (boolean)true));
    }

    @NotNull
    private GlobalSearchScope getResolveScopeWithoutDependencies() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isValid()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                PuppetEntity.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        ArrayList<VirtualFile> subDirs = new ArrayList<VirtualFile>();
        for (String dirName : this.getMeaningfulSubDirectoryNames()) {
            VirtualFile child = this.myRoot.findChild(dirName);
            if (child == null) continue;
            subDirs.add(child);
        }
        GlobalSearchScope globalSearchScope = subDirs.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScopesCore.directoriesScope((Project)this.myProject, (boolean)true, (VirtualFile[])subDirs.toArray(VirtualFile.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PuppetEntity.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PuppetEntity entity = (PuppetEntity)o;
        if (!this.myProject.equals(entity.myProject)) {
            return false;
        }
        if (!this.myRoot.equals(entity.myRoot)) {
            return false;
        }
        return this.myMetadata.equals(entity.myMetadata);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myRoot.hashCode();
        result = 31 * result + this.myMetadata.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetEntity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetEntity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadata";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScopeWithoutDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnderDependenciesRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

