/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.lexer;

import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class PuppetLexerAdapter
extends MergingLexerAdapter
implements PuppetTokenTypes {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{COMMENT, TokenType.WHITE_SPACE});
    private final MergeFunction myMergeFunction = new PuppetLexerMergeFunction(super.getMergeFunction());

    public PuppetLexerAdapter(@Nullable Project project) {
        super((Lexer)new FlexAdapter((FlexLexer)new PuppetLexer(project)), TOKENS_TO_MERGE);
    }

    public MergeFunction getMergeFunction() {
        return this.myMergeFunction;
    }

    private static class PuppetLexerMergeFunction
    implements MergeFunction {
        private final MergeFunction myDelegate;

        public PuppetLexerMergeFunction(MergeFunction delegate) {
            this.myDelegate = delegate;
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (type == PuppetTokenTypes.DOUBLE_QUOTED_STRING_START && originalLexer.getTokenType() == PuppetTokenTypes.DOUBLE_QUOTED_STRING_END) {
                originalLexer.advance();
                return PuppetTokenTypes.DOUBLE_QUOTED_STRING;
            }
            return this.myDelegate.merge(type, originalLexer);
        }
    }
}

