/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightElement;
import com.intellij.lang.puppet.psi.PuppetNodeDefinition;
import com.intellij.lang.puppet.psi.PuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.util.PuppetQualifiedNamesUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetItemPresentation<T extends NavigatablePsiElement>
implements ItemPresentation {
    protected String myName;
    protected String myLocation;
    protected T myDelegate;

    public static PuppetItemPresentation create(String name, NavigatablePsiElement delegate) {
        return PuppetItemPresentation.create(name, null, delegate);
    }

    public static PuppetItemPresentation create(String name, String location, NavigatablePsiElement delegate) {
        if (delegate instanceof PuppetDelegatingLightElement) {
            delegate = ((PuppetDelegatingLightElement)delegate).getDelegate();
        }
        if (delegate instanceof PuppetVariable) {
            return new VariablePresentation(name, location, (PuppetVariable)delegate);
        }
        if (delegate instanceof PuppetResourceInstanceDeclaration) {
            return new ResourceInstancePresentation(name, location, (PuppetResourceInstanceDeclaration)delegate);
        }
        if (delegate instanceof PuppetNodeDefinition) {
            return new NodePresentation(name, location, (PuppetNodeDefinition)delegate);
        }
        if (delegate instanceof PuppetClassDefinition) {
            return new ClassPresentation(name, location, (PuppetClassDefinition)delegate);
        }
        return new DefaultPresentation(name, location, (NavigatablePsiElement)delegate);
    }

    private PuppetItemPresentation(String name, String location, T delegate) {
        this.myName = name;
        this.myDelegate = delegate;
        this.myLocation = location;
    }

    @Nullable
    public String getPresentableText() {
        return this.myName;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.myDelegate.getIcon(0);
    }

    @Nullable
    public String getLocationString() {
        if (this.myLocation == null) {
            this.myLocation = this.computeLocationString();
        }
        return this.myLocation;
    }

    @Nullable
    protected String computeLocationString() {
        if (!this.myDelegate.isValid()) {
            return null;
        }
        VirtualFile vFile = this.myDelegate.getContainingFile().getVirtualFile();
        if (vFile != null) {
            String relativePath;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myDelegate.getProject()).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(vFile);
            if (contentRoot == null) {
                contentRoot = fileIndex.getClassRootForFile(vFile);
            }
            if (contentRoot != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile, (VirtualFile)contentRoot)) != null) {
                return relativePath;
            }
        }
        return null;
    }

    /* synthetic */ PuppetItemPresentation(String x0, String x1, NavigatablePsiElement x2, 1 x3) {
        this(x0, x1, x2);
    }

    private static class ResourceInstancePresentation
    extends PuppetItemPresentation<PuppetResourceInstanceDeclaration> {
        public ResourceInstancePresentation(String name, String location, PuppetResourceInstanceDeclaration delegate) {
            super(name, location, delegate, null);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            String name;
            int delimiteroffset = this.myName.lastIndexOf("@");
            String string = name = delimiteroffset == -1 ? this.myName : this.myName.substring(delimiteroffset + 1);
            if ("default - the real one".equals(name)) {
                return "[default]";
            }
            if ("resource with heavy name".equals(name)) {
                return "???";
            }
            return name;
        }

        @Override
        @Nullable
        protected String computeLocationString() {
            return "[" + PuppetQualifiedNamesUtil.capitalizePuppetName(((PuppetResourceInstanceDeclaration)this.myDelegate).getEffectiveTypeName()) + "] in " + super.computeLocationString();
        }
    }

    private static class NodePresentation
    extends PuppetItemPresentation<PuppetNodeDefinition> {
        public NodePresentation(String name, String location, PuppetNodeDefinition delegate) {
            super(name, location, delegate, null);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return "default - the real one".equals(this.myName) ? "[default]" : this.myName;
        }
    }

    private static class ClassPresentation
    extends PuppetItemPresentation<PuppetClassDefinition> {
        public ClassPresentation(String name, String location, PuppetClassDefinition delegate) {
            super(name, location, delegate, null);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return ((PuppetClassDefinition)this.myDelegate).getFullQualifiedName();
        }
    }

    private static class VariablePresentation
    extends PuppetItemPresentation<PuppetVariable> {
        public VariablePresentation(String name, String location, PuppetVariable delegate) {
            super(name, location, delegate, null);
        }

        @Override
        @Nullable
        public String getPresentableText() {
            return "$" + super.getPresentableText();
        }

        @Override
        @Nullable
        public String getLocationString() {
            if (((PuppetVariable)this.myDelegate).isMetaparameter()) {
                return PuppetBundle.message("puppet.metaparameter", new Object[0]);
            }
            if (((PuppetVariable)this.myDelegate).isCoreFact()) {
                return PuppetBundle.message("puppet.fact", new Object[0]);
            }
            return super.getLocationString();
        }
    }

    private static class DefaultPresentation
    extends PuppetItemPresentation<NavigatablePsiElement> {
        public DefaultPresentation(String name, String location, NavigatablePsiElement delegate) {
            super(name, location, delegate, null);
        }
    }
}

