/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetHighlightUsagesHandlerBase
extends HighlightUsagesHandlerBase<PsiElement>
implements PuppetTokenTypes {
    public PuppetHighlightUsagesHandlerBase(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(1);
        }
        super(editor, file);
    }

    protected void addWriteUsage(@NotNull PsiElement element) {
        if (element == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(2);
        }
        this.addUsageRange(this.myWriteUsages, PuppetHighlightUsagesHandlerBase.getRangeToHighlight(element), element);
    }

    protected void addUsageRange(List<TextRange> result, TextRange range, PsiElement element) {
        if (range != null) {
            range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
            result.add(range);
        }
    }

    protected List<PsiElement> getTargetsWithSynonyms(@NotNull PsiFile currentFile, @NotNull Collection<PsiElement> currentTargets) {
        if (currentFile == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(3);
        }
        if (currentTargets == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(4);
        }
        THashSet result = new THashSet();
        THashSet processedSynonyms = new THashSet();
        for (PsiElement targetElement : currentTargets) {
            if (result.add(targetElement) && currentFile.equals(targetElement.getContainingFile())) {
                this.addWriteUsage(targetElement.getNavigationElement());
            }
            PuppetResolveUtil.processElementSynonims(targetElement, (PsiElement)currentFile, (Set<String>)processedSynonyms, (PsiElementProcessor<PsiElement>)((PsiElementProcessor)arg_0 -> this.lambda$getTargetsWithSynonyms$0((Set)result, currentFile, arg_0)));
        }
        return new ArrayList<PsiElement>((Collection<PsiElement>)result);
    }

    protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(List<PsiElement> targets) {
        for (PsiElement target : targets) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)target, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.myFile))) {
                PsiElement sourceElement = reference.getElement();
                this.addUsageRange(this.myReadUsages, reference.getRangeInElement().shiftRight(sourceElement.getNode().getStartOffset()), sourceElement);
            }
        }
    }

    @Nullable
    private static TextRange getRangeToHighlight(PsiElement element) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        return manipulator == null ? element.getTextRange() : manipulator.getRangeInElement(element).shiftRight(element.getNode().getStartOffset());
    }

    private /* synthetic */ boolean lambda$getTargetsWithSynonyms$0(Set result, @NotNull PsiFile currentFile, PsiElement synonym) {
        if (currentFile == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(5);
        }
        if (result.add(synonym) && currentFile.equals(synonym.getContainingFile())) {
            this.addWriteUsage(synonym.getNavigationElement());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTargets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/highlighting/PuppetHighlightUsagesHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addWriteUsage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetsWithSynonyms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getTargetsWithSynonyms$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

