/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.actions;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.adapters.PuppetDependencyManagerAdapter;
import com.intellij.lang.puppet.ide.actions.PuppetBaseAction;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class PuppetInstallDependenciesAction
extends PuppetBaseAction {
    public PuppetInstallDependenciesAction() {
        super(PuppetBundle.message("puppet.action.install.dependencies.default", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        PuppetEntity puppetEntity = PuppetInstallDependenciesAction.getPuppetEntityFromEvent(e);
        assert (puppetEntity != null);
        PuppetDependencyManagerAdapter dependencyManager = puppetEntity.getDependencyManager();
        assert (dependencyManager != null);
        dependencyManager.installDependencies(puppetEntity);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        PuppetEntity puppetEntity = PuppetInstallDependenciesAction.getPuppetEntityFromEvent(e);
        if (puppetEntity == null || puppetEntity.getDependencyManager() == null) {
            presentation.setEnabledAndVisible(false);
        } else {
            presentation.setEnabledAndVisible(true);
            presentation.setText(PuppetBundle.message("puppet.action.install.dependencies", puppetEntity.getDescriptiveName(), puppetEntity.getName()));
        }
    }

    @Nullable
    protected static PuppetEntity getPuppetEntityFromEvent(AnActionEvent e) {
        VirtualFile eventFile = PuppetInstallDependenciesAction.getFileFromEvent(e);
        if (eventFile == null || e.getProject() == null) {
            return null;
        }
        return PuppetProjectManager.getInstance(e.getProject()).findModuleOrEnvironmentForFile(eventFile);
    }
}

