/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.settings.tree;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckedTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class DiagramSettingsTreeNode
extends CheckedTreeNode {
    private static final Vector<DiagramSettingsTreeNode> EMPTY_VECTOR = new Vector();
    private boolean myChanged;
    private boolean isBuildingTree = true;
    private boolean myInitialValue;

    public DiagramSettingsTreeNode(Object element, DiagramConfiguration configuration) {
        super(element);
        if (element instanceof DiagramConfiguration) {
            for (DiagramProvider provider : (DiagramProvider[])DiagramProvider.DIAGRAM_PROVIDER.getExtensions()) {
                if ((provider.getNodeContentManager().getContentCategories().length <= 0 || !provider.getNodeContentManager().isEditCategoriesSettings()) && provider.getExtras().getAdditionalDiagramSettings().length <= 0) continue;
                this.initChildren();
                DiagramSettingsTreeNode node = new DiagramSettingsTreeNode(provider, configuration);
                this.children.add(node);
                node.setParent((MutableTreeNode)((Object)this));
            }
        } else if (element instanceof DiagramProvider) {
            DiagramProvider provider = (DiagramProvider)element;
            this.initChildren();
            this.children.addAll(DiagramSettingsTreeNode.buildCheckedNodes(this, configuration, provider.getNodeContentManager().getContentCategories()));
            this.children.addAll(DiagramSettingsTreeNode.buildCheckedNodes(this, configuration, provider.getExtras().getAdditionalDiagramSettings()));
        } else if (element instanceof DiagramConfigGroup) {
            List configElements = ((DiagramConfigGroup)element).getElements();
            this.initChildren();
            this.children.addAll(DiagramSettingsTreeNode.buildCheckedNodes(this, configuration, configElements.toArray(new Object[]{configElements.size()})));
        }
    }

    public void init(DiagramConfiguration configuration) {
        DiagramCategory cat;
        DiagramProvider provider;
        Object object = this.getUserObject();
        if (object instanceof DiagramCategory) {
            provider = (DiagramProvider)this.getParent().getUserObject();
            cat = (DiagramCategory)object;
            this.setChecked(configuration.isEnabledByDefault(provider, cat.getName()));
        } else if (object instanceof DiagramConfigElement) {
            provider = (DiagramProvider)this.getParent().getParent().getUserObject();
            cat = (DiagramConfigElement)object;
            this.setChecked(configuration.isEnabledByDefault(provider, cat.getName()));
        }
        if (this.children != null) {
            for (DiagramSettingsTreeNode node : this.getChildren()) {
                node.init(configuration);
            }
        }
    }

    private void initChildren() {
        if (this.children == null) {
            this.children = new Vector();
        }
    }

    public boolean isRoot() {
        return this.getUserObject() instanceof DiagramConfiguration;
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        if (!this.isBuildingTree) {
            this.setChanged(true);
        }
    }

    public void setChanged(boolean changed) {
        DiagramSettingsTreeNode parentNode;
        if (!this.myChanged && changed && (parentNode = this.getParent()) instanceof DiagramSettingsTreeNode) {
            parentNode.setChanged(changed);
        }
        this.myChanged = changed;
    }

    public boolean isChanged() {
        return this.myChanged;
    }

    public void resetChangeStatus() {
        this.myChanged = false;
        if (this.children != null) {
            for (Object child : this.children) {
                ((DiagramSettingsTreeNode)((Object)child)).resetChangeStatus();
            }
        }
    }

    public void stopBuilding() {
        this.isBuildingTree = false;
        this.myInitialValue = this.isChecked();
        if (this.children != null) {
            for (DiagramSettingsTreeNode child : this.getChildren()) {
                child.stopBuilding();
            }
        }
    }

    public void reset() {
        this.isBuildingTree = true;
        this.setChecked(this.myInitialValue);
        this.myChanged = false;
        if (this.children != null) {
            for (DiagramSettingsTreeNode child : this.getChildren()) {
                child.reset();
            }
        }
        this.isBuildingTree = false;
    }

    public void apply(DiagramConfiguration configuration) {
        this.myInitialValue = this.isChecked();
        this.myChanged = false;
        Object object = this.getUserObject();
        if (object instanceof DiagramConfiguration) {
            DiagramSettingsTreeNode.applyChangesToConfiguration(this, configuration);
        }
        if (this.children != null) {
            for (DiagramSettingsTreeNode child : this.getChildren()) {
                child.apply(configuration);
            }
        }
    }

    private static void applyChangesToConfiguration(DiagramSettingsTreeNode root, DiagramConfiguration configuration) {
        HashMap<String, String> categories = new HashMap<String, String>();
        for (DiagramSettingsTreeNode providerNode : root.getChildren()) {
            DiagramProvider provider = (DiagramProvider)providerNode.getUserObject();
            ArrayList<String> changed = new ArrayList<String>();
            for (DiagramSettingsTreeNode catNode : providerNode.getChildren()) {
                Object object = catNode.getUserObject();
                if (object instanceof DiagramCategory) {
                    DiagramCategory category = (DiagramCategory)object;
                    if (category.isEnabledByDefault() == catNode.isChecked()) continue;
                    changed.add(category.getName());
                    continue;
                }
                if (!(object instanceof DiagramConfigGroup)) continue;
                for (DiagramSettingsTreeNode extra : catNode.getChildren()) {
                    DiagramConfigElement element = (DiagramConfigElement)extra.getUserObject();
                    if (element.isChecked() == extra.isChecked()) continue;
                    changed.add(element.getName());
                }
            }
            if (changed.isEmpty()) continue;
            categories.put(provider.getID(), StringUtil.join(changed, (String)";"));
        }
        configuration.categories = categories;
    }

    public DiagramSettingsTreeNode getParent() {
        return (DiagramSettingsTreeNode)((Object)super.getParent());
    }

    private static Collection<DiagramSettingsTreeNode> buildCheckedNodes(DiagramSettingsTreeNode parent, DiagramConfiguration configuration, Object[] objects) {
        ArrayList<DiagramSettingsTreeNode> nodes = new ArrayList<DiagramSettingsTreeNode>();
        for (Object object : objects) {
            DiagramSettingsTreeNode node = new DiagramSettingsTreeNode(object, configuration);
            node.setParent((MutableTreeNode)((Object)parent));
            nodes.add(node);
        }
        return nodes;
    }

    @NotNull
    public Vector<DiagramSettingsTreeNode> getChildren() {
        Vector vector = this.children != null ? this.children : EMPTY_VECTOR;
        if (vector == null) {
            DiagramSettingsTreeNode.$$$reportNull$$$0(0);
        }
        return vector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/settings/tree/DiagramSettingsTreeNode", "getChildren"));
    }
}

