/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    @Override
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    protected FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.getFileSystem(rootName, fileSystemOptions);
        return fs.resolveFile(name);
    }

    protected synchronized FileSystem getFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            fs = this.addFileSystem(rootName, fs);
        }
        return fs;
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;

    @Override
    public FileSystem findOrCreateFileSystem(String uri, FileSystemOptions fileSystemOptions, boolean onlyCached) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", (Object)uri, (Throwable)exc);
        }
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null && !onlyCached) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            fs = this.addFileSystem(rootName, fs);
        }
        return fs;
    }
}

