/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbUtil {
    private static final WeakStringInterner INTERNER = new WeakStringInterner();
    public static final Function<DbElement, Object> TO_DELEGATE = e -> e.getDelegate();

    private DbUtil() {
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSources(@NotNull Project project) {
        if (project == null) {
            DbUtil.$$$reportNull$$$0(0);
        }
        JBIterable jBIterable = JBIterable.from(DbPsiFacade.getInstance(project).getDataSources());
        if (jBIterable == null) {
            DbUtil.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Contract(value="!null->!null")
    public static String intern2(@Nullable String str) {
        return str == null ? null : INTERNER.intern(str);
    }

    @NotNull
    public static String intern(@Nullable String str) {
        String string = DbUtil.intern(str, "");
        if (string == null) {
            DbUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Contract(value="_, !null->!null")
    public static String intern(@Nullable String str, @Nullable String def) {
        return str == null || str.isEmpty() ? def : INTERNER.intern(str);
    }

    public static Set<String> getExistingDataSourceNames(Project project) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DbDataSource dataSource : DbPsiFacade.getInstance(project).getDataSources()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)dataSource.getName());
        }
        return result;
    }

    public static String createNewDataSourceName(@NotNull Project project, @NotNull String baseName) {
        if (project == null) {
            DbUtil.$$$reportNull$$$0(3);
        }
        if (baseName == null) {
            DbUtil.$$$reportNull$$$0(4);
        }
        return DbUtil.createNewDataSourceName(baseName, DbUtil.getExistingDataSourceNames(project));
    }

    public static String createNewDataSourceName(@NotNull String baseName, Set<String> existingNames) {
        Matcher matcher;
        if (baseName == null) {
            DbUtil.$$$reportNull$$$0(5);
        }
        String fixedName = (matcher = Pattern.compile("([^\\[]*)(?:\\[\\d+])?").matcher(baseName)).matches() ? matcher.group(1).trim() : baseName;
        return new UniqueNameGenerator(existingNames, FunctionUtil.id()).generateUniqueName(fixedName, "", "", " [", "]");
    }

    public static boolean isCaseSensitive(@Nullable String name, @NotNull DbElement source) {
        if (source == null) {
            DbUtil.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        Casing modes = source.getDataSource().getModel().getCasing(source.getKind(), source);
        return DbUtil.isCaseSensitive(name, modes);
    }

    public static boolean isCaseSensitive(@Nullable String name, Casing modes) {
        return Case.guessForName(name, null, modes.plain, modes.quoted) == Case.EXACT;
    }

    @NotNull
    public static String[] intern(@NotNull String[] arr) {
        if (arr == null) {
            DbUtil.$$$reportNull$$$0(7);
        }
        String[] stringArray = (String[])ContainerUtil.map((Object[])arr, str -> DbUtil.intern(str, null), (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            DbUtil.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DbDataSource ? (DasObject)object : (object instanceof DbElement ? (DasObject)((DbElement)object).getDelegate() : (object instanceof DasObject ? (DasObject)object : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNewDataSourceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitive";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

