/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogStandardColors;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.impl.SimpleRefGroup;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class HgRefManager
implements VcsLogRefManager {
    private static final Color CLOSED_BRANCH_COLOR = new JBColor(new Color(8532281), new Color(0xFF5F6F));
    private static final Color LOCAL_TAG_COLOR = new JBColor(new Color(37008), new Color(62451));
    private static final Color MQ_TAG_COLOR = new JBColor(new Color(12176), new Color(22015));
    public static final VcsRefType TIP = new SimpleRefType("TIP", true, VcsLogStandardColors.Refs.TIP);
    public static final VcsRefType HEAD = new SimpleRefType("HEAD", true, VcsLogStandardColors.Refs.LEAF);
    public static final VcsRefType BRANCH = new SimpleRefType("BRANCH", true, VcsLogStandardColors.Refs.BRANCH);
    public static final VcsRefType CLOSED_BRANCH = new SimpleRefType("CLOSED_BRANCH", false, CLOSED_BRANCH_COLOR);
    public static final VcsRefType BOOKMARK = new SimpleRefType("BOOKMARK", true, VcsLogStandardColors.Refs.BRANCH_REF);
    public static final VcsRefType TAG = new SimpleRefType("TAG", false, VcsLogStandardColors.Refs.TAG);
    public static final VcsRefType LOCAL_TAG = new SimpleRefType("LOCAL_TAG", false, LOCAL_TAG_COLOR);
    public static final VcsRefType MQ_APPLIED_TAG = new SimpleRefType("MQ_TAG", false, MQ_TAG_COLOR);
    private static final List<VcsRefType> REF_TYPE_PRIORITIES = Arrays.asList(TIP, HEAD, BRANCH, BOOKMARK, TAG);
    private static final List<VcsRefType> REF_TYPE_INDEX = Arrays.asList(TIP, HEAD, BRANCH, CLOSED_BRANCH, BOOKMARK, TAG, LOCAL_TAG, MQ_APPLIED_TAG);
    public static final Comparator<VcsRefType> REF_TYPE_COMPARATOR = (type1, type2) -> {
        int p1 = REF_TYPE_PRIORITIES.indexOf(type1);
        int p2 = REF_TYPE_PRIORITIES.indexOf(type2);
        return p1 - p2;
    };
    public static final String DEFAULT = "default";
    private final Comparator<VcsRef> REF_COMPARATOR = (ref1, ref2) -> {
        VcsRefType type2;
        VcsRefType type1 = ref1.getType();
        int typeComparison = REF_TYPE_COMPARATOR.compare(type1, type2 = ref2.getType());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int nameComparison = ref1.getName().compareTo(ref2.getName());
        if (nameComparison != 0) {
            if (type1 == BRANCH) {
                if (ref1.getName().equals(DEFAULT)) {
                    return -1;
                }
                if (ref2.getName().equals(DEFAULT)) {
                    return 1;
                }
            }
            return nameComparison;
        }
        return VcsLogUtil.compareRoots((VirtualFile)ref1.getRoot(), (VirtualFile)ref2.getRoot());
    };

    @NotNull
    public Comparator<VcsRef> getLabelsOrderComparator() {
        Comparator<VcsRef> comparator = this.REF_COMPARATOR;
        if (comparator == null) {
            HgRefManager.$$$reportNull$$$0(0);
        }
        return comparator;
    }

    @NotNull
    public List<RefGroup> groupForBranchFilter(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            HgRefManager.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.map(this.sort(refs), ref -> new SingletonRefGroup(ref));
        if (list == null) {
            HgRefManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<RefGroup> groupForTable(@NotNull Collection<VcsRef> references, boolean compact, boolean showTagNames) {
        if (references == null) {
            HgRefManager.$$$reportNull$$$0(3);
        }
        List<VcsRef> sortedReferences = this.sort(references);
        ArrayList headAndTip = ContainerUtil.newArrayList();
        MultiMap groupedRefs = MultiMap.createLinked();
        for (VcsRef ref : sortedReferences) {
            if (ref.getType().equals(HEAD) || ref.getType().equals(TIP)) {
                headAndTip.add(ref);
                continue;
            }
            groupedRefs.putValue((Object)ref.getType(), (Object)ref);
        }
        ArrayList result = ContainerUtil.newArrayList();
        SimpleRefGroup.buildGroups((MultiMap)groupedRefs, (boolean)compact, (boolean)showTagNames, (List)result);
        RefGroup firstGroup = (RefGroup)ContainerUtil.getFirstItem((List)result);
        if (firstGroup != null) {
            firstGroup.getRefs().addAll(0, headAndTip);
        } else {
            result.add(new SimpleRefGroup("", (List)headAndTip));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            HgRefManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void serialize(@NotNull DataOutput out, @NotNull VcsRefType type) throws IOException {
        if (out == null) {
            HgRefManager.$$$reportNull$$$0(5);
        }
        if (type == null) {
            HgRefManager.$$$reportNull$$$0(6);
        }
        out.writeInt(REF_TYPE_INDEX.indexOf(type));
    }

    @NotNull
    public VcsRefType deserialize(@NotNull DataInput in) throws IOException {
        int id;
        if (in == null) {
            HgRefManager.$$$reportNull$$$0(7);
        }
        if ((id = in.readInt()) < 0 || id > REF_TYPE_INDEX.size() - 1) {
            throw new IOException("Reference type by id " + id + " does not exist");
        }
        VcsRefType vcsRefType = REF_TYPE_INDEX.get(id);
        if (vcsRefType == null) {
            HgRefManager.$$$reportNull$$$0(8);
        }
        return vcsRefType;
    }

    @NotNull
    public Comparator<VcsRef> getBranchLayoutComparator() {
        Comparator<VcsRef> comparator = this.REF_COMPARATOR;
        if (comparator == null) {
            HgRefManager.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    @NotNull
    private List<VcsRef> sort(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            HgRefManager.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.sorted(refs, this.getLabelsOrderComparator());
        if (list == null) {
            HgRefManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgRefManager";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsOrderComparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgRefManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "groupForBranchFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "groupForTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchLayoutComparator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "groupForBranchFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "groupForTable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleRefType
    implements VcsRefType {
        @NotNull
        private final String myName;
        private final boolean myIsBranch;
        @NotNull
        private final Color myColor;

        public SimpleRefType(@NotNull String name, boolean isBranch, @NotNull Color color) {
            if (name == null) {
                SimpleRefType.$$$reportNull$$$0(0);
            }
            if (color == null) {
                SimpleRefType.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myIsBranch = isBranch;
            this.myColor = color;
        }

        public boolean isBranch() {
            return this.myIsBranch;
        }

        @NotNull
        public Color getBackgroundColor() {
            Color color = this.myColor;
            if (color == null) {
                SimpleRefType.$$$reportNull$$$0(2);
            }
            return color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleRefType type = (SimpleRefType)o;
            return this.myIsBranch == type.myIsBranch && Objects.equals(this.myName, type.myName);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.myIsBranch);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/log/HgRefManager$SimpleRefType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBackgroundColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

