/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserStacktraceFilter
implements Filter {
    private final String myBrowserName;
    private final Function<String, File> myFileFinder;
    private final Project myProject;

    public BrowserStacktraceFilter(@NotNull Project project, @NotNull String browserName, @NotNull Function<String, File> fileFinder) {
        if (project == null) {
            BrowserStacktraceFilter.$$$reportNull$$$0(0);
        }
        if (browserName == null) {
            BrowserStacktraceFilter.$$$reportNull$$$0(1);
        }
        if (fileFinder == null) {
            BrowserStacktraceFilter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myBrowserName = browserName;
        this.myFileFinder = fileFinder;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        Pattern[] urlPatterns;
        HyperlinkBuilder hyperlinkBuilder = this.findHyperlinkBuilder();
        if (hyperlinkBuilder == null) {
            return null;
        }
        for (Pattern urlPattern : urlPatterns = hyperlinkBuilder.getAllPossibleUrlPatterns()) {
            int hyperlinkStartInd;
            String text;
            Matcher matcher = urlPattern.matcher(line);
            if (!matcher.find()) continue;
            if (matcher.groupCount() == 1) {
                text = matcher.group(1);
                hyperlinkStartInd = matcher.start(1);
            } else {
                if (matcher.groupCount() != 3) continue;
                text = matcher.group(3) + ":" + matcher.group(1);
                try {
                    int column = Integer.parseInt(matcher.group(2));
                    text = text + ":" + ++column;
                }
                catch (NumberFormatException column) {
                    // empty catch block
                }
                hyperlinkStartInd = matcher.start(3);
            }
            Filter.ResultItem resultItem = this.buildLineWithHyperlink(hyperlinkStartInd, text);
            if (resultItem == null) continue;
            if (matcher.groupCount() == 3) {
                return new Filter.Result(hyperlinkStartInd, matcher.end(3), resultItem.getHyperlinkInfo());
            }
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo());
        }
        return null;
    }

    @Nullable
    private Filter.ResultItem buildLineWithHyperlink(int hyperlinkStartInd, @NotNull String urlWithPositionStr) {
        HyperlinkInfo link;
        if (urlWithPositionStr == null) {
            BrowserStacktraceFilter.$$$reportNull$$$0(3);
        }
        UrlWithPosition urlWithPosition = UrlWithPosition.parse(urlWithPositionStr);
        int lineNumber = -1;
        int columnNumber = -1;
        TIntArrayList positions = urlWithPosition.getPositions();
        List positionStrings = urlWithPosition.getPositionStrings();
        int hyperlinkEndInd = hyperlinkStartInd + urlWithPosition.getUrl().length();
        if (positions.size() > 0) {
            lineNumber = positions.get(0);
            hyperlinkEndInd += 1 + ((String)positionStrings.get(0)).length();
            if (positions.size() > 1) {
                columnNumber = positions.get(1);
                hyperlinkEndInd += 1 + ((String)positionStrings.get(1)).length();
            }
        }
        if ((link = this.createHyperlinkInfo(this.myProject, urlWithPosition.getUrl(), Math.max(-1, lineNumber - 1), Math.max(-1, columnNumber - 1))) == null) {
            return null;
        }
        return new Filter.ResultItem(hyperlinkStartInd, hyperlinkEndInd, link);
    }

    @Nullable
    private HyperlinkInfo createHyperlinkInfo(Project project, @NotNull String url, int lineNumber, int columnNumber) {
        VirtualFile virtualFile;
        File file;
        if (url == null) {
            BrowserStacktraceFilter.$$$reportNull$$$0(4);
        }
        if ((file = (File)this.myFileFinder.fun((Object)url)) != null && (virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null) {
            return new OpenFileHyperlinkInfo(project, virtualFile, lineNumber, columnNumber);
        }
        return null;
    }

    @Nullable
    private HyperlinkBuilder findHyperlinkBuilder() {
        String browserName = this.myBrowserName.toLowerCase(Locale.US);
        if (browserName.startsWith("chrome")) {
            return ChromeHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("firefox")) {
            return FirefoxHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("opera")) {
            return OperaHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("safari")) {
            return SafariHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("ie") || browserName.contains("internet explorer")) {
            return IEHyperlinkBuilder.INSTANCE;
        }
        if (browserName.startsWith("phantomjs")) {
            return PhantomHyperlinkBuilder.INSTANCE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlWithPositionStr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLineWithHyperlink";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createHyperlinkInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UrlWithPosition {
        private final String myUrl;
        private final TIntArrayList myPositions;
        private final List<String> myPositionStrings;

        private UrlWithPosition(@NotNull String url, @NotNull TIntArrayList positions, @NotNull List<String> positionStrings) {
            if (url == null) {
                UrlWithPosition.$$$reportNull$$$0(0);
            }
            if (positions == null) {
                UrlWithPosition.$$$reportNull$$$0(1);
            }
            if (positionStrings == null) {
                UrlWithPosition.$$$reportNull$$$0(2);
            }
            this.myUrl = url;
            this.myPositions = positions;
            this.myPositionStrings = positionStrings;
        }

        private static UrlWithPosition parse(@NotNull String urlWithPosition) {
            String lineStr;
            int position;
            int closingBraceInd;
            int colonInd;
            if (urlWithPosition == null) {
                UrlWithPosition.$$$reportNull$$$0(3);
            }
            TIntArrayList positions = new TIntArrayList(2);
            ArrayList<String> positionStrings = new ArrayList<String>(2);
            int prevColonInd = urlWithPosition.length();
            while (positions.size() < 2 && (colonInd = urlWithPosition.lastIndexOf(58, prevColonInd - 1)) != -1) {
                try {
                    String positionStr = urlWithPosition.substring(colonInd + 1, prevColonInd);
                    int position2 = Integer.parseInt(positionStr);
                    positions.add(position2);
                    positionStrings.add(positionStr);
                    prevColonInd = colonInd;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            String lineInfo = " (line ";
            if (positions.isEmpty() && urlWithPosition.contains(lineInfo) && (prevColonInd = urlWithPosition.indexOf(lineInfo)) >= 0 && (closingBraceInd = urlWithPosition.indexOf(41, prevColonInd)) >= 0 && StringUtil.isEmptyOrSpaces((String)urlWithPosition.substring(closingBraceInd + 1)) && (position = StringUtil.parseInt((String)(lineStr = urlWithPosition.substring(prevColonInd + lineInfo.length(), closingBraceInd)), (int)-1)) >= 0) {
                positions.add(position);
                positionStrings.add(urlWithPosition.substring(prevColonInd, closingBraceInd));
            }
            positions.reverse();
            Collections.reverse(positionStrings);
            return new UrlWithPosition(urlWithPosition.substring(0, prevColonInd), positions, positionStrings);
        }

        @NotNull
        private String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                UrlWithPosition.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private TIntArrayList getPositions() {
            TIntArrayList tIntArrayList = this.myPositions;
            if (tIntArrayList == null) {
                UrlWithPosition.$$$reportNull$$$0(5);
            }
            return tIntArrayList;
        }

        @NotNull
        private List<String> getPositionStrings() {
            List<String> list = this.myPositionStrings;
            if (list == null) {
                UrlWithPosition.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "positions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "positionStrings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlWithPosition";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$UrlWithPosition";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPositions";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPositionStrings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhantomHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final PhantomHyperlinkBuilder INSTANCE = new PhantomHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*([^\\s].*)$"), Pattern.compile("^.* in ([^\\s].*)$")};

        private PhantomHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                PhantomHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return PATTERNS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$PhantomHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static class IEHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final IEHyperlinkBuilder INSTANCE = new IEHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*at.*\\(([^\\)]*)\\)$")};

        private IEHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                IEHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return PATTERNS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$IEHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static class SafariHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final SafariHyperlinkBuilder INSTANCE = new SafariHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^.*@([^\\(@]*)$")};

        private SafariHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                SafariHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return PATTERNS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$SafariHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static class OperaHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final OperaHyperlinkBuilder INSTANCE = new OperaHyperlinkBuilder();
        private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("^\\s*called from line (\\d+), column (\\d+) in .* in ([^:]*):$"), Pattern.compile("^.*\\(.*\\)@([^\\(@]*)$")};

        private OperaHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (PATTERNS == null) {
                OperaHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return PATTERNS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$OperaHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static class FirefoxHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final FirefoxHyperlinkBuilder INSTANCE = new FirefoxHyperlinkBuilder();
        private static final Pattern[] FIREFOX_URL_WITH_LINE = new Pattern[]{Pattern.compile("^.*@(.*)$")};

        private FirefoxHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (FIREFOX_URL_WITH_LINE == null) {
                FirefoxHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return FIREFOX_URL_WITH_LINE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$FirefoxHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static class ChromeHyperlinkBuilder
    extends HyperlinkBuilder {
        private static final ChromeHyperlinkBuilder INSTANCE = new ChromeHyperlinkBuilder();
        private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("^\\s*at\\s+([^\\s\\(].*)$"), Pattern.compile("^\\s*at\\s.*\\(([^\\(]*)\\)$")};

        private ChromeHyperlinkBuilder() {
        }

        @Override
        @NotNull
        public Pattern[] getAllPossibleUrlPatterns() {
            if (URL_PATTERNS == null) {
                ChromeHyperlinkBuilder.$$$reportNull$$$0(0);
            }
            return URL_PATTERNS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/BrowserStacktraceFilter$ChromeHyperlinkBuilder", "getAllPossibleUrlPatterns"));
        }
    }

    private static abstract class HyperlinkBuilder {
        private HyperlinkBuilder() {
        }

        @NotNull
        public abstract Pattern[] getAllPossibleUrlPatterns();
    }
}

