/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileIndexingHandler
extends FrameworkIndexingHandler {
    public void processFile(@NotNull JSFile psiFile, @NotNull JSFileCachedData data) {
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(0);
        }
        if (data == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(1);
        }
        if (JsTestFileIndexingHandler.shouldSkipFile(psiFile)) {
            return;
        }
        data.setTestFileType(JsTestFileIndexingHandler.getTestFileType(psiFile));
    }

    private static boolean shouldSkipFile(@NotNull JSFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(2);
        }
        if ((file = psiFile.getViewProvider().getVirtualFile()) instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        if (file == null || !file.isInLocalFileSystem()) {
            return true;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L)) {
            return true;
        }
        if (JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) {
            return true;
        }
        return TypeScriptUtil.isDefinitionFile((VirtualFile)file);
    }

    @Nullable
    private static JSTestFileType getTestFileType(@NotNull JSFile psiFile) {
        JasmineFileStructure jasmine;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(3);
        }
        if (!(jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile)).isEmpty()) {
            return JSTestFileType.JASMINE;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!qunit.isEmpty()) {
            return JSTestFileType.QUNIT;
        }
        MochaTddFileStructure tdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!tdd.isEmpty()) {
            return JSTestFileType.TDD;
        }
        return null;
    }

    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(4);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(5);
        }
        if (JsTestFileIndexingHandler.shouldSkipFile(file)) {
            return;
        }
        for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            JsTestFileIndexingHandler.putTestFileStructure(file, indexBuilder, builder);
        }
    }

    public static Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> getFileStructureBuilders() {
        return ContainerUtil.list((Object[])new AbstractTestFileStructureBuilder[]{JasmineFileStructureBuilder.getInstance(), QUnitFileStructureBuilder.getInstance(), MochaTddFileStructureBuilder.getInstance()});
    }

    public int getVersion() {
        return 10;
    }

    private static <T extends AbstractTestFileStructure> void putTestFileStructure(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder, @NotNull AbstractTestFileStructureBuilder<T> builder) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(6);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(8);
        }
        T testStructure = builder.buildTestFileStructure(file);
        indexBuilder.putAdditionalData(builder.KEY, testStructure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkipFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestFileType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "putTestFileStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

