/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FilePathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;

public class CompassSassScssTaskConsumerBase
extends BackgroundTaskConsumer {
    private final FileType myFileType;

    public CompassSassScssTaskConsumerBase(FileType type) {
        this.myFileType = type;
    }

    public boolean isAvailable(PsiFile file) {
        return file.getFileType() == this.myFileType && CompassSassScssTaskConsumerBase.isCompassSupportEnabled(ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
    }

    private static boolean isCompassSupportEnabled(@Nullable Module module) {
        CompassSettings compassSettings = CompassSassScssTaskConsumerBase.getCompassSettings(module);
        return compassSettings != null && compassSettings.isCompassSupportEnabled();
    }

    @Nullable
    private static CompassSettings getCompassSettings(@NotNull Project project) {
        if (project == null) {
            CompassSassScssTaskConsumerBase.$$$reportNull$$$0(0);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            CompassSettings moduleSettings = CompassSassScssTaskConsumerBase.getCompassSettings(module);
            if (moduleSettings == null || !moduleSettings.isCompassSupportEnabled()) continue;
            return moduleSettings;
        }
        return null;
    }

    @Nullable
    private static CompassSettings getCompassSettings(@Nullable Module module) {
        return module != null ? CompassSettings.getInstance(module) : null;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(SASSBundle.message("compass.file.watcher.name") + " " + this.myFileType.getName());
        options.setDescription("Compiles ." + this.myFileType.getDefaultExtension() + " files into .css files using compass");
        options.setFileExtension(this.myFileType.getDefaultExtension());
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setArguments("compile path/to/project $" + new FileNameMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            CompassSassScssTaskConsumerBase.$$$reportNull$$$0(1);
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        CompassSettings compassSettings;
        if (project == null) {
            CompassSassScssTaskConsumerBase.$$$reportNull$$$0(2);
        }
        if (options == null) {
            CompassSassScssTaskConsumerBase.$$$reportNull$$$0(3);
        }
        super.additionalConfiguration(project, file, options);
        Module module = file != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file) : null;
        CompassSettings compassSettings2 = compassSettings = module != null ? CompassSassScssTaskConsumerBase.getCompassSettings(module) : CompassSassScssTaskConsumerBase.getCompassSettings(project);
        if (compassSettings != null) {
            String configDir = VfsUtil.getParentDir((String)FileUtil.toSystemIndependentName((String)compassSettings.getCompassConfigPath()));
            ArrayList arguments = ContainerUtil.newArrayList((Object[])new String[]{"compile"});
            arguments.add(StringUtil.notNullize((String)configDir));
            arguments.add("$" + new UnixSeparatorsMacro().getName() + "($" + new FilePathMacro().getName() + "$)$");
            options.setArguments(ParametersListUtil.join((List)arguments));
            String compassExecutable = compassSettings.getCompassExecutableFilePath();
            options.setProgram(FileUtil.toSystemIndependentName((String)compassExecutable));
            options.setWorkingDir(FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)configDir)));
            options.setOutput(FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)configDir)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/watcher/CompassSassScssTaskConsumerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/watcher/CompassSassScssTaskConsumerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompassSettings";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "additionalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

