/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.parametersInspection;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.gherkin.PyBDDBundle;
import com.jetbrains.python.gherkin.parametersInspection.GetParamNamesFilter;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddParameterQuickFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PyFunction> myFunction;
    @NotNull
    private final List<Pair<String, String>> myParamNamesAndTypeInfo;

    AddParameterQuickFix(@NotNull List<Pair<String, String>> paramNameAndTypeInfos, @NotNull PyFunction function) {
        if (paramNameAndTypeInfos == null) {
            AddParameterQuickFix.$$$reportNull$$$0(0);
        }
        if (function == null) {
            AddParameterQuickFix.$$$reportNull$$$0(1);
        }
        this.myParamNamesAndTypeInfo = new ArrayList<Pair<String, String>>();
        this.myParamNamesAndTypeInfo.addAll(paramNameAndTypeInfos);
        this.myFunction = SmartPointerManager.createPointer((PsiElement)function);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.parameters.quick_fix.add_param", Lists.transform(this.myParamNamesAndTypeInfo, (Function)GetParamNamesFilter.INSTANCE));
        if (string == null) {
            AddParameterQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PyFunction function;
        if (project == null) {
            AddParameterQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddParameterQuickFix.$$$reportNull$$$0(4);
        }
        if ((function = (PyFunction)this.myFunction.getElement()) == null) {
            return;
        }
        PyDocstringGenerator docstringGenerator = PyDocstringGenerator.forDocStringOwner((PyDocStringOwner)function);
        for (Pair<String, String> pair : this.myParamNamesAndTypeInfo) {
            function.getParameterList().addParameter(PyElementGenerator.getInstance((Project)project).createParameter((String)pair.first));
            docstringGenerator.withParamTypedByName((String)pair.first, StringUtil.notNullize((String)((String)pair.second)));
        }
        if (!docstringGenerator.isNewMode() && docstringGenerator.hasParametersToAdd()) {
            docstringGenerator.buildAndInsert();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNameAndTypeInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/parametersInspection/AddParameterQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/parametersInspection/AddParameterQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

