/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.matchers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class ParseProcessor
implements Function<String, String> {
    private static final Pattern PARSE_PATTERN = Pattern.compile("\\{([a-zA-Z0-9_.-]*)(?::([a-zA-Z%]{1,2}))?\\}");
    @NotNull
    private static final Set<String> SUPPORTED_GROUPS = new HashSet<String>(Arrays.asList("w", "s", "d"));
    @NotNull
    private static final Map<String, String> TYPE_TO_REGEXP = new HashMap<String, String>();

    ParseProcessor() {
    }

    public String fun(@NotNull String param) {
        if (param == null) {
            ParseProcessor.$$$reportNull$$$0(0);
        }
        Matcher matcher = PARSE_PATTERN.matcher(StringUtil.escapeChar((String)param, (char)'['));
        StringBuffer builder = new StringBuffer().append('^');
        while (matcher.find()) {
            String argumentName = matcher.group(1);
            String argumentType = matcher.group(2);
            String argumentTypeRegex = ".";
            if (!StringUtil.isEmpty((String)argumentType)) {
                if (SUPPORTED_GROUPS.contains(argumentType.toLowerCase(Locale.getDefault()))) {
                    argumentTypeRegex = "\\\\" + argumentType;
                } else if (TYPE_TO_REGEXP.containsKey(argumentType)) {
                    argumentTypeRegex = TYPE_TO_REGEXP.get(argumentType);
                }
            }
            String regexp = StringUtil.isEmpty((String)argumentName) ? String.format("(%s+)", argumentTypeRegex) : String.format("(?P<%s>%s+)", argumentName, argumentTypeRegex);
            matcher.appendReplacement(builder, regexp);
        }
        matcher.appendTail(builder);
        return builder.append('$').toString();
    }

    static {
        TYPE_TO_REGEXP.put("b", "[10]");
        TYPE_TO_REGEXP.put("o", "[0-9A-Fa-f]");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/jetbrains/python/gherkin/matchers/ParseProcessor", "fun"));
    }
}

