/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.behave;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.jetbrains.python.gherkin.PyStepDefinition;
import com.jetbrains.python.gherkin.behave.PyBehaveStepDecorator;
import com.jetbrains.python.gherkin.behave.PyBehaveUtils;
import com.jetbrains.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.psi.PyDecorator;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

class PyBehaveStepDefinition
extends PyStepDefinition {
    private static final String[] WILDCARD_KEYWORDS = new String[]{"and", "but"};
    private static final String LINE_START_PREFIX = "^";
    private static final String LINE_END_POSTFIX = "$";

    PyBehaveStepDefinition(@NotNull PyDecorator stepDefinition) {
        if (stepDefinition == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(0);
        }
        super(stepDefinition, PyBehaveStepDefinition.getProcessor(stepDefinition.getContainingFile()));
    }

    @Nullable
    private static Function<String, String> getProcessor(@NotNull PsiFile file) {
        if (file == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(1);
        }
        return (Function)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                PyBehaveStepDefinition.$$$reportNull$$$0(7);
            }
            return new CachedValueProvider.Result(PyBehaveStepDefinition.getProcessorInternal(file), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static Function<String, String> getProcessorInternal(@NotNull PsiFile file) {
        PyBDDMatcher matcher;
        if (file == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(2);
        }
        if ((matcher = PyBehaveUtils.getRegexpMatcher(file)) == null) {
            return null;
        }
        return matcher.getPatternProcessor();
    }

    public boolean supportsStep(@NotNull PsiElement element) {
        if (element == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(3);
        }
        if (!(element instanceof GherkinStep)) {
            return false;
        }
        GherkinStep step = (GherkinStep)element;
        PyBehaveStepDecorator decorator = PyBehaveStepDecorator.getByDecorator(this.myPattern.getDecorator());
        String keyword = step.getKeyword().getText();
        if (decorator == null) {
            return false;
        }
        if (decorator.isWildCard()) {
            return true;
        }
        if (ArrayUtil.contains((String)keyword.toLowerCase(Locale.US), (String[])WILDCARD_KEYWORDS) && (keyword = PyBehaveStepDefinition.getPreviousKeyword(step)) == null) {
            return false;
        }
        return keyword.equalsIgnoreCase(decorator.getDecoratorName());
    }

    @Override
    @Nullable
    protected String getCucumberRegexFromElement(@NotNull PsiElement element) {
        String regexp;
        if (element == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(4);
        }
        if ((regexp = super.getCucumberRegexFromElement(element)) == null) {
            return null;
        }
        String result = regexp;
        if (!result.startsWith(LINE_START_PREFIX)) {
            result = LINE_START_PREFIX + result;
        }
        if (!regexp.endsWith(LINE_END_POSTFIX)) {
            result = result + LINE_END_POSTFIX;
        }
        return result;
    }

    @Override
    public final void setCucumberRegex(@NotNull String newValue) {
        String currentValue;
        if (newValue == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(5);
        }
        if ((currentValue = super.getCucumberRegexFromElement((PsiElement)this.myPattern.getDecorator())) != null) {
            if (!currentValue.startsWith(LINE_START_PREFIX)) {
                newValue = StringUtil.trimStart((String)newValue, (String)LINE_START_PREFIX);
            }
            if (!currentValue.endsWith(LINE_END_POSTFIX)) {
                newValue = StringUtil.trimEnd((String)newValue, (String)LINE_END_POSTFIX);
            }
            super.setCucumberRegex(newValue);
        }
    }

    @Nullable
    private static String getPreviousKeyword(@NotNull GherkinStep step) {
        GherkinStepsHolder scenario;
        if (step == null) {
            PyBehaveStepDefinition.$$$reportNull$$$0(6);
        }
        if ((scenario = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)step, GherkinStepsHolder.class)) == null) {
            return null;
        }
        Object[] siblings = scenario.getSteps();
        int index = ArrayUtil.find((Object[])siblings, (Object)step);
        if (index == -1) {
            return null;
        }
        for (int i = index - 1; i >= 0; --i) {
            String previousKeyword = siblings[i].getKeyword().getText();
            if (ArrayUtil.contains((String)previousKeyword.toLowerCase(Locale.US), (String[])WILDCARD_KEYWORDS)) continue;
            return previousKeyword;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveStepDefinition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessorInternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCucumberRegexFromElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setCucumberRegex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreviousKeyword";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getProcessor$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

