/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.behave;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.gherkin.PyBDDBundle;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionNames;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionParameters;
import com.jetbrains.python.gherkin.behave.PyBehaveJvmExtensionPoint;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.PyAddImportFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBehaveInspection
extends PyInspection {
    private static final String SUPPORTED_MATCHER = "re";
    @NotNull
    private final PyBehaveJvmExtensionPoint myBehave = new PyBehaveJvmExtensionPoint();

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("BDD Behave-specific inspection" == null) {
            PyBehaveInspection.$$$reportNull$$$0(0);
        }
        return "BDD Behave-specific inspection";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            PyBehaveInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            PyBehaveInspection.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return null;
        }
        PyFile pyFile = (PyFile)file;
        if (!this.myBehave.isFrameworkStepDefinition(pyFile)) {
            return null;
        }
        if (!PyBehaveInspection.hasFromBehaveImportStar(pyFile)) {
            return new ProblemDescriptor[]{new ProblemDescriptorBase((PsiElement)file, (PsiElement)file, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.no_star_import", new Object[0]), new LocalQuickFix[]{new PyAddImportFix(String.format("from %s import *", "behave"), pyFile)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, true, false)};
        }
        ArrayList<ProblemDescriptor> problemDescriptorList = new ArrayList<ProblemDescriptor>();
        PyBehaveInspection.ensureCorrectStepsFolderName(file, problemDescriptorList);
        if (problemDescriptorList.isEmpty()) {
            return null;
        }
        return problemDescriptorList.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean hasFromBehaveImportStar(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyBehaveInspection.$$$reportNull$$$0(3);
        }
        boolean hasFromBehaveImportStar = false;
        QualifiedName packageTopFind = QualifiedName.fromComponents((String[])new String[]{"behave"});
        for (PyFromImportStatement statement : pyFile.getFromImports()) {
            if (statement.getStarImportElement() == null || !packageTopFind.equals((Object)statement.getImportSourceQName())) continue;
            hasFromBehaveImportStar = true;
            break;
        }
        return hasFromBehaveImportStar;
    }

    private static void ensureCorrectStepsFolderName(@NotNull PsiFile file, @NotNull Collection<ProblemDescriptor> problemDescriptorList) {
        PsiDirectory fileDirectory;
        String dirName;
        if (file == null) {
            PyBehaveInspection.$$$reportNull$$$0(4);
        }
        if (problemDescriptorList == null) {
            PyBehaveInspection.$$$reportNull$$$0(5);
        }
        if (!(dirName = (fileDirectory = file.getContainingDirectory()).getName()).equals("steps")) {
            PsiDirectory fileGrandDirectory = fileDirectory.getParent();
            if (fileGrandDirectory == null) {
                return;
            }
            PsiDirectory realStepsFolder = fileGrandDirectory.findSubdirectory("steps");
            Object fix = realStepsFolder != null ? new PyBehaveMoveToFix(realStepsFolder) : new PyBehaveRenameFolderFix();
            problemDescriptorList.add((ProblemDescriptor)new ProblemDescriptorBase((PsiElement)file, (PsiElement)file, PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.wrong_folder", dirName), new LocalQuickFix[]{fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, true, false));
        }
    }

    private static void addNewStepMatcherCall(@NotNull PyFile file) {
        List block;
        if (file == null) {
            PyBehaveInspection.$$$reportNull$$$0(6);
        }
        if ((block = file.getImportBlock()).isEmpty()) {
            return;
        }
        PyImportStatementBase lastImport = (PyImportStatementBase)block.get(block.size() - 1);
        PyElementGenerator instance = PyElementGenerator.getInstance((Project)file.getProject());
        PyCallExpression expression = instance.createCallExpression(LanguageLevel.forElement((PsiElement)lastImport), PyBehaveFunctionNames.USE_STEP_MATCHER.getExpectedName());
        PyBehaveInspection.addMatcherArgument(expression);
        file.addAfter((PsiElement)expression, (PsiElement)lastImport);
    }

    private static void addMatcherArgument(@NotNull PyCallExpression expression) {
        if (expression == null) {
            PyBehaveInspection.$$$reportNull$$$0(7);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)expression.getProject());
        PyArgumentList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            argumentList.addArgument((PyExpression)generator.createStringLiteralFromString(SUPPORTED_MATCHER));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptorList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasFromBehaveImportStar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectStepsFolderName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addNewStepMatcherCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMatcherArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PyBehaveMoveToFix
    implements LocalQuickFix {
        @NotNull
        private final SmartPsiElementPointer<PsiDirectory> myDestination;

        PyBehaveMoveToFix(@NotNull PsiDirectory folder) {
            if (folder == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(0);
            }
            this.myDestination = SmartPointerManager.createPointer((PsiElement)folder);
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.fix_move", new Object[0]);
            if (string == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PyBehaveMoveToFix.$$$reportNull$$$0(3);
            }
            PsiFile fileToMove = descriptor.getPsiElement().getContainingFile();
            new MoveFilesOrDirectoriesProcessor(project, new PsiElement[]{fileToMove}, (PsiDirectory)this.myDestination.getElement(), true, true, true, null, null).run();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveMoveToFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveMoveToFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyBehaveRenameFolderFix
    implements LocalQuickFix {
        private PyBehaveRenameFolderFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.folder.fix_rename", new Object[0]);
            if (string == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PyBehaveRenameFolderFix.$$$reportNull$$$0(2);
            }
            PsiDirectory directoryToRename = descriptor.getPsiElement().getContainingFile().getContainingDirectory();
            RefactoringFactory.getInstance((Project)project).createRename((PsiElement)directoryToRename, "steps").run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveRenameFolderFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveRenameFolderFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PyBehaveReMatcherFix
    implements LocalQuickFix {
        private PyBehaveReMatcherFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBDDBundle.message("com.jetbrains.python.gherkin.inspections.behave.matcher.fix", new Object[0]);
            if (string == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PyBehaveReMatcherFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof PyCallExpression) {
                PsiElement argument;
                PyCallExpression expression = (PyCallExpression)element;
                PyArgumentList argumentList = expression.getArgumentList();
                if (argumentList != null && (argument = expression.getArgument((FunctionParameter)PyBehaveFunctionParameters.MATCHER_NAME, PsiElement.class)) != null) {
                    argument.delete();
                }
                PyBehaveInspection.addMatcherArgument(expression);
                return;
            }
            PyFile file = (PyFile)element.getContainingFile();
            PyBehaveInspection.addNewStepMatcherCall(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveReMatcherFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveInspection$PyBehaveReMatcherFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

