/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.api;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.python.gherkin.PyBDDFramework;
import com.jetbrains.python.gherkin.PyStepDefinition;
import com.jetbrains.python.gherkin.api.PyBDDFrameworkConfig;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;

public class PyGherkinApi {
    @NotNull
    private final List<PyBDDFramework> myFrameworks;
    @NotNull
    private final Module myModule;

    @Nullable
    public static PyGherkinApi getPyGherkinApi(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            PyGherkinApi.$$$reportNull$$$0(0);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null ? new PyGherkinApi(module) : null;
    }

    public PyGherkinApi(@NotNull Module module) {
        if (module == null) {
            PyGherkinApi.$$$reportNull$$$0(1);
        }
        this.myFrameworks = new ArrayList<PyBDDFramework>();
        this.myModule = module;
        for (CucumberJvmExtensionPoint jvmExtensionPoint : (CucumberJvmExtensionPoint[])CucumberJvmExtensionPoint.EP_NAME.getExtensions()) {
            if (!(jvmExtensionPoint instanceof PyBDDFramework)) continue;
            this.myFrameworks.add((PyBDDFramework)jvmExtensionPoint);
        }
        assert (!this.myFrameworks.isEmpty()) : "No frameworks installed: idea misconfigured?";
    }

    @NotNull
    public List<PyBDDFramework> getAllFrameworks() {
        List<PyBDDFramework> list = Collections.unmodifiableList(this.myFrameworks);
        if (list == null) {
            PyGherkinApi.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isInstalledFramework(@NotNull PyBDDFramework framework) {
        Sdk sdk;
        if (framework == null) {
            PyGherkinApi.$$$reportNull$$$0(3);
        }
        if ((sdk = PythonSdkType.findPythonSdk((Module)this.myModule)) == null) {
            return false;
        }
        List packages = PyPackageManager.getInstance((Sdk)sdk).getPackages();
        return packages != null && PyPackageUtil.findPackage((List)packages, (String)framework.getFrameworkName()) != null;
    }

    public boolean isPreferedFramework(@NotNull PyBDDFramework framework) {
        if (framework == null) {
            PyGherkinApi.$$$reportNull$$$0(4);
        }
        return framework.getFrameworkName().equals(PyBDDFrameworkConfig.getInstance(this.myModule).getPreferedFrameworkName());
    }

    @Nullable
    public PyBDDFramework findFrameworkByName(@NotNull String frameworkName) {
        if (frameworkName == null) {
            PyGherkinApi.$$$reportNull$$$0(5);
        }
        for (PyBDDFramework framework : this.myFrameworks) {
            if (!framework.getFrameworkName().equals(frameworkName)) continue;
            return framework;
        }
        return null;
    }

    @Nullable
    public PyBDDFramework getPreferedFramework() {
        for (PyBDDFramework framework : this.myFrameworks) {
            if (!this.isPreferedFramework(framework)) continue;
            return framework;
        }
        return null;
    }

    @Nullable
    public PyBDDFramework getRecommendedFramework() {
        PyBDDFramework preferedFramework = this.getPreferedFramework();
        if (preferedFramework != null) {
            return preferedFramework;
        }
        if (this.myFrameworks.size() == 1) {
            return this.myFrameworks.get(0);
        }
        HashSet<PyBDDFramework> installedFrameworks = new HashSet<PyBDDFramework>();
        for (PyBDDFramework framework : this.myFrameworks) {
            if (!this.isInstalledFramework(framework)) continue;
            installedFrameworks.add(framework);
        }
        if (installedFrameworks.size() == 1) {
            return (PyBDDFramework)installedFrameworks.iterator().next();
        }
        return null;
    }

    public void setPreferedFramework(@Nullable PyBDDFramework frameworksToOnlyEnable) {
        PyBDDFrameworkConfig config = PyBDDFrameworkConfig.getInstance(this.myModule);
        if (frameworksToOnlyEnable == null) {
            config.setPreferedFrameworkName(null);
        } else {
            config.setPreferedFrameworkName(frameworksToOnlyEnable.getFrameworkName());
        }
    }

    @Nullable
    public <F extends PyBDDFramework> F findFrameworkByClass(@NotNull Class<F> clazz) {
        if (clazz == null) {
            PyGherkinApi.$$$reportNull$$$0(6);
        }
        for (PyBDDFramework framework : this.getAllFrameworks()) {
            if (!framework.getClass().isAssignableFrom(clazz)) continue;
            PyBDDFramework result = framework;
            return (F)result;
        }
        return null;
    }

    public boolean isStepDefinition(@NotNull PyDecorator possibleStepDefinition, boolean ensureRegexpCouldBeUsed) {
        if (possibleStepDefinition == null) {
            PyGherkinApi.$$$reportNull$$$0(7);
        }
        for (PyBDDFramework framework : this.getAllFrameworks()) {
            if (!framework.isStepDefinition(possibleStepDefinition, ensureRegexpCouldBeUsed)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<PyBDDFramework> whichFrameworksHaveStepDefinitions() {
        HashSet<PyBDDFramework> frameworkSet = new HashSet<PyBDDFramework>();
        for (PyBDDFramework framework : this.getAllFrameworks()) {
            if (framework.findStepDefDecorators(this.myModule.getProject(), GlobalSearchScope.moduleWithDependentsScope((Module)this.myModule)).isEmpty()) continue;
            frameworkSet.add(framework);
        }
        HashSet<PyBDDFramework> hashSet = frameworkSet;
        if (hashSet == null) {
            PyGherkinApi.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Nullable
    public PyStepDefinition getDefinitionByDecorator(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            PyGherkinApi.$$$reportNull$$$0(9);
        }
        for (PyBDDFramework framework : this.myFrameworks) {
            if (!framework.isStepDefinition(decorator, false)) continue;
            return framework.createStepDefinition(decorator);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/api/PyGherkinApi";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleStepDefinition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/api/PyGherkinApi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFrameworks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "whichFrameworksHaveStepDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPyGherkinApi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInstalledFramework";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPreferedFramework";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkByClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionByDecorator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

