/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Function;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.gherkin.PyStepDefinitionMatchingPattern;
import com.jetbrains.python.psi.PyDecorator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class PyStepDefinition
extends AbstractStepDefinition {
    private static final Pattern NAMED_GROUP_PREFIX = Pattern.compile("\\(\\?P<[^>]+>");
    public static final Pattern REGEXP_SYMBOLS = Pattern.compile("[\\]\\[.\\-+?*]");
    @NotNull
    protected final PyStepDefinitionMatchingPattern myPattern;
    private final boolean myHasNamedGroups;
    @NotNull
    private final Project myProject;

    protected PyStepDefinition(@NotNull PyDecorator stepDefinition, @Nullable Function<String, String> stringProcessor) {
        if (stepDefinition == null) {
            PyStepDefinition.$$$reportNull$$$0(0);
        }
        super((PsiElement)stepDefinition);
        this.myProject = stepDefinition.getProject();
        this.myPattern = new PyStepDefinitionMatchingPattern(stepDefinition, stringProcessor);
        RegExpFile regExpFile = this.myPattern.getAsRegexp();
        this.myHasNamedGroups = regExpFile != null ? !regExpFile.getGroups().isEmpty() : false;
    }

    @Nullable
    public String getCucumberRegex() {
        String regex = super.getCucumberRegex();
        if (this.myHasNamedGroups && regex != null) {
            regex = NAMED_GROUP_PREFIX.matcher(regex).replaceAll("(");
        }
        return regex;
    }

    public List<String> getVariableNames() {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getPlaceHolders(), (Predicate)new NotNullPredicate()));
    }

    @NotNull
    public List<String> getPlaceHolders() {
        RegExpFile regExpFile = this.myPattern.getAsRegexp();
        if (regExpFile != null) {
            ArrayList<String> varNames = new ArrayList<String>();
            for (RegExpGroup group : regExpFile.getGroups()) {
                if (!group.isCapturing()) continue;
                String groupName = group.getGroupName();
                varNames.add(groupName);
            }
            ArrayList<String> arrayList = varNames;
            if (arrayList == null) {
                PyStepDefinition.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PyStepDefinition.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    protected String getCucumberRegexFromElement(@NotNull PsiElement element) {
        if (element == null) {
            PyStepDefinition.$$$reportNull$$$0(3);
        }
        return this.myPattern.cloneWithNewElement((PyDecorator)element).getAsString();
    }

    public void setCucumberRegex(@NotNull String newValue) {
        if (newValue == null) {
            PyStepDefinition.$$$reportNull$$$0(4);
        }
        this.myPattern.setNewValue(newValue);
    }

    public boolean supportsRename(@Nullable String newName) {
        if (!super.supportsRename(newName)) {
            return false;
        }
        if (newName != null) {
            return !REGEXP_SYMBOLS.matcher(newName).find();
        }
        String stepSentence = this.myPattern.getAsString();
        if (stepSentence == null) {
            return false;
        }
        Collection steps = this.findSteps((SearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        if (steps.size() != 1) {
            return false;
        }
        GherkinStep step = (GherkinStep)steps.iterator().next();
        if (step.findDefinitions().size() != 1) {
            return false;
        }
        return !REGEXP_SYMBOLS.matcher(stepSentence).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/PyStepDefinition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/PyStepDefinition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceHolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCucumberRegexFromElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberRegex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

