/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin;

import com.google.common.collect.Sets;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.gherkin.PyBDDCreationTools;
import com.jetbrains.python.gherkin.PyBDDFramework;
import com.jetbrains.python.gherkin.PyBDDStepDefinitionCreator;
import com.jetbrains.python.gherkin.PyStepDefinition;
import com.jetbrains.python.gherkin.api.PyGherkinApi;
import com.jetbrains.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.stubs.PyDecoratorStubIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class PyCucumberJvmExtensionPoint
extends AbstractCucumberExtension
implements PyBDDFramework,
OptionalStepDefinitionExtensionPoint {
    @NotNull
    private final String myPackageName;
    @NotNull
    private final List<String> myStepDecoratorNames;
    @NotNull
    private final Pair<String, String>[] myStepDefinitionParams;

    protected PyCucumberJvmExtensionPoint(@NotNull String packageName, @NotNull Iterable<String> stepDecoratorNames, Pair<String, String> ... stepDefinitionParams) {
        if (packageName == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(0);
        }
        if (stepDecoratorNames == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(1);
        }
        if (stepDefinitionParams == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(2);
        }
        this.myStepDecoratorNames = new ArrayList<String>();
        this.myPackageName = packageName;
        this.myStepDecoratorNames.addAll(Sets.newHashSet(stepDecoratorNames));
        this.myStepDefinitionParams = (Pair[])stepDefinitionParams.clone();
    }

    public final boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        PyFile file;
        if (child == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(4);
        }
        if ((file = (PyFile)PyUtil.as((Object)child, PyFile.class)) == null) {
            return false;
        }
        return this.isFrameworkStepDefinition(file);
    }

    public final boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        PyFile file;
        if (child == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(6);
        }
        if ((file = (PyFile)PyUtil.as((Object)child, PyFile.class)) == null) {
            return false;
        }
        return this.isFileMayBeStepDefinition(file);
    }

    @Override
    public boolean isFrameworkStepDefinition(@NotNull PyFile file) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(7);
        }
        return !this.findStepDefDecorators(file.getProject(), GlobalSearchScope.fileScope((PsiFile)file)).isEmpty();
    }

    @NotNull
    public final StepDefinitionCreator getStepDefinitionCreator() {
        PyBDDStepDefinitionCreator pyBDDStepDefinitionCreator = new PyBDDStepDefinitionCreator(this);
        if (pyBDDStepDefinitionCreator == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(8);
        }
        return pyBDDStepDefinitionCreator;
    }

    @NotNull
    public final Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(9);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(10);
        }
        return list;
    }

    public final List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(11);
        }
        if (featureFile == null) {
            return PyCucumberJvmExtensionPoint.loadStepsForInternal(module, this);
        }
        return (List)PyUtil.getParameterizedCachedValue((PsiElement)featureFile, (Object)this, dom -> {
            if (module == null) {
                PyCucumberJvmExtensionPoint.$$$reportNull$$$0(34);
            }
            return PyCucumberJvmExtensionPoint.loadStepsForInternal(module, dom);
        });
    }

    @NotNull
    private static List<AbstractStepDefinition> loadStepsForInternal(@NotNull Module module, @NotNull PyCucumberJvmExtensionPoint point) {
        if (module == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(12);
        }
        if (point == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(13);
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(GlobalSearchScope.moduleWithDependentsScope((Module)module));
        for (PyDecorator decorator : point.findStepDefDecorators(module.getProject(), scope)) {
            result.add(point.createStepDefinition(decorator));
        }
        ArrayList<AbstractStepDefinition> arrayList = result;
        if (arrayList == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyStepDefinition createStepDefinition(@NotNull PyDecorator decorator) {
        if (decorator == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(15);
        }
        PyStepDefinition pyStepDefinition = new PyStepDefinition(decorator, null);
        if (pyStepDefinition == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(16);
        }
        return pyStepDefinition;
    }

    public final Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile file) {
        Module module;
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(17);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (PyDecorator decorator : this.findStepDefDecorators(file.getProject(), GlobalSearchScope.moduleWithDependentsScope((Module)module))) {
            result.add(decorator.getContainingFile());
        }
        return result;
    }

    @Override
    @NotNull
    public String getFrameworkName() {
        String string = this.myPackageName;
        if (string == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public boolean isStepDefinition(@NotNull PyDecorator possibleStepDefinition, boolean ensureRegexpCouldBeUsed) {
        PyFile file;
        if (possibleStepDefinition == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(19);
        }
        if ((file = (PyFile)PyUtil.as((Object)possibleStepDefinition.getContainingFile(), PyFile.class)) == null || !this.isFileMayBeStepDefinition(file)) {
            return false;
        }
        QualifiedName qualifiedName = possibleStepDefinition.getQualifiedName();
        if (qualifiedName != null) {
            return this.myStepDecoratorNames.contains(qualifiedName.toString());
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<PyDecorator> findStepDefDecorators(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(21);
        }
        ArrayList<PyDecorator> result = new ArrayList<PyDecorator>();
        for (String decoratorName : this.myStepDecoratorNames) {
            Collection decoratorsFromIndex = StubIndex.getElements((StubIndexKey)PyDecoratorStubIndex.KEY, (Object)decoratorName, (Project)project, (GlobalSearchScope)scope, PyDecorator.class);
            for (PyDecorator decorator : decoratorsFromIndex) {
                PyFile fileWithDecorator = (PyFile)PyUtil.as((Object)decorator.getContainingFile(), PyFile.class);
                if (fileWithDecorator == null || !this.isFileMayBeStepDefinition(fileWithDecorator)) continue;
                result.add(decorator);
            }
        }
        ArrayList<PyDecorator> arrayList = result;
        if (arrayList == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Override
    public boolean isFileMayBeStepDefinition(@NotNull PyFile file) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(23);
        }
        return this.isFileContainsAppropriateImports(file);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)PythonFileType.INSTANCE, this.myPackageName);
        if (bDDFrameworkType == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(24);
        }
        return bDDFrameworkType;
    }

    public boolean participateInStepDefinitionCreation(@NotNull PsiElement anchor) {
        PyGherkinApi api;
        if (anchor == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(25);
        }
        if ((api = PyGherkinApi.getPyGherkinApi(anchor)) != null && api.getPreferedFramework() == null) {
            PyCucumberJvmExtensionPoint.tryToSetPreferedFramework(api);
        }
        return !this.isExplicitlyNotRecommended(anchor);
    }

    @Override
    public boolean isExplicitlyNotRecommended(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(26);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor)) == null) {
            return false;
        }
        PyBDDFramework recommendedFramework = new PyGherkinApi(module).getRecommendedFramework();
        return recommendedFramework != null && !this.equals(recommendedFramework);
    }

    private boolean isFileContainsAppropriateImports(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(27);
        }
        QualifiedName packageQName = QualifiedName.fromComponents((String[])new String[]{this.myPackageName});
        for (PyFromImportStatement importStatement : pyFile.getFromImports()) {
            if (!packageQName.equals((Object)importStatement.getImportSourceQName())) continue;
            return true;
        }
        for (PyImportElement importElement : pyFile.getImportTargets()) {
            PyReferenceExpression referenceExpression;
            if (!packageQName.equals((Object)importElement.getImportedQName()) || (referenceExpression = importElement.getImportReferenceExpression()) == null || referenceExpression.getReference().resolve() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(28);
        }
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(29);
        }
        PyBDDCreationTools.addStepDefinition(file, this.getDecoratorName(step), step, this.getBDDMatcherByFile(file), this.myStepDefinitionParams);
    }

    @NotNull
    protected PyBDDMatcher getBDDMatcherByFile(@NotNull PsiFile file) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(30);
        }
        PyBDDMatcher pyBDDMatcher = PyBDDMatcher.RE;
        if (pyBDDMatcher == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(31);
        }
        return pyBDDMatcher;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getStepDefinitionRequiredParams() {
        List<Pair<String, String>> list = Arrays.asList(this.myStepDefinitionParams);
        if (list == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    protected abstract String getDecoratorName(@NotNull GherkinStep var1);

    private static void tryToSetPreferedFramework(@NotNull PyGherkinApi api) {
        PyBDDFramework recommendedFramework;
        Collection<PyBDDFramework> frameworksWithStepDefinitions;
        if (api == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(33);
        }
        if ((frameworksWithStepDefinitions = api.whichFrameworksHaveStepDefinitions()).size() == 1) {
            api.setPreferedFramework(frameworksWithStepDefinitions.iterator().next());
        }
        if ((recommendedFramework = api.getRecommendedFramework()) != null) {
            api.setPreferedFramework(recommendedFramework);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDecoratorNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionParams";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 9: 
            case 17: 
            case 23: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/gherkin/PyCucumberJvmExtensionPoint";
                break;
            }
            case 11: 
            case 12: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleStepDefinition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/gherkin/PyCucumberJvmExtensionPoint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionCreator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStepsForInternal";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepDefDecorators";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepFileType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBDDMatcherByFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionRequiredParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStepLikeFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWritableStepLikeFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkStepDefinition";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 32: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGlues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsForInternal";
                break;
            }
            case 15: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefDecorators";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFileMayBeStepDefinition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "participateInStepDefinitionCreation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitlyNotRecommended";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFileContainsAppropriateImports";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBDDMatcherByFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetPreferedFramework";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadStepsFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

