/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import git4idea.config.GitVcsSettings;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitLogBranchOperationsActionGroup
extends ActionGroup
implements DumbAware {
    private static final int MAX_BRANCH_GROUPS = 2;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    public boolean hideIfNoVisibleChildren() {
        return true;
    }

    @NotNull
    public AnAction[] getChildren(AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        List branches = (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES);
        if (project == null || log == null || logUI == null || branches == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(1);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List commits2 = log.getSelectedCommits();
        if (commits2.size() != 1) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        CommitId commit2 = (CommitId)commits2.get(0);
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository root = (GitRepository)repositoryManager.getRepositoryForRoot(commit2.getRoot());
        if (root == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List vcsRefs = ContainerUtil.filter((Collection)branches, ref -> {
            if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                return !ref.getName().equals(root.getCurrentBranchName());
            }
            return ref.getType() == GitRefManager.REMOTE_BRANCH;
        });
        VcsLogProvider provider = (VcsLogProvider)logUI.getDataPack().getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            ContainerUtil.sort((List)vcsRefs, (Comparator)comparator);
        }
        if (vcsRefs.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(4);
            }
            return AnAction.EMPTY_ARRAY;
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        boolean showBranchesPopup = vcsRefs.size() > 2;
        ArrayList<AnAction> branchActionGroups = new ArrayList<AnAction>();
        for (VcsRef ref2 : vcsRefs) {
            branchActionGroups.add(GitLogBranchOperationsActionGroup.createBranchGroup(project, ref2, root, repositoryManager, settings, showBranchesPopup));
        }
        DefaultActionGroup branchesGroup = new DefaultActionGroup("Branches", branchActionGroups);
        branchesGroup.setPopup(showBranchesPopup);
        AnAction[] anActionArray = new AnAction[]{branchesGroup};
        if (anActionArray == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(6);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(8);
        }
        if (repositoryManager == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(10);
        }
        List<GitRepository> allRepositories = repositoryManager.getRepositories();
        boolean isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && GitLogBranchOperationsActionGroup.branchInAllRepositories(allRepositories, ref);
        boolean isLocal = ref.getType() == GitRefManager.LOCAL_BRANCH;
        ArrayList<Object> actions = new ArrayList<Object>(3);
        if (isSyncBranch) {
            ActionGroup allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, ref, repository, isLocal);
            allReposActions.getTemplatePresentation().setText("In All Repositories");
            allReposActions.setPopup(true);
            actions.add(allReposActions);
            actions.add(Separator.getInstance());
        }
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), ref, repository, isLocal);
        singleRepoActions.setPopup(false);
        actions.add(singleRepoActions);
        String text = showBranchesPopup ? ref.getName() : "Branch '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(actions);
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(11);
        }
        return defaultActionGroup;
    }

    private static boolean branchInAllRepositories(@NotNull List<GitRepository> repositories, @NotNull VcsRef branches) {
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(12);
        }
        if (branches == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(13);
        }
        return ContainerUtil.and(repositories, repository -> {
            if (branches == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(20);
            }
            return repository.getBranches().findBranchByName(branches.getName()) != null;
        });
    }

    @NotNull
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository, boolean isLocal) {
        if (project == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(14);
        }
        if (repositories == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(15);
        }
        if (ref == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(16);
        }
        if (selectedRepository == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(17);
        }
        if (isLocal) {
            GitBranchPopupActions.LocalBranchActions localBranchActions = new GitBranchPopupActions.LocalBranchActions(project, repositories, ref.getName(), selectedRepository);
            if (localBranchActions == null) {
                GitLogBranchOperationsActionGroup.$$$reportNull$$$0(18);
            }
            return localBranchActions;
        }
        GitBranchPopupActions.RemoteBranchActions remoteBranchActions = new GitBranchPopupActions.RemoteBranchActions(project, repositories, ref.getName(), selectedRepository);
        if (remoteBranchActions == null) {
            GitLogBranchOperationsActionGroup.$$$reportNull$$$0(19);
        }
        return remoteBranchActions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitLogBranchOperationsActionGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchGroup";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createBranchActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBranchGroup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "branchInAllRepositories";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBranchActions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$branchInAllRepositories$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

