/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    @NotNull
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final boolean myForce;
    private final boolean mySkipHook;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitRepositoryManager myRepositoryManager;

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force, boolean skipHook) {
        if (project == null) {
            GitPushOperation.$$$reportNull$$$0(0);
        }
        if (pushSupport == null) {
            GitPushOperation.$$$reportNull$$$0(1);
        }
        if (pushSpecs == null) {
            GitPushOperation.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForce = force;
        this.mySkipHook = skipHook;
        this.myGit = Git.getInstance();
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myRepositoryManager = GitRepositoryManager.getInstance(this.myProject);
        HashMap currentHeads = ContainerUtil.newHashMap();
        for (GitRepository repository : pushSpecs.keySet()) {
            repository.update();
            String head = repository.getCurrentRevision();
            if (head == null) {
                LOG.error("This repository has no commits");
                continue;
            }
            currentHeads.put(repository, new GitRevisionNumber(head));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap results = ContainerUtil.newHashMap();
        HashMap updatedRoots = ContainerUtil.newHashMap();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(this.myRepositoryManager.sortByDependency(remainingRoots));
                results.putAll(resultMap);
                GroupedPushResult result2 = GroupedPushResult.group(resultMap);
                if (!result2.errors.isEmpty()) break;
                if (!result2.customRejected.isEmpty()) {
                    break;
                }
                if (!result2.rejected.isEmpty()) {
                    boolean shouldUpdate = true;
                    if (this.myForce || GitPushOperation.pushingToNotTrackedBranch(result2.rejected)) {
                        shouldUpdate = false;
                    } else if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.getRootsToUpdate(updateSettings, result2.rejected.keySet())).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result2.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings != null) {
                            this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                        } else {
                            shouldUpdate = false;
                        }
                    }
                    if (!shouldUpdate) {
                        break;
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
                    }
                    Collection<GitRepository> rootsToUpdate = this.getRootsToUpdate(updateSettings, result2.rejected.keySet());
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "After push");
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        GitPushResult gitPushResult = this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
        if (gitPushResult == null) {
            GitPushOperation.$$$reportNull$$$0(3);
        }
        return gitPushResult;
    }

    @NotNull
    private Collection<GitRepository> getRootsToUpdate(@NotNull PushUpdateSettings updateSettings, @NotNull Set<GitRepository> rejectedRepositories) {
        if (updateSettings == null) {
            GitPushOperation.$$$reportNull$$$0(4);
        }
        if (rejectedRepositories == null) {
            GitPushOperation.$$$reportNull$$$0(5);
        }
        Collection<GitRepository> collection = updateSettings.shouldUpdateAllRoots() ? this.myRepositoryManager.getRepositories() : rejectedRepositories;
        if (collection == null) {
            GitPushOperation.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> findRootsWithMergeCommits(@NotNull Collection<GitRepository> rootsToSearch) {
        if (rootsToSearch == null) {
            GitPushOperation.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.mapNotNull(rootsToSearch, repo -> {
            PushSpec pushSpec = this.myPushSpecs.get(repo);
            if (pushSpec == null) {
                GitPushSource source = this.myPushSupport.getSource((GitRepository)repo);
                GitPushTarget target = this.myPushSupport.getDefaultTarget((GitRepository)repo);
                if (target == null) {
                    return null;
                }
                pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
            }
            String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
            String currentRef = ((GitPushSource)pushSpec.getSource()).getBranch().getFullName();
            return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
        });
        if (list == null) {
            GitPushOperation.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            GitPushOperation.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
            return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(((GitPushRepoResult)entry.getValue()).getTargetBranch());
        });
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.filter(results.keySet(), repository -> {
            if (results == null) {
                GitPushOperation.$$$reportNull$$$0(42);
            }
            return ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED_NO_FF || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED;
        });
        if (list == null) {
            GitPushOperation.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Set<GitRepository> repositories = this.myPushSpecs.keySet();
        repositories.forEach(Repository::update);
        Map map = StreamEx.of(repositories).toMap(Repository::getCurrentRevision);
        if (map == null) {
            GitPushOperation.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private GitPushResult prepareCombinedResult(@NotNull Map<GitRepository, GitPushRepoResult> allRoots, @NotNull Map<GitRepository, GitUpdateResult> updatedRoots, @NotNull Map<GitRepository, String> preUpdatePositions, @Nullable Label beforeUpdateLabel, @Nullable Label afterUpdateLabel) {
        if (allRoots == null) {
            GitPushOperation.$$$reportNull$$$0(13);
        }
        if (updatedRoots == null) {
            GitPushOperation.$$$reportNull$$$0(14);
        }
        if (preUpdatePositions == null) {
            GitPushOperation.$$$reportNull$$$0(15);
        }
        HashMap results = ContainerUtil.newHashMap();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        GitPushResult gitPushResult = new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel);
        if (gitPushResult == null) {
            GitPushOperation.$$$reportNull$$$0(16);
        }
        return gitPushResult;
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull List<GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        if (repositories == null) {
            GitPushOperation.$$$reportNull$$$0(17);
        }
        LinkedHashMap results = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(repository);
            ResultWithOutput resultWithOutput = this.doPush(repository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + resultWithOutput);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List nativeResults = resultWithOutput.parsedResults;
                GitPushNativeResult branchResult = GitPushOperation.getBranchResult(nativeResults);
                if (branchResult == null) {
                    LOG.error("No result for branch among: [" + nativeResults + "]\nFull result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter((Collection)nativeResults, result2 -> !result2.equals(branchResult) && (result2.getType() == GitPushNativeResult.Type.NEW_REF || result2.getType() == GitPushNativeResult.Type.FORCED_UPDATE));
                int commits2 = this.collectNumberOfPushedCommits(repository.getRoot(), branchResult);
                repoResult = GitPushRepoResult.convertFromNative(branchResult, tagResults, commits2, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(repository, repoResult);
        }
        for (GitRepository repository : repositories) {
            if (results.containsKey(repository)) continue;
            spec = this.myPushSpecs.get(repository);
            results.put(repository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        LinkedHashMap linkedHashMap = results;
        if (linkedHashMap == null) {
            GitPushOperation.$$$reportNull$$$0(18);
        }
        return linkedHashMap;
    }

    @Nullable
    private static GitPushNativeResult getBranchResult(@NotNull List<GitPushNativeResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(19);
        }
        return (GitPushNativeResult)ContainerUtil.find(results, result2 -> result2.getSourceRef().startsWith("refs/heads/"));
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result2) {
        if (root == null) {
            GitPushOperation.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(21);
        }
        if (result2.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result2.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result2);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        if (updatedFiles == null) {
            GitPushOperation.$$$reportNull$$$0(22);
        }
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(23);
        }
        if (preUpdatePosition == null) {
            GitPushOperation.$$$reportNull$$$0(24);
        }
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, repository.getRoot(), new GitRevisionNumber(preUpdatePosition));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(updatedFiles, exceptions);
        for (VcsException exception : exceptions) {
            LOG.info((Throwable)exception);
        }
    }

    @NotNull
    private ResultWithOutput doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(25);
        }
        if (pushSpec == null) {
            GitPushOperation.$$$reportNull$$$0(26);
        }
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = ((GitPushSource)pushSpec.getSource()).getBranch();
        GitRemoteBranch targetBranch = target.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = ((GitPushTarget)pushSpec.getTarget()).isNewBranchCreated() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        String spec = sourceBranch.getFullName() + ":" + targetBranch.getNameForRemoteOperations();
        GitRemote remote = targetBranch.getRemote();
        GitCommandResult res = this.myGit.push(repository, remote, spec, this.myForce, setUpstream, this.mySkipHook, tagMode, progressListener);
        if (res.success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
        }
        ResultWithOutput resultWithOutput = new ResultWithOutput(res);
        if (resultWithOutput == null) {
            GitPushOperation.$$$reportNull$$$0(27);
        }
        return resultWithOutput;
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(28);
        }
        if (source == null) {
            GitPushOperation.$$$reportNull$$$0(29);
        }
        return ContainerUtil.exists(repository.getBranchTrackInfos(), info -> {
            if (source == null) {
                GitPushOperation.$$$reportNull$$$0(41);
            }
            return info.getLocalBranch().equals(source);
        });
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        if (settings == null) {
            GitPushOperation.$$$reportNull$$$0(30);
        }
        UpdateMethod updateMethod = settings.getUpdateMethod();
        this.mySettings.setUpdateAllRootsIfPushRejected(settings.shouldUpdateAllRoots());
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateType() != updateMethod && this.mySettings.getUpdateType() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateType(updateMethod);
        }
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        boolean updateAllRoots = this.mySettings.shouldUpdateAllRootsIfPushRejected();
        UpdateMethod updateMethod = this.mySettings.getUpdateType();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myPushSpecs.keySet().iterator().next());
        }
        PushUpdateSettings pushUpdateSettings = new PushUpdateSettings(updateAllRoots, updateMethod);
        if (pushUpdateSettings == null) {
            GitPushOperation.$$$reportNull$$$0(31);
        }
        return pushUpdateSettings;
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(@NotNull Set<GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        if (repositories == null) {
            GitPushOperation.$$$reportNull$$$0(32);
        }
        if (initialSettings == null) {
            GitPushOperation.$$$reportNull$$$0(33);
        }
        Ref updateSettings = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (repositories == null) {
                GitPushOperation.$$$reportNull$$$0(39);
            }
            if (initialSettings == null) {
                GitPushOperation.$$$reportNull$$$0(40);
            }
            GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(this.myProject, repositories, initialSettings, rebaseOverMergeProblemDetected);
            DialogManager.show(dialog);
            int exitCode = dialog.getExitCode();
            if (exitCode != 1) {
                this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
                updateSettings.set((Object)new PushUpdateSettings(dialog.shouldUpdateAll(), GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                UpdateMethod updateMethod = UpdateMethod.MERGE;
                if (updateMethod == null) {
                    GitPushOperation.$$$reportNull$$$0(34);
                }
                return updateMethod;
            }
            case 3: {
                UpdateMethod updateMethod = UpdateMethod.REBASE;
                if (updateMethod == null) {
                    GitPushOperation.$$$reportNull$$$0(35);
                }
                return updateMethod;
            }
        }
        throw new IllegalStateException("Unexpected exit code: " + exitCode);
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        if (rootsToUpdate == null) {
            GitPushOperation.$$$reportNull$$$0(36);
        }
        if (updateMethod == null) {
            GitPushOperation.$$$reportNull$$$0(37);
        }
        GitUpdateResult updateResult = new GitUpdateProcess(this.myProject, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), checkForRebaseOverMergeProblem, false).update(updateMethod);
        for (GitRepository repository : rootsToUpdate) {
            repository.getRoot().refresh(true, true);
            repository.update();
        }
        GitUpdateResult gitUpdateResult = updateResult;
        if (gitUpdateResult == null) {
            GitPushOperation.$$$reportNull$$$0(38);
        }
        return gitUpdateResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpecs";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushOperation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejectedRepositories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSearch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 10: 
            case 19: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedRoots";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePositions";
                break;
            }
            case 17: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePosition";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpec";
                break;
            }
            case 29: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToUpdate";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootsWithMergeCommits";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRejectedAndNotPushed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRootInfoAndRememberPositions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCombinedResult";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doPush";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "readPushUpdateSettings";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "convertUpdateMethodFromDialogExitCode";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 38: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithMergeCommits";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pushingToNotTrackedBranch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRejectedAndNotPushed";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareCombinedResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBranchResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectNumberOfPushedCommits";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectUpdatedFiles";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "branchTrackingInfoIsSet";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "savePushUpdateSettings";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGetExitCode";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showDialogAndGetExitCode$6";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$branchTrackingInfoIsSet$5";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRejectedAndNotPushed$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResultWithOutput {
        @NotNull
        private final List<GitPushNativeResult> parsedResults;
        @NotNull
        private final GitCommandResult resultOutput;

        ResultWithOutput(@NotNull GitCommandResult resultOutput) {
            if (resultOutput == null) {
                ResultWithOutput.$$$reportNull$$$0(0);
            }
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        @NotNull
        String getErrorAsString() {
            String string = this.resultOutput.getErrorOutputAsJoinedString();
            if (string == null) {
                ResultWithOutput.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorAsString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

