/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeProvider
implements MergeProvider2 {
    private static final int ORIGINAL_REVISION_NUM = 1;
    private static final int YOURS_REVISION_NUM = 2;
    private static final int THEIRS_REVISION_NUM = 3;
    private static final Logger LOG = Logger.getInstance(GitMergeProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myReverseRoots;

    private GitMergeProvider(@NotNull Project project, @NotNull Set<VirtualFile> reverseRoots) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(0);
        }
        if (reverseRoots == null) {
            GitMergeProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myReverseRoots = reverseRoots;
    }

    public GitMergeProvider(@NotNull Project project, boolean reverse) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(2);
        }
        this(project, GitMergeProvider.findReverseRoots(project, reverse ? ReverseRequest.REVERSE : ReverseRequest.FORWARD));
    }

    @NotNull
    public static MergeProvider detect(@NotNull Project project) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(3);
        }
        GitMergeProvider gitMergeProvider = new GitMergeProvider(project, GitMergeProvider.findReverseRoots(project, ReverseRequest.DETECT));
        if (gitMergeProvider == null) {
            GitMergeProvider.$$$reportNull$$$0(4);
        }
        return gitMergeProvider;
    }

    @NotNull
    private static Set<VirtualFile> findReverseRoots(@NotNull Project project, @NotNull ReverseRequest reverseOrDetect) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(5);
        }
        if (reverseOrDetect == null) {
            GitMergeProvider.$$$reportNull$$$0(6);
        }
        HashSet reverseMap = ContainerUtil.newHashSet();
        for (GitRepository repository : GitUtil.getRepositoryManager(project).getRepositories()) {
            boolean reverse;
            if (reverseOrDetect == ReverseRequest.DETECT) {
                reverse = repository.getState().equals((Object)Repository.State.REBASING);
            } else {
                boolean bl = reverse = reverseOrDetect == ReverseRequest.REVERSE;
            }
            if (!reverse) continue;
            reverseMap.add(repository.getRoot());
        }
        HashSet hashSet = reverseMap;
        if (hashSet == null) {
            GitMergeProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public MergeData loadRevisions(final @NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(8);
        }
        final MergeData mergeData = new MergeData();
        final VirtualFile root = GitUtil.getGitRoot(file);
        final FilePath path = VcsUtil.getFilePath((String)file.getPath());
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                GitFileRevision original = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":1"));
                GitFileRevision current = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":" + GitMergeProvider.this.yoursRevision(root)));
                GitFileRevision last = new GitFileRevision(GitMergeProvider.this.myProject, path, new GitRevisionNumber(":" + GitMergeProvider.this.theirsRevision(root)));
                try {
                    try {
                        mergeData.ORIGINAL = original.getContent();
                    }
                    catch (Exception ex) {
                        try {
                            mergeData.ORIGINAL = file.contentsToByteArray();
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                            mergeData.ORIGINAL = ArrayUtil.EMPTY_BYTE_ARRAY;
                        }
                    }
                    mergeData.CURRENT = GitMergeProvider.loadRevisionCatchingErrors(current);
                    mergeData.LAST = GitMergeProvider.loadRevisionCatchingErrors(last);
                    mergeData.CURRENT_REVISION_NUMBER = GitMergeProvider.this.findCurrentRevisionNumber(root);
                    mergeData.LAST_REVISION_NUMBER = GitMergeProvider.this.findLastRevisionNumber(root);
                    mergeData.ORIGINAL_REVISION_NUMBER = GitMergeProvider.this.findOriginalRevisionNumber(root, mergeData.CURRENT_REVISION_NUMBER, mergeData.LAST_REVISION_NUMBER);
                    Trinity blobs = GitMergeProvider.this.getAffectedBlobs(root, file);
                    mergeData.CURRENT_FILE_PATH = GitMergeProvider.this.getBlobPathInRevision(root, file, (String)blobs.getFirst(), mergeData.CURRENT_REVISION_NUMBER);
                    mergeData.ORIGINAL_FILE_PATH = GitMergeProvider.this.getBlobPathInRevision(root, file, (String)blobs.getSecond(), mergeData.ORIGINAL_REVISION_NUMBER);
                    mergeData.LAST_FILE_PATH = GitMergeProvider.this.getBlobPathInRevision(root, file, (String)blobs.getThird(), mergeData.LAST_REVISION_NUMBER);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load file content", e);
                }
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)GitBundle.message("merge.load.files", new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData2 = mergeData;
        if (mergeData2 == null) {
            GitMergeProvider.$$$reportNull$$$0(9);
        }
        return mergeData2;
    }

    @NotNull
    private Trinity<String, String, String> getAffectedBlobs(@NotNull VirtualFile root, @NotNull VirtualFile file) {
        Trinity trinity;
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(10);
        }
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(11);
        }
        try {
            GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.LS_FILES);
            h.addParameters("--exclude-standard", "--unmerged", "-z");
            h.endOptions();
            h.addRelativeFiles(Collections.singleton(file));
            String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            StringScanner s = new StringScanner(output);
            String lastBlob = null;
            String currentBlob = null;
            String originalBlob = null;
            while (s.hasMoreData()) {
                s.spaceToken();
                String blob = s.spaceToken();
                int source = Integer.parseInt(s.tabToken());
                s.boundedToken('\u0000');
                if (source == this.theirsRevision(root)) {
                    lastBlob = blob;
                    continue;
                }
                if (source == this.yoursRevision(root)) {
                    currentBlob = blob;
                    continue;
                }
                if (source == 1) {
                    originalBlob = blob;
                    continue;
                }
                throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
            }
            trinity = Trinity.create(currentBlob, originalBlob, lastBlob);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            Trinity trinity2 = Trinity.create(null, null, null);
            if (trinity2 == null) {
                GitMergeProvider.$$$reportNull$$$0(13);
            }
            return trinity2;
        }
        if (trinity == null) {
            GitMergeProvider.$$$reportNull$$$0(12);
        }
        return trinity;
    }

    @Nullable
    private FilePath getBlobPathInRevision(@NotNull VirtualFile root, @NotNull VirtualFile file, @Nullable String blob, @Nullable VcsRevisionNumber revision) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(15);
        }
        if (blob == null || revision == null) {
            return null;
        }
        FilePath path = this.doGetBlobPathInRevision(root, blob, revision, file);
        if (path != null) {
            return path;
        }
        return this.doGetBlobPathInRevision(root, blob, revision, null);
    }

    @Nullable
    private FilePath doGetBlobPathInRevision(final @NotNull VirtualFile root, final @NotNull String blob, @NotNull VcsRevisionNumber revision, @Nullable VirtualFile file) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(16);
        }
        if (blob == null) {
            GitMergeProvider.$$$reportNull$$$0(17);
        }
        if (revision == null) {
            GitMergeProvider.$$$reportNull$$$0(18);
        }
        final FilePath[] result2 = new FilePath[1];
        final boolean[] pathAmbiguous = new boolean[1];
        GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.LS_TREE);
        h.addParameters(revision.asString());
        if (file != null) {
            h.endOptions();
            h.addRelativeFiles(Collections.singleton(file));
        } else {
            h.addParameters("-r");
            h.endOptions();
        }
        h.addLineListener(new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (!line.contains(blob)) {
                    return;
                }
                if (pathAmbiguous[0]) {
                    return;
                }
                try {
                    StringScanner s = new StringScanner(line);
                    s.spaceToken();
                    String type = s.spaceToken();
                    String recordBlob = s.tabToken();
                    FilePath file = VcsUtil.getFilePath((VirtualFile)root, (String)GitUtil.unescapePath(s.line()));
                    if (!"blob".equals(type)) {
                        return;
                    }
                    if (!blob.equals(recordBlob)) {
                        return;
                    }
                    if (result2[0] == null) {
                        result2[0] = file;
                    } else {
                        pathAmbiguous[0] = true;
                    }
                }
                catch (VcsException e) {
                    LOG.warn((Throwable)e);
                }
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h);
        if (pathAmbiguous[0]) {
            return null;
        }
        return result2[0];
    }

    @Nullable
    private GitRevisionNumber findLastRevisionNumber(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(19);
        }
        return this.myReverseRoots.contains(root) ? this.resolveHead(root) : this.resolveMergeHead(root);
    }

    @Nullable
    private GitRevisionNumber findCurrentRevisionNumber(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(20);
        }
        return this.myReverseRoots.contains(root) ? this.resolveMergeHead(root) : this.resolveHead(root);
    }

    @Nullable
    private GitRevisionNumber findOriginalRevisionNumber(@NotNull VirtualFile root, @Nullable VcsRevisionNumber currentRevision, @Nullable VcsRevisionNumber lastRevision) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(21);
        }
        if (currentRevision == null || lastRevision == null) {
            return null;
        }
        try {
            return GitHistoryUtils.getMergeBase(this.myProject, root, currentRevision.asString(), lastRevision.asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private GitRevisionNumber resolveMergeHead(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(22);
        }
        try {
            return GitRevisionNumber.resolve(this.myProject, root, "MERGE_HEAD");
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve the MERGE_HEAD in " + root + ": " + e.getMessage());
            try {
                return GitRevisionNumber.resolve(this.myProject, root, "CHERRY_PICK_HEAD");
            }
            catch (VcsException e2) {
                LOG.info("Couldn't resolve the CHERRY_PICK_HEAD in " + root + ": " + e2.getMessage());
                GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
                assert (repository != null);
                File rebaseApply = repository.getRepositoryFiles().getRebaseApplyDir();
                GitRevisionNumber rebaseRevision = this.readRevisionFromFile(root, new File(rebaseApply, "original-commit"));
                if (rebaseRevision != null) {
                    return rebaseRevision;
                }
                File rebaseMerge = repository.getRepositoryFiles().getRebaseMergeDir();
                GitRevisionNumber mergeRevision = this.readRevisionFromFile(root, new File(rebaseMerge, "stopped-sha"));
                if (mergeRevision != null) {
                    return mergeRevision;
                }
                return null;
            }
        }
    }

    @Nullable
    private GitRevisionNumber readRevisionFromFile(@NotNull VirtualFile root, @NotNull File file) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(23);
        }
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(24);
        }
        if (!file.exists()) {
            return null;
        }
        String revision = DvcsUtil.tryLoadFileOrReturn((File)file, null, (String)"UTF-8");
        if (revision == null) {
            return null;
        }
        try {
            return GitRevisionNumber.resolve(this.myProject, root, revision);
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve revision  '" + revision + "' in " + root + ": " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private GitRevisionNumber resolveHead(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(25);
        }
        try {
            return GitRevisionNumber.resolve(this.myProject, root, "HEAD");
        }
        catch (VcsException e) {
            LOG.error("Couldn't resolve the HEAD in " + root, (Throwable)e);
            return null;
        }
    }

    private static byte[] loadRevisionCatchingErrors(@NotNull GitFileRevision revision) throws VcsException, IOException {
        if (revision == null) {
            GitMergeProvider.$$$reportNull$$$0(26);
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            String m = e.getMessage().trim();
            if (m.startsWith("fatal: ambiguous argument ") || m.startsWith("fatal: Path '") && m.contains("' exists on disk, but not in '") || m.contains("is in the index, but not at stage ") || m.contains("bad revision")) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            throw e;
        }
    }

    private int yoursRevision(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(27);
        }
        return this.myReverseRoots.contains(root) ? 3 : 2;
    }

    private int theirsRevision(@NotNull VirtualFile root) {
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(28);
        }
        return this.myReverseRoots.contains(root) ? 2 : 3;
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(29);
        }
        try {
            GitFileUtils.addFiles(this.myProject, GitUtil.getGitRoot(file), file);
        }
        catch (VcsException e) {
            LOG.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(30);
        }
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeSession createMergeSession(@NotNull List<VirtualFile> files) {
        if (files == null) {
            GitMergeProvider.$$$reportNull$$$0(31);
        }
        MyMergeSession myMergeSession = new MyMergeSession(files);
        if (myMergeSession == null) {
            GitMergeProvider.$$$reportNull$$$0(32);
        }
        return myMergeSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseRoots";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOrDetect";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 24: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blob";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReverseRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedBlobs";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 32: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReverseRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedBlobs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBlobPathInRevision";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetBlobPathInRevision";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLastRevisionNumber";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentRevisionNumber";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalRevisionNumber";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveMergeHead";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readRevisionFromFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveHead";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisionCatchingErrors";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "yoursRevision";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "theirsRevision";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "conflictResolvedForFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createMergeSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMergeSession
    implements MergeSession {
        Map<VirtualFile, Conflict> myConflicts = new HashMap<VirtualFile, Conflict>();

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : GitUtil.sortFilesByGitRoot(filesToMerge).entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    GitLineHandler h = new GitLineHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setStdoutSuppressed(true);
                    h.setSilent(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
                    StringScanner s = new StringScanner(output);
                    while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file, c);
                        }
                        if (source == GitMergeProvider.this.theirsRevision(root)) {
                            c.myStatusTheirs = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == GitMergeProvider.this.yoursRevision(root)) {
                            c.myStatusYours = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 1) continue;
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
                    }
                    for (VirtualFile f : files) {
                        String path = VcsFileUtil.relativePath((VirtualFile)root, (VirtualFile)f);
                        Conflict c = (Conflict)cs.get(path);
                        if (c == null) {
                            LOG.error(String.format("The conflict not found for file: %s(%s)%nFull ls-files output: %n%s%nAll files: %n%s", f.getPath(), path, output, files));
                            continue;
                        }
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = Conflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = Conflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, c);
                    }
                }
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        @NotNull
        public ColumnInfo[] getMergeInfoColumns() {
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new StatusColumn(false), new StatusColumn(true)};
            if (columnInfoArray == null) {
                MyMergeSession.$$$reportNull$$$0(0);
            }
            return columnInfoArray;
        }

        public boolean canMerge(@NotNull VirtualFile file) {
            Conflict c;
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(1);
            }
            return (c = this.myConflicts.get(file)) != null && !file.isDirectory();
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) {
            Conflict c;
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(2);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(3);
            }
            if ((c = this.myConflicts.get(file)) == null) {
                LOG.error("Conflict was not loaded for the file: " + file.getPath());
                return;
            }
            try {
                Conflict.Status status;
                switch (resolution) {
                    case AcceptedTheirs: {
                        status = c.myStatusTheirs;
                        break;
                    }
                    case AcceptedYours: {
                        status = c.myStatusYours;
                        break;
                    }
                    case Merged: {
                        status = Conflict.Status.MODIFIED;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported resolution for unmergable files(" + file.getPath() + "): " + resolution);
                    }
                }
                switch (status) {
                    case MODIFIED: {
                        GitFileUtils.addFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                        break;
                    }
                    case DELETED: {
                        GitFileUtils.deleteFiles(GitMergeProvider.this.myProject, c.myRoot, file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported status(" + file.getPath() + "): " + (Object)((Object)status));
                    }
                }
            }
            catch (VcsException e) {
                LOG.error("Unexpected exception during the git operation (" + file.getPath() + ")", (Throwable)e);
            }
        }

        public boolean acceptFileRevision(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) throws VcsException {
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(4);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(5);
            }
            if (resolution != MergeSession.Resolution.AcceptedYours && resolution != MergeSession.Resolution.AcceptedTheirs) {
                return false;
            }
            boolean isCurrent = resolution == MergeSession.Resolution.AcceptedYours;
            Conflict c = this.myConflicts.get(file);
            if (c == null) {
                LOG.error("Conflict was not loaded for the file: " + file.getPath());
                return false;
            }
            Conflict.Status status = isCurrent ? c.myStatusYours : c.myStatusTheirs;
            switch (status) {
                case MODIFIED: {
                    String parameter = GitMergeProvider.this.myReverseRoots.contains(c.myRoot) ? (isCurrent ? "--theirs" : "--ours") : (isCurrent ? "--ours" : "--theirs");
                    GitLineHandler handler = new GitLineHandler(GitMergeProvider.this.myProject, c.myRoot, GitCommand.CHECKOUT);
                    handler.addParameters(parameter);
                    handler.endOptions();
                    handler.addRelativeFiles(Collections.singletonList(c.myFile));
                    GitCommandResult result2 = Git.getInstance().runCommand(handler);
                    if (result2.success()) break;
                    throw new VcsException(result2.getErrorOutputAsJoinedString());
                }
                case DELETED: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported status(" + file.getPath() + "): " + (Object)((Object)status));
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergeInfoColumns";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMerge";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "conflictResolvedForFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptFileRevision";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsTheirs;

            public StatusColumn(boolean isTheirs) {
                super(isTheirs ? GitBundle.message("merge.tool.column.theirs.status", new Object[0]) : GitBundle.message("merge.tool.column.yours.status", new Object[0]));
                this.myIsTheirs = isTheirs;
            }

            public String valueOf(VirtualFile file) {
                Conflict c = MyMergeSession.this.myConflicts.get(file);
                if (c == null) {
                    LOG.error("No conflict for the file " + file);
                    return "";
                }
                Conflict.Status s = this.myIsTheirs ? c.myStatusTheirs : c.myStatusYours;
                switch (s) {
                    case MODIFIED: {
                        return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
                    }
                    case DELETED: {
                        return GitBundle.message("merge.tool.column.status.deleted", new Object[0]);
                    }
                }
                throw new IllegalStateException("Unknown status " + (Object)((Object)s) + " for file " + file.getPath());
            }

            public String getMaxStringValue() {
                return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        Status myStatusTheirs;
        Status myStatusYours;

        private Conflict() {
        }

        static enum Status {
            MODIFIED,
            DELETED;

        }
    }

    private static enum ReverseRequest {
        REVERSE,
        FORWARD,
        DETECT;

    }
}

