/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
extends GitImplBase {
    private static final Logger LOG = Logger.getInstance(Git.class);
    private static final List<String> REBASE_CONFIG_PARAMS = Collections.singletonList("core.commentChar=\u0001");

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(2);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        String output;
        if (project == null) {
            GitImpl.$$$reportNull$$$0(7);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(8);
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        if (StringUtil.isEmptyOrSpaces((String)(output = this.runCommand(h).getOutputOrThrow(new int[0])))) {
            HashSet<VirtualFile> hashSet = untrackedFiles;
            if (hashSet == null) {
                GitImpl.$$$reportNull$$$0(9);
            }
            return hashSet;
        }
        for (String relPath : output.split("\u0000")) {
            VirtualFile f = root.findFileByRelativePath(relPath);
            if (f == null) {
                LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            untrackedFiles.add(f);
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GitCommandResult clone(@NotNull Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(11);
        }
        if (parentDirectory == null) {
            GitImpl.$$$reportNull$$$0(12);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(13);
        }
        if (clonedDirectoryName == null) {
            GitImpl.$$$reportNull$$$0(14);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(15);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            if (project == null) {
                GitImpl.$$$reportNull$$$0(187);
            }
            if (parentDirectory == null) {
                GitImpl.$$$reportNull$$$0(188);
            }
            if (url == null) {
                GitImpl.$$$reportNull$$$0(189);
            }
            if (clonedDirectoryName == null) {
                GitImpl.$$$reportNull$$$0(190);
            }
            if (listeners == null) {
                GitImpl.$$$reportNull$$$0(191);
            }
            GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
            handler.setStdoutSuppressed(false);
            handler.setUrl(url);
            handler.addParameters("--progress");
            handler.addParameters(url);
            handler.endOptions();
            handler.addParameters(clonedDirectoryName);
            GitImpl.addListeners(handler, listeners);
            return handler;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(16);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(17);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(18);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(20);
        }
        if (range == null) {
            GitImpl.$$$reportNull$$$0(21);
        }
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(diff);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(22);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository, @NotNull Collection<String> attributes, @NotNull Collection<VirtualFile> files) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(23);
        }
        if (attributes == null) {
            GitImpl.$$$reportNull$$$0(24);
        }
        if (files == null) {
            GitImpl.$$$reportNull$$$0(25);
        }
        List relativeFilePaths = ContainerUtil.map(files, file -> {
            if (repository == null) {
                GitImpl.$$$reportNull$$$0(186);
            }
            return VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (VirtualFile)file);
        });
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters("--stdin");
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(relativeFilePaths, h.getCharset()));
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(26);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(27);
        }
        if (message == null) {
            GitImpl.$$$reportNull$$$0(28);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(29);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(30);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(31);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(32);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(33);
        }
        if (branchToMerge == null) {
            GitImpl.$$$reportNull$$$0(34);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(35);
        }
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(mergeHandler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(36);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(37);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(38);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(39);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(detach ? reference + "^0" : reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        h.endOptions();
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(40);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(41);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(42);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(43);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(44);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(45);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(46);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(47);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(48);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(49);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(50);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(51);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository repository, @NotNull String commit2) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(52);
        }
        if (commit2 == null) {
            GitImpl.$$$reportNull$$$0(53);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit2);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(54);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String startPoint) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(55);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(56);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(57);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        h.addParameters(startPoint);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(58);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(59);
        }
        if (currentName == null) {
            GitImpl.$$$reportNull$$$0(60);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(61);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(62);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-m", currentName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(63);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(64);
        }
        if (mode == null) {
            GitImpl.$$$reportNull$$$0(65);
        }
        if (target == null) {
            GitImpl.$$$reportNull$$$0(66);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(67);
        }
        GitCommandResult gitCommandResult = this.reset(repository, mode.getArgument(), target, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(68);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(69);
        }
        GitCommandResult gitCommandResult = this.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(70);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(71);
        }
        if (argument == null) {
            GitImpl.$$$reportNull$$$0(72);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(73);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(74);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(75);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(76);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(77);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(78);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(79);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(80);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(81);
        }
        GitCommandResult gitCommandResult = this.doPush(repository, remote, Collections.singleton(url), spec, false, updateTracking, false, null, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(82);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(83);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(84);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(85);
        }
        GitCommandResult gitCommandResult = this.doPush(repository, remote.getName(), remote.getPushUrls(), spec, force, updateTracking, skipHook, tagMode, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(86);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doPush(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull Collection<String> remoteUrls, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(87);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(88);
        }
        if (remoteUrls == null) {
            GitImpl.$$$reportNull$$$0(89);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(90);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(91);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            if (repository == null) {
                GitImpl.$$$reportNull$$$0(181);
            }
            if (remoteUrls == null) {
                GitImpl.$$$reportNull$$$0(182);
            }
            if (listeners == null) {
                GitImpl.$$$reportNull$$$0(183);
            }
            if (remoteName == null) {
                GitImpl.$$$reportNull$$$0(184);
            }
            if (spec == null) {
                GitImpl.$$$reportNull$$$0(185);
            }
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
            h.setUrls(remoteUrls);
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            GitImpl.addListeners(h, listeners);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(GitVcs.getInstance(repository.getProject()).getVersion())) {
                h.addParameters("--progress");
            }
            h.addParameters("--porcelain");
            h.addParameters(remoteName);
            h.addParameters(spec);
            if (updateTracking) {
                h.addParameters("--set-upstream");
            }
            if (force) {
                h.addParameters("--force");
            }
            if (tagMode != null) {
                h.addParameters(tagMode);
            }
            if (skipHook) {
                h.addParameters("--no-verify");
            }
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(92);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(93);
        }
        if (params == null) {
            GitImpl.$$$reportNull$$$0(94);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(95);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(96);
        }
        if (hash == null) {
            GitImpl.$$$reportNull$$$0(97);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(98);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        handler.addParameters("-x");
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(99);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(100);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(101);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<GitLineHandlerListener> listeners, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(102);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(103);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(104);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            if (repository == null) {
                GitImpl.$$$reportNull$$$0(178);
            }
            if (remote == null) {
                GitImpl.$$$reportNull$$$0(179);
            }
            if (listeners == null) {
                GitImpl.$$$reportNull$$$0(180);
            }
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            h.setUrls(remote.getUrls());
            h.addParameters(remote.getName());
            h.addParameters(params);
            GitVcs gitVcs = GitVcs.getInstance(repository.getProject());
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(gitVcs.getVersion())) {
                h.addParameters("--progress");
            }
            if (GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(gitVcs.getVersion())) {
                h.addParameters("--prune");
            }
            GitImpl.addListeners(h, listeners);
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(105);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(106);
        }
        if (name == null) {
            GitImpl.$$$reportNull$$$0(107);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(108);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(109);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(110);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(111);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("remove", remote.getName());
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(112);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository repository, @NotNull String oldName, @NotNull String newName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(113);
        }
        if (oldName == null) {
            GitImpl.$$$reportNull$$$0(114);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(115);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("rename", oldName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(116);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String newUrl) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(117);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(118);
        }
        if (newUrl == null) {
            GitImpl.$$$reportNull$$$0(119);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("set-url", remoteName, newUrl);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(120);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(121);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(122);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(123);
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, workingDir, url, Collections.singleton(url), new String[0]);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(124);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(125);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(126);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(127);
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), additionalParameters);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(128);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(129);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(130);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            if (repository == null) {
                GitImpl.$$$reportNull$$$0(176);
            }
            if (remote == null) {
                GitImpl.$$$reportNull$$$0(177);
            }
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE.writeLockingCommand());
            h.setStdoutSuppressed(false);
            h.addParameters("prune");
            h.addParameters(remote.getName());
            h.setUrls(remote.getUrls());
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(131);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult rebase(@NotNull GitRepository repository, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(132);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(133);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(134);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        if (parameters.isInteractive()) {
            GitRebaseEditorHandler editorHandler = parameters.getEditorHandler();
            if (editorHandler == null) {
                editorHandler = this.createEditor(project, root, handler, true);
            }
            GitCommandResult gitCommandResult = this.runWithEditor(handler, editorHandler);
            if (gitCommandResult == null) {
                GitImpl.$$$reportNull$$$0(135);
            }
            return gitCommandResult;
        }
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(136);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult rebaseAbort(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(137);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(138);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(139);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult rebaseContinue(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(140);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(141);
        }
        GitCommandResult gitCommandResult = this.rebaseResume(repository, GitRebaseResumeMode.CONTINUE, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(142);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult rebaseSkip(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(143);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(144);
        }
        GitCommandResult gitCommandResult = this.rebaseResume(repository, GitRebaseResumeMode.SKIP, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(145);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult rebaseResume(@NotNull GitRepository repository, @NotNull GitRebaseResumeMode rebaseMode, @NotNull GitLineHandlerListener[] listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(146);
        }
        if (rebaseMode == null) {
            GitImpl.$$$reportNull$$$0(147);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(148);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runWithEditor(handler, this.createEditor(project, root, handler, false));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(149);
        }
        return gitCommandResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GitCommandResult runWithEditor(@NotNull GitLineHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(150);
        }
        if (editorHandler == null) {
            GitImpl.$$$reportNull$$$0(151);
        }
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        service.configureHandler(handler, editorHandler.getHandlerNo());
        GitCommandResult result2 = this.runCommand(handler);
        GitCommandResult gitCommandResult = editorHandler.wasEditorCancelled() ? GitImpl.toCancelledResult(result2) : result2;
        GitCommandResult gitCommandResult2 = gitCommandResult;
        if (gitCommandResult2 == null) {
            GitImpl.$$$reportNull$$$0(152);
        }
        return gitCommandResult2;
        finally {
            service.unregisterHandler(editorHandler.getHandlerNo());
        }
    }

    @NotNull
    private static GitCommandResult toCancelledResult(@NotNull GitCommandResult result2) {
        if (result2 == null) {
            GitImpl.$$$reportNull$$$0(153);
        }
        int exitCode = result2.getExitCode() == 0 ? 1 : result2.getExitCode();
        GitCommandResult gitCommandResult = new GitCommandResult(false, exitCode, (List)result2.getErrorOutput(), (List)result2.getOutput()){

            @Override
            public boolean cancelled() {
                return true;
            }
        };
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(154);
        }
        return gitCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected GitInteractiveRebaseEditorHandler createEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(155);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(156);
        }
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(157);
        }
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(GitRebaseEditorService.getInstance(), project, root);
        if (!commitListAware) {
            editor.setRebaseEditorShown();
        }
        GitInteractiveRebaseEditorHandler gitInteractiveRebaseEditorHandler = editor;
        if (gitInteractiveRebaseEditorHandler == null) {
            GitImpl.$$$reportNull$$$0(158);
        }
        return gitInteractiveRebaseEditorHandler;
    }

    @Override
    @NotNull
    public GitCommandResult revert(@NotNull GitRepository repository, @NotNull String commit2, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(159);
        }
        if (commit2 == null) {
            GitImpl.$$$reportNull$$$0(160);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(161);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REVERT);
        handler.addParameters(commit2);
        if (!autoCommit) {
            handler.addParameters("--no-commit");
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(162);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doLsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String remoteId, @NotNull Collection<String> authenticationUrls, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(163);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(164);
        }
        if (remoteId == null) {
            GitImpl.$$$reportNull$$$0(165);
        }
        if (authenticationUrls == null) {
            GitImpl.$$$reportNull$$$0(166);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            if (project == null) {
                GitImpl.$$$reportNull$$$0(172);
            }
            if (workingDir == null) {
                GitImpl.$$$reportNull$$$0(173);
            }
            if (remoteId == null) {
                GitImpl.$$$reportNull$$$0(174);
            }
            if (authenticationUrls == null) {
                GitImpl.$$$reportNull$$$0(175);
            }
            GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
            h.addParameters(additionalParameters);
            h.addParameters(remoteId);
            h.setUrls(authenticationUrls);
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(167);
        }
        return gitCommandResult;
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(168);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(169);
        }
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<GitLineHandlerListener> listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(170);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(171);
        }
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 63: 
            case 68: 
            case 70: 
            case 74: 
            case 77: 
            case 82: 
            case 86: 
            case 92: 
            case 95: 
            case 99: 
            case 101: 
            case 105: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 149: 
            case 152: 
            case 154: 
            case 158: 
            case 162: 
            case 167: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 63: 
            case 68: 
            case 70: 
            case 74: 
            case 77: 
            case 82: 
            case 86: 
            case 92: 
            case 95: 
            case 99: 
            case 101: 
            case 105: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 149: 
            case 152: 
            case 154: 
            case 158: 
            case 162: 
            case 167: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 15: 
            case 31: 
            case 35: 
            case 39: 
            case 50: 
            case 62: 
            case 67: 
            case 73: 
            case 81: 
            case 91: 
            case 98: 
            case 104: 
            case 134: 
            case 138: 
            case 141: 
            case 144: 
            case 148: 
            case 161: 
            case 169: 
            case 171: 
            case 180: 
            case 183: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 63: 
            case 68: 
            case 70: 
            case 74: 
            case 77: 
            case 82: 
            case 86: 
            case 92: 
            case 95: 
            case 99: 
            case 101: 
            case 105: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 149: 
            case 152: 
            case 154: 
            case 158: 
            case 162: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImpl";
                break;
            }
            case 12: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 13: 
            case 108: 
            case 123: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clonedDirectoryName";
                break;
            }
            case 17: 
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 41: 
            case 44: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 64: 
            case 69: 
            case 71: 
            case 75: 
            case 78: 
            case 83: 
            case 87: 
            case 93: 
            case 96: 
            case 100: 
            case 102: 
            case 106: 
            case 110: 
            case 113: 
            case 117: 
            case 129: 
            case 132: 
            case 137: 
            case 140: 
            case 143: 
            case 146: 
            case 159: 
            case 176: 
            case 178: 
            case 181: 
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 20: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 42: 
            case 49: 
            case 56: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 53: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 61: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 79: 
            case 84: 
            case 103: 
            case 111: 
            case 127: 
            case 130: 
            case 177: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 80: 
            case 85: 
            case 90: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 88: 
            case 118: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 89: 
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrls";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 122: 
            case 126: 
            case 164: 
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseMode";
                break;
            }
            case 150: 
            case 157: 
            case 168: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 165: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteId";
                break;
            }
            case 166: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFiles";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFilesNoChunk";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAttr";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "stashSave";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "stashPop";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "checkout";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "checkoutNewBranch";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTag";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "branchDelete";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "branchContains";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "branchCreate";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "renameBranch";
                break;
            }
            case 68: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "resetMerge";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "tip";
                break;
            }
            case 82: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "doPush";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "cherryPick";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "addRemote";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRemote";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "renameRemote";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteUrl";
                break;
            }
            case 124: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "remotePrune";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "rebase";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseAbort";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseContinue";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSkip";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseResume";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithEditor";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "toCancelledResult";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "revert";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "doLsRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 63: 
            case 68: 
            case 70: 
            case 74: 
            case 77: 
            case 82: 
            case 86: 
            case 92: 
            case 95: 
            case 99: 
            case 101: 
            case 105: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 149: 
            case 152: 
            case 154: 
            case 158: 
            case 162: 
            case 167: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilesNoChunk";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAttr";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "stashSave";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "stashPop";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "branchDelete";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "branchContains";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "branchCreate";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "resetMerge";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "tip";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addRemote";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "removeRemote";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "renameRemote";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteUrl";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "remotePrune";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "rebaseAbort";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "rebaseContinue";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSkip";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "rebaseResume";
                break;
            }
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "runWithEditor";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "toCancelledResult";
                break;
            }
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 159: 
            case 160: 
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "doLsRemote";
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doLsRemote$5";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "lambda$remotePrune$4";
                break;
            }
            case 178: 
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetch$3";
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doPush$2";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkAttr$1";
                break;
            }
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "lambda$clone$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 32: 
            case 36: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 63: 
            case 68: 
            case 70: 
            case 74: 
            case 77: 
            case 82: 
            case 86: 
            case 92: 
            case 95: 
            case 99: 
            case 101: 
            case 105: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 149: 
            case 152: 
            case 154: 
            case 158: 
            case 162: 
            case 167: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

