/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.CredentialRequestResult;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.AuthDialog;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;
    @NotNull
    private final Collection<String> myUrlsFromCommand;
    private final boolean myIgnoreAuthenticationRequest;
    @Nullable
    private String myPassword;
    @Nullable
    private String myPasswordKey;
    @Nullable
    private String myUnifiedUrl;
    @Nullable
    private String myLogin;
    private ThreeState myIsMemoryOnly;
    @Nullable
    private GitHttpAuthDataProvider myDataProvider;
    private boolean myWasCancelled;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull GitCommand command, @NotNull Collection<String> url, boolean ignoreAuthenticationRequest) {
        if (project == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(0);
        }
        if (command == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(1);
        }
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(2);
        }
        this.myIsMemoryOnly = ThreeState.UNSURE;
        this.myProject = project;
        this.myTitle = "Git " + StringUtil.capitalize((String)command.name());
        this.myUrlsFromCommand = url;
        this.myIgnoreAuthenticationRequest = ignoreAuthenticationRequest;
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(3);
        }
        LOG.debug("askPassword. url=" + url + ", passwordKnown=" + (this.myPassword != null) + ", wasCancelled=" + this.myWasCancelled);
        if (this.myPassword != null) {
            String string = this.myPassword;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.myWasCancelled || this.myIgnoreAuthenticationRequest) {
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(5);
            }
            return "";
        }
        this.myUnifiedUrl = this.getUnifiedUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(this.getUnifiedUrl(url));
        if (authData != null && ((AuthData)authData.second).getPassword() != null) {
            String password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
            this.myPassword = password;
            LOG.debug("askPassword. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl= " + this.getUnifiedUrl(url) + ", login=" + ((AuthData)authData.second).getLogin() + ", passwordKnown=true");
            this.myIsMemoryOnly = ThreeState.UNSURE;
            String string = password;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(6);
            }
            return string;
        }
        this.myPasswordKey = this.getUnifiedUrl(url);
        CredentialRequestResult result2 = CredentialPromptDialog.askCredentials((Project)this.myProject, (String)this.myTitle, (String)("Password for " + this.getDisplayableUrl(url)), (CredentialAttributes)GitHttpGuiAuthenticator.credentialAttributes(this.myPasswordKey), (boolean)false, (boolean)false);
        String password = result2 == null ? null : result2.getCredentials().getPasswordAsString();
        LOG.debug("askPassword. Password was asked and returned: " + (password == null ? "NULL" : (password.isEmpty() ? "EMPTY" : "NOT EMPTY")));
        if (password == null) {
            this.myWasCancelled = true;
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(7);
            }
            return "";
        }
        this.myIsMemoryOnly = ThreeState.fromBoolean((boolean)result2.isMemoryOnly());
        this.myPassword = password;
        this.myDataProvider = new BaseGitAuthDataProvider(){

            @Override
            public AuthData getAuthData(@NotNull String url) {
                if (url == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new AuthData(StringUtil.notNullize((String)this.getUsername(url)), GitHttpGuiAuthenticator.this.myPassword);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$1", "getAuthData"));
            }
        };
        String string = password;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static CredentialAttributes credentialAttributes(@NotNull String key) {
        if (key == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(9);
        }
        CredentialAttributes credentialAttributes = new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"Git HTTP", (String)key), key, PASS_REQUESTER);
        if (credentialAttributes == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(10);
        }
        return credentialAttributes;
    }

    @NotNull
    private static CredentialAttributes oldCredentialAttributes(@NotNull String key) {
        if (key == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(11);
        }
        CredentialAttributes credentialAttributes = CredentialAttributesKt.CredentialAttributes(PASS_REQUESTER, (String)key);
        if (credentialAttributes == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(12);
        }
        return credentialAttributes;
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(13);
        }
        if (this.myIgnoreAuthenticationRequest) {
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(14);
            }
            return "";
        }
        this.myUnifiedUrl = this.getUnifiedUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(this.getUnifiedUrl(url));
        String login = null;
        String password = null;
        if (authData != null) {
            login = ((AuthData)authData.second).getLogin();
            password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
        }
        LOG.debug("askUsername. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl= " + this.getUnifiedUrl(url) + ", login=" + login + ", passwordKnown=" + (password != null));
        if (login != null && password != null) {
            this.myPassword = password;
            this.myIsMemoryOnly = ThreeState.UNSURE;
            String string = login;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(15);
            }
            return string;
        }
        AuthDialog dialog = this.showAuthDialog(this.getDisplayableUrl(url), login);
        LOG.debug("askUsername. Showed dialog:" + (dialog == null ? "NULL" : (dialog.isOK() ? "OK" : "Cancel")));
        if (dialog == null || !dialog.isOK()) {
            this.myWasCancelled = true;
            if ("" == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(16);
            }
            return "";
        }
        this.myPassword = dialog.getPassword();
        this.myLogin = dialog.getUsername();
        this.myIsMemoryOnly = ThreeState.fromBoolean((!dialog.isRememberPassword() ? 1 : 0) != 0);
        this.myPasswordKey = GitHttpGuiAuthenticator.makeKey(this.myUnifiedUrl, this.myLogin);
        String string = this.myLogin;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    private AuthDialog showAuthDialog(String url, String login) {
        Ref dialog = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            dialog.set((Object)new AuthDialog(this.myProject, this.myTitle, "Enter credentials for " + url, login, null, true));
            ((AuthDialog)dialog.get()).show();
        }, ModalityState.any());
        return (AuthDialog)dialog.get();
    }

    @Override
    public void saveAuthData() {
        if (this.myUnifiedUrl != null && this.myLogin != null) {
            GitRememberedInputs.getInstance().addUrl(this.myUnifiedUrl, this.myLogin);
        }
        if (this.myIsMemoryOnly != ThreeState.UNSURE && this.myPasswordKey != null && this.myPassword != null) {
            Credentials credentials = new Credentials(this.myPasswordKey, this.myPassword);
            PasswordSafe.getInstance().set(GitHttpGuiAuthenticator.credentialAttributes(this.myPasswordKey), credentials, this.myIsMemoryOnly.toBoolean());
        }
    }

    @Override
    public void forgetPassword() {
        LOG.debug("forgetPassword. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl=" + this.myUnifiedUrl);
        if (this.myDataProvider != null && this.myUnifiedUrl != null) {
            this.myDataProvider.forgetPassword(this.myUnifiedUrl);
        }
    }

    @Nullable
    private String getCurrentDataProviderName() {
        return this.myDataProvider == null ? null : this.myDataProvider.getClass().getName();
    }

    @Override
    public boolean wasCancelled() {
        return this.myWasCancelled;
    }

    @NotNull
    private String getDisplayableUrl(@Nullable String urlFromGit) {
        String string = !StringUtil.isEmptyOrSpaces((String)urlFromGit) ? urlFromGit : this.findPresetHttpUrl();
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private String getUnifiedUrl(@Nullable String urlFromGit) {
        String string = GitHttpGuiAuthenticator.changeHttpsToHttp(StringUtil.isEmptyOrSpaces((String)urlFromGit) ? this.findPresetHttpUrl() : urlFromGit);
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private String findPresetHttpUrl() {
        String string = (String)ObjectUtils.chooseNotNull((Object)ContainerUtil.find(this.myUrlsFromCommand, url -> {
            String scheme = (String)UriUtil.splitScheme((String)url).getFirst();
            return scheme.startsWith("http");
        }), (Object)ContainerUtil.getFirstItem(this.myUrlsFromCommand));
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static String changeHttpsToHttp(@NotNull String url) {
        String prefix;
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(21);
        }
        if (url.startsWith(prefix = "https")) {
            String string = "http" + url.substring(prefix.length());
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    private Pair<GitHttpAuthDataProvider, AuthData> findBestAuthData(@NotNull String url) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(24);
        }
        Pair candidate = null;
        for (GitHttpAuthDataProvider provider : this.getProviders()) {
            AuthData data = provider.getAuthData(url);
            if (data == null) continue;
            Pair pair = Pair.create((Object)provider, (Object)data);
            if (data.getPassword() != null) {
                return pair;
            }
            if (candidate != null) continue;
            candidate = pair;
        }
        return candidate;
    }

    @NotNull
    private List<GitHttpAuthDataProvider> getProviders() {
        ArrayList providers = ContainerUtil.newArrayList();
        providers.add(new BaseGitAuthDataProvider(){

            @Override
            public AuthData getAuthData(@NotNull String url) {
                if (url == null) {
                    2.$$$reportNull$$$0(0);
                }
                String userName = this.getUsername(url);
                String key = GitHttpGuiAuthenticator.makeKey(url, userName);
                Credentials credentials = CredentialAttributesKt.getAndMigrateCredentials((CredentialAttributes)GitHttpGuiAuthenticator.oldCredentialAttributes(key), (CredentialAttributes)GitHttpGuiAuthenticator.credentialAttributes(key));
                return new AuthData(StringUtil.notNullize((String)userName), credentials == null ? null : credentials.getPasswordAsString());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHttpGuiAuthenticator$2", "getAuthData"));
            }
        });
        providers.addAll(Arrays.asList(GitHttpAuthDataProvider.EP_NAME.getExtensions()));
        ArrayList arrayList = providers;
        if (arrayList == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static String makeKey(@NotNull String url, @Nullable String login) {
        if (url == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(26);
        }
        if (login == null) {
            String string = url;
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(27);
            }
            return string;
        }
        Couple pair = UriUtil.splitScheme((String)url);
        String scheme = (String)pair.getFirst();
        if (!StringUtil.isEmpty((String)scheme)) {
            String string = scheme + "://" + login + "@" + (String)pair.getSecond();
            if (string == null) {
                GitHttpGuiAuthenticator.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = login + "@" + url;
        if (string == null) {
            GitHttpGuiAuthenticator.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "askPassword";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "credentialAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "oldCredentialAttributes";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "askUsername";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnifiedUrl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findPresetHttpUrl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "changeHttpsToHttp";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "makeKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "askPassword";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "credentialAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "oldCredentialAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "askUsername";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "changeHttpsToHttp";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findBestAuthData";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "makeKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class BaseGitAuthDataProvider
    implements GitHttpAuthDataProvider {
        private BaseGitAuthDataProvider() {
        }

        @Nullable
        protected final String getUsername(@NotNull String url) {
            if (url == null) {
                BaseGitAuthDataProvider.$$$reportNull$$$0(0);
            }
            return GitRememberedInputs.getInstance().getUserNameForUrl(url);
        }

        @Override
        public final void forgetPassword(@NotNull String url) {
            if (url == null) {
                BaseGitAuthDataProvider.$$$reportNull$$$0(1);
            }
            GitHttpGuiAuthenticator.this.myPassword = null;
            GitHttpGuiAuthenticator.this.myIsMemoryOnly = ThreeState.UNSURE;
            String key = GitHttpGuiAuthenticator.this.myPasswordKey == null ? GitHttpGuiAuthenticator.makeKey(url, this.getUsername(url)) : GitHttpGuiAuthenticator.this.myPasswordKey;
            CredentialAttributes attributes = GitHttpGuiAuthenticator.credentialAttributes(key);
            LOG.debug("forgetPassword. key=" + attributes.getUserName());
            PasswordSafe.getInstance().set(attributes, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "url";
            objectArray2[1] = "git4idea/commands/GitHttpGuiAuthenticator$BaseGitAuthDataProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUsername";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forgetPassword";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

