/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtilRt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitAction;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends GitAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)ObjectUtils.assertNotNull((Object)event.getProject());
        GitVcs vcs = GitVcs.getInstance(project);
        TreeSet<VirtualFile> conflictedFiles = new TreeSet<VirtualFile>((f1, f2) -> f1.getPresentableUrl().compareTo(f2.getPresentableUrl()));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file = before.getFile().getVirtualFile()) != null) {
                conflictedFiles.add(file);
            }
            if (after == null || (file = after.getFile().getVirtualFile()) == null) continue;
            conflictedFiles.add(file);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog((List)ContainerUtilRt.newArrayList(conflictedFiles), vcs.getMergeProvider());
        for (GitRepository repository : GitUtil.getRepositoriesForFiles(project, conflictedFiles)) {
            repository.update();
        }
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent event) {
        Collection changes;
        if (event == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(1);
        }
        if ((changes = ChangeListManager.getInstance((Project)event.getProject()).getAllChanges()).size() > 1000) {
            return true;
        }
        for (Change change : changes) {
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(2);
        }
        super.update(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(e.getPresentation().isEnabled());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "git4idea/actions/GitResolveConflictsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

