/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.dom;

import com.sun.webkit.Disposer;
import com.sun.webkit.dom.AttrImpl;
import com.sun.webkit.dom.CDATASectionImpl;
import com.sun.webkit.dom.CommentImpl;
import com.sun.webkit.dom.DocumentFragmentImpl;
import com.sun.webkit.dom.DocumentImpl;
import com.sun.webkit.dom.DocumentTypeImpl;
import com.sun.webkit.dom.ElementImpl;
import com.sun.webkit.dom.EntityImpl;
import com.sun.webkit.dom.EntityReferenceImpl;
import com.sun.webkit.dom.EventImpl;
import com.sun.webkit.dom.EventListenerImpl;
import com.sun.webkit.dom.HTMLAnchorElementImpl;
import com.sun.webkit.dom.HTMLAppletElementImpl;
import com.sun.webkit.dom.HTMLAreaElementImpl;
import com.sun.webkit.dom.HTMLBRElementImpl;
import com.sun.webkit.dom.HTMLBaseElementImpl;
import com.sun.webkit.dom.HTMLBaseFontElementImpl;
import com.sun.webkit.dom.HTMLBodyElementImpl;
import com.sun.webkit.dom.HTMLButtonElementImpl;
import com.sun.webkit.dom.HTMLDListElementImpl;
import com.sun.webkit.dom.HTMLDirectoryElementImpl;
import com.sun.webkit.dom.HTMLDivElementImpl;
import com.sun.webkit.dom.HTMLDocumentImpl;
import com.sun.webkit.dom.HTMLElementImpl;
import com.sun.webkit.dom.HTMLFieldSetElementImpl;
import com.sun.webkit.dom.HTMLFontElementImpl;
import com.sun.webkit.dom.HTMLFormElementImpl;
import com.sun.webkit.dom.HTMLFrameElementImpl;
import com.sun.webkit.dom.HTMLFrameSetElementImpl;
import com.sun.webkit.dom.HTMLHRElementImpl;
import com.sun.webkit.dom.HTMLHeadElementImpl;
import com.sun.webkit.dom.HTMLHeadingElementImpl;
import com.sun.webkit.dom.HTMLIFrameElementImpl;
import com.sun.webkit.dom.HTMLImageElementImpl;
import com.sun.webkit.dom.HTMLInputElementImpl;
import com.sun.webkit.dom.HTMLLIElementImpl;
import com.sun.webkit.dom.HTMLLabelElementImpl;
import com.sun.webkit.dom.HTMLLegendElementImpl;
import com.sun.webkit.dom.HTMLLinkElementImpl;
import com.sun.webkit.dom.HTMLMapElementImpl;
import com.sun.webkit.dom.HTMLMenuElementImpl;
import com.sun.webkit.dom.HTMLMetaElementImpl;
import com.sun.webkit.dom.HTMLModElementImpl;
import com.sun.webkit.dom.HTMLOListElementImpl;
import com.sun.webkit.dom.HTMLObjectElementImpl;
import com.sun.webkit.dom.HTMLOptGroupElementImpl;
import com.sun.webkit.dom.HTMLOptionElementImpl;
import com.sun.webkit.dom.HTMLParagraphElementImpl;
import com.sun.webkit.dom.HTMLParamElementImpl;
import com.sun.webkit.dom.HTMLPreElementImpl;
import com.sun.webkit.dom.HTMLQuoteElementImpl;
import com.sun.webkit.dom.HTMLScriptElementImpl;
import com.sun.webkit.dom.HTMLSelectElementImpl;
import com.sun.webkit.dom.HTMLStyleElementImpl;
import com.sun.webkit.dom.HTMLTableCaptionElementImpl;
import com.sun.webkit.dom.HTMLTableCellElementImpl;
import com.sun.webkit.dom.HTMLTableColElementImpl;
import com.sun.webkit.dom.HTMLTableElementImpl;
import com.sun.webkit.dom.HTMLTableRowElementImpl;
import com.sun.webkit.dom.HTMLTableSectionElementImpl;
import com.sun.webkit.dom.HTMLTextAreaElementImpl;
import com.sun.webkit.dom.HTMLTitleElementImpl;
import com.sun.webkit.dom.HTMLUListElementImpl;
import com.sun.webkit.dom.JSObject;
import com.sun.webkit.dom.NamedNodeMapImpl;
import com.sun.webkit.dom.NodeListImpl;
import com.sun.webkit.dom.ProcessingInstructionImpl;
import com.sun.webkit.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
extends JSObject
implements Node,
EventTarget {
    private static SelfDisposer[] hashTable = new SelfDisposer[64];
    private static int hashCount;
    public static final int ELEMENT_NODE = 1;
    public static final int ATTRIBUTE_NODE = 2;
    public static final int TEXT_NODE = 3;
    public static final int CDATA_SECTION_NODE = 4;
    public static final int ENTITY_REFERENCE_NODE = 5;
    public static final int ENTITY_NODE = 6;
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    public static final int COMMENT_NODE = 8;
    public static final int DOCUMENT_NODE = 9;
    public static final int DOCUMENT_TYPE_NODE = 10;
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    public static final int NOTATION_NODE = 12;
    public static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    public static final int DOCUMENT_POSITION_PRECEDING = 2;
    public static final int DOCUMENT_POSITION_FOLLOWING = 4;
    public static final int DOCUMENT_POSITION_CONTAINS = 8;
    public static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    public static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;

    private static int hashPeer(long peer) {
        return (int)(peer ^ 0xFFFFFFFFFFFFFFFFL ^ peer >> 7) & hashTable.length - 1;
    }

    private static Node getCachedImpl(long peer) {
        if (peer == 0L) {
            return null;
        }
        int hash = NodeImpl.hashPeer(peer);
        SelfDisposer head = hashTable[hash];
        SelfDisposer prev = null;
        SelfDisposer disposer = head;
        while (disposer != null) {
            SelfDisposer next = disposer.next;
            if (disposer.peer == peer) {
                NodeImpl node = (NodeImpl)disposer.get();
                if (node != null) {
                    NodeImpl.dispose(peer);
                    return node;
                }
                if (prev != null) {
                    prev.next = next;
                    break;
                }
                NodeImpl.hashTable[hash] = next;
                break;
            }
            prev = disposer;
            disposer = next;
        }
        NodeImpl node = (NodeImpl)NodeImpl.createInterface(peer);
        SelfDisposer disposer2 = new SelfDisposer(node, peer);
        disposer2.next = head;
        NodeImpl.hashTable[hash] = disposer2;
        if (3 * hashCount >= 2 * hashTable.length) {
            NodeImpl.rehash();
        }
        ++hashCount;
        return node;
    }

    private static void rehash() {
        SelfDisposer[] oldTable = hashTable;
        int oldLength = oldTable.length;
        SelfDisposer[] newTable = new SelfDisposer[2 * oldLength];
        hashTable = newTable;
        int i = oldLength;
        while (--i >= 0) {
            SelfDisposer disposer = oldTable[i];
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                int hash = NodeImpl.hashPeer(disposer.peer);
                disposer.next = newTable[hash];
                newTable[hash] = disposer;
                disposer = next;
            }
        }
    }

    NodeImpl(long peer) {
        super(peer, 1);
    }

    static Node createInterface(long peer) {
        if (peer == 0L) {
            return null;
        }
        switch (NodeImpl.getNodeTypeImpl(peer)) {
            case 1: {
                if (!ElementImpl.isHTMLElementImpl(peer)) {
                    return new ElementImpl(peer);
                }
                String tagName = ElementImpl.getTagNameImpl(peer).toUpperCase();
                if ("A".equals(tagName)) {
                    return new HTMLAnchorElementImpl(peer);
                }
                if ("APPLET".equals(tagName)) {
                    return new HTMLAppletElementImpl(peer);
                }
                if ("AREA".equals(tagName)) {
                    return new HTMLAreaElementImpl(peer);
                }
                if ("BASE".equals(tagName)) {
                    return new HTMLBaseElementImpl(peer);
                }
                if ("BASEFONT".equals(tagName)) {
                    return new HTMLBaseFontElementImpl(peer);
                }
                if ("BODY".equals(tagName)) {
                    return new HTMLBodyElementImpl(peer);
                }
                if ("BR".equals(tagName)) {
                    return new HTMLBRElementImpl(peer);
                }
                if ("BUTTON".equals(tagName)) {
                    return new HTMLButtonElementImpl(peer);
                }
                if ("DIR".equals(tagName)) {
                    return new HTMLDirectoryElementImpl(peer);
                }
                if ("DIV".equals(tagName)) {
                    return new HTMLDivElementImpl(peer);
                }
                if ("DL".equals(tagName)) {
                    return new HTMLDListElementImpl(peer);
                }
                if ("FIELDSET".equals(tagName)) {
                    return new HTMLFieldSetElementImpl(peer);
                }
                if ("FONT".equals(tagName)) {
                    return new HTMLFontElementImpl(peer);
                }
                if ("FORM".equals(tagName)) {
                    return new HTMLFormElementImpl(peer);
                }
                if ("FRAME".equals(tagName)) {
                    return new HTMLFrameElementImpl(peer);
                }
                if ("FRAMESET".equals(tagName)) {
                    return new HTMLFrameSetElementImpl(peer);
                }
                if ("HEAD".equals(tagName)) {
                    return new HTMLHeadElementImpl(peer);
                }
                if (tagName.length() == 2 && tagName.charAt(0) == 'H' && tagName.charAt(1) >= '1' && tagName.charAt(1) <= '6') {
                    return new HTMLHeadingElementImpl(peer);
                }
                if ("HR".equals(tagName)) {
                    return new HTMLHRElementImpl(peer);
                }
                if ("IFRAME".equals(tagName)) {
                    return new HTMLIFrameElementImpl(peer);
                }
                if ("IMG".equals(tagName)) {
                    return new HTMLImageElementImpl(peer);
                }
                if ("INPUT".equals(tagName)) {
                    return new HTMLInputElementImpl(peer);
                }
                if ("LABEL".equals(tagName)) {
                    return new HTMLLabelElementImpl(peer);
                }
                if ("LEGEND".equals(tagName)) {
                    return new HTMLLegendElementImpl(peer);
                }
                if ("LI".equals(tagName)) {
                    return new HTMLLIElementImpl(peer);
                }
                if ("LINK".equals(tagName)) {
                    return new HTMLLinkElementImpl(peer);
                }
                if ("MAP".equals(tagName)) {
                    return new HTMLMapElementImpl(peer);
                }
                if ("MENU".equals(tagName)) {
                    return new HTMLMenuElementImpl(peer);
                }
                if ("META".equals(tagName)) {
                    return new HTMLMetaElementImpl(peer);
                }
                if ("INS".equals(tagName) || "DEL".equals(tagName)) {
                    return new HTMLModElementImpl(peer);
                }
                if ("OBJECT".equals(tagName)) {
                    return new HTMLObjectElementImpl(peer);
                }
                if ("OL".equals(tagName)) {
                    return new HTMLOListElementImpl(peer);
                }
                if ("OPTGROUP".equals(tagName)) {
                    return new HTMLOptGroupElementImpl(peer);
                }
                if ("OPTION".equals(tagName)) {
                    return new HTMLOptionElementImpl(peer);
                }
                if ("P".equals(tagName)) {
                    return new HTMLParagraphElementImpl(peer);
                }
                if ("PARAM".equals(tagName)) {
                    return new HTMLParamElementImpl(peer);
                }
                if ("PRE".equals(tagName)) {
                    return new HTMLPreElementImpl(peer);
                }
                if ("Q".equals(tagName)) {
                    return new HTMLQuoteElementImpl(peer);
                }
                if ("SCRIPT".equals(tagName)) {
                    return new HTMLScriptElementImpl(peer);
                }
                if ("SELECT".equals(tagName)) {
                    return new HTMLSelectElementImpl(peer);
                }
                if ("STYLE".equals(tagName)) {
                    return new HTMLStyleElementImpl(peer);
                }
                if ("CAPTION".equals(tagName)) {
                    return new HTMLTableCaptionElementImpl(peer);
                }
                if ("TD".equals(tagName)) {
                    return new HTMLTableCellElementImpl(peer);
                }
                if ("COL".equals(tagName)) {
                    return new HTMLTableColElementImpl(peer);
                }
                if ("TABLE".equals(tagName)) {
                    return new HTMLTableElementImpl(peer);
                }
                if ("TR".equals(tagName)) {
                    return new HTMLTableRowElementImpl(peer);
                }
                if ("THEAD".equals(tagName) || "TFOOT".equals(tagName) || "TBODY".equals(tagName)) {
                    return new HTMLTableSectionElementImpl(peer);
                }
                if ("TEXTAREA".equals(tagName)) {
                    return new HTMLTextAreaElementImpl(peer);
                }
                if ("TITLE".equals(tagName)) {
                    return new HTMLTitleElementImpl(peer);
                }
                if ("UL".equals(tagName)) {
                    return new HTMLUListElementImpl(peer);
                }
                return new HTMLElementImpl(peer);
            }
            case 2: {
                return new AttrImpl(peer);
            }
            case 3: {
                return new TextImpl(peer);
            }
            case 4: {
                return new CDATASectionImpl(peer);
            }
            case 5: {
                return new EntityReferenceImpl(peer);
            }
            case 6: {
                return new EntityImpl(peer);
            }
            case 7: {
                return new ProcessingInstructionImpl(peer);
            }
            case 8: {
                return new CommentImpl(peer);
            }
            case 9: {
                if (DocumentImpl.isHTMLDocumentImpl(peer)) {
                    return new HTMLDocumentImpl(peer);
                }
                return new DocumentImpl(peer);
            }
            case 10: {
                return new DocumentTypeImpl(peer);
            }
            case 11: {
                return new DocumentFragmentImpl(peer);
            }
        }
        return new NodeImpl(peer);
    }

    static Node create(long peer) {
        return NodeImpl.getCachedImpl(peer);
    }

    static long getPeer(Node arg) {
        return arg == null ? 0L : ((NodeImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static Node getImpl(long peer) {
        return NodeImpl.create(peer);
    }

    @Override
    public String getNodeName() {
        return NodeImpl.getNodeNameImpl(this.getPeer());
    }

    static native String getNodeNameImpl(long var0);

    @Override
    public String getNodeValue() {
        return NodeImpl.getNodeValueImpl(this.getPeer());
    }

    static native String getNodeValueImpl(long var0);

    @Override
    public void setNodeValue(String value) throws DOMException {
        NodeImpl.setNodeValueImpl(this.getPeer(), value);
    }

    static native void setNodeValueImpl(long var0, String var2);

    @Override
    public short getNodeType() {
        return NodeImpl.getNodeTypeImpl(this.getPeer());
    }

    static native short getNodeTypeImpl(long var0);

    @Override
    public Node getParentNode() {
        return NodeImpl.getImpl(NodeImpl.getParentNodeImpl(this.getPeer()));
    }

    static native long getParentNodeImpl(long var0);

    @Override
    public NodeList getChildNodes() {
        return NodeListImpl.getImpl(NodeImpl.getChildNodesImpl(this.getPeer()));
    }

    static native long getChildNodesImpl(long var0);

    @Override
    public Node getFirstChild() {
        return NodeImpl.getImpl(NodeImpl.getFirstChildImpl(this.getPeer()));
    }

    static native long getFirstChildImpl(long var0);

    @Override
    public Node getLastChild() {
        return NodeImpl.getImpl(NodeImpl.getLastChildImpl(this.getPeer()));
    }

    static native long getLastChildImpl(long var0);

    @Override
    public Node getPreviousSibling() {
        return NodeImpl.getImpl(NodeImpl.getPreviousSiblingImpl(this.getPeer()));
    }

    static native long getPreviousSiblingImpl(long var0);

    @Override
    public Node getNextSibling() {
        return NodeImpl.getImpl(NodeImpl.getNextSiblingImpl(this.getPeer()));
    }

    static native long getNextSiblingImpl(long var0);

    @Override
    public Document getOwnerDocument() {
        return DocumentImpl.getImpl(NodeImpl.getOwnerDocumentImpl(this.getPeer()));
    }

    static native long getOwnerDocumentImpl(long var0);

    @Override
    public String getNamespaceURI() {
        return NodeImpl.getNamespaceURIImpl(this.getPeer());
    }

    static native String getNamespaceURIImpl(long var0);

    @Override
    public String getPrefix() {
        return NodeImpl.getPrefixImpl(this.getPeer());
    }

    static native String getPrefixImpl(long var0);

    @Override
    public void setPrefix(String value) throws DOMException {
        NodeImpl.setPrefixImpl(this.getPeer(), value);
    }

    static native void setPrefixImpl(long var0, String var2);

    @Override
    public String getLocalName() {
        return NodeImpl.getLocalNameImpl(this.getPeer());
    }

    static native String getLocalNameImpl(long var0);

    @Override
    public NamedNodeMap getAttributes() {
        return NamedNodeMapImpl.getImpl(NodeImpl.getAttributesImpl(this.getPeer()));
    }

    static native long getAttributesImpl(long var0);

    @Override
    public String getBaseURI() {
        return NodeImpl.getBaseURIImpl(this.getPeer());
    }

    static native String getBaseURIImpl(long var0);

    @Override
    public String getTextContent() {
        return NodeImpl.getTextContentImpl(this.getPeer());
    }

    static native String getTextContentImpl(long var0);

    @Override
    public void setTextContent(String value) throws DOMException {
        NodeImpl.setTextContentImpl(this.getPeer(), value);
    }

    static native void setTextContentImpl(long var0, String var2);

    public Element getParentElement() {
        return ElementImpl.getImpl(NodeImpl.getParentElementImpl(this.getPeer()));
    }

    static native long getParentElementImpl(long var0);

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.insertBeforeImpl(this.getPeer(), NodeImpl.getPeer(newChild), NodeImpl.getPeer(refChild)));
    }

    static native long insertBeforeImpl(long var0, long var2, long var4);

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.replaceChildImpl(this.getPeer(), NodeImpl.getPeer(newChild), NodeImpl.getPeer(oldChild)));
    }

    static native long replaceChildImpl(long var0, long var2, long var4);

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.removeChildImpl(this.getPeer(), NodeImpl.getPeer(oldChild)));
    }

    static native long removeChildImpl(long var0, long var2);

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return NodeImpl.getImpl(NodeImpl.appendChildImpl(this.getPeer(), NodeImpl.getPeer(newChild)));
    }

    static native long appendChildImpl(long var0, long var2);

    @Override
    public boolean hasChildNodes() {
        return NodeImpl.hasChildNodesImpl(this.getPeer());
    }

    static native boolean hasChildNodesImpl(long var0);

    @Override
    public Node cloneNode(boolean deep) {
        return NodeImpl.getImpl(NodeImpl.cloneNodeImpl(this.getPeer(), deep));
    }

    static native long cloneNodeImpl(long var0, boolean var2);

    @Override
    public void normalize() {
        NodeImpl.normalizeImpl(this.getPeer());
    }

    static native void normalizeImpl(long var0);

    @Override
    public boolean isSupported(String feature, String version) {
        return NodeImpl.isSupportedImpl(this.getPeer(), feature, version);
    }

    static native boolean isSupportedImpl(long var0, String var2, String var3);

    @Override
    public boolean hasAttributes() {
        return NodeImpl.hasAttributesImpl(this.getPeer());
    }

    static native boolean hasAttributesImpl(long var0);

    @Override
    public boolean isSameNode(Node other) {
        return NodeImpl.isSameNodeImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean isSameNodeImpl(long var0, long var2);

    @Override
    public boolean isEqualNode(Node other) {
        return NodeImpl.isEqualNodeImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean isEqualNodeImpl(long var0, long var2);

    @Override
    public String lookupPrefix(String namespaceURI) {
        return NodeImpl.lookupPrefixImpl(this.getPeer(), namespaceURI);
    }

    static native String lookupPrefixImpl(long var0, String var2);

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return NodeImpl.isDefaultNamespaceImpl(this.getPeer(), namespaceURI);
    }

    static native boolean isDefaultNamespaceImpl(long var0, String var2);

    @Override
    public String lookupNamespaceURI(String prefix) {
        return NodeImpl.lookupNamespaceURIImpl(this.getPeer(), prefix);
    }

    static native String lookupNamespaceURIImpl(long var0, String var2);

    @Override
    public short compareDocumentPosition(Node other) {
        return NodeImpl.compareDocumentPositionImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native short compareDocumentPositionImpl(long var0, long var2);

    public boolean contains(Node other) {
        return NodeImpl.containsImpl(this.getPeer(), NodeImpl.getPeer(other));
    }

    static native boolean containsImpl(long var0, long var2);

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.addEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener), useCapture);
    }

    static native void addEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.removeEventListenerImpl(this.getPeer(), type, EventListenerImpl.getPeer(listener), useCapture);
    }

    static native void removeEventListenerImpl(long var0, String var2, long var3, boolean var5);

    @Override
    public boolean dispatchEvent(Event event) throws DOMException {
        return NodeImpl.dispatchEventImpl(this.getPeer(), EventImpl.getPeer(event));
    }

    static native boolean dispatchEventImpl(long var0, long var2);

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static final class SelfDisposer
    extends Disposer.WeakDisposerRecord {
        private final long peer;
        SelfDisposer next;

        SelfDisposer(Object referent, long _peer) {
            super(referent);
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            int hash = NodeImpl.hashPeer(this.peer);
            SelfDisposer head = hashTable[hash];
            SelfDisposer prev = null;
            SelfDisposer disposer = head;
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                if (disposer.peer == this.peer) {
                    disposer.clear();
                    if (prev != null) {
                        prev.next = next;
                    } else {
                        hashTable[hash] = next;
                    }
                    hashCount--;
                    break;
                }
                prev = disposer;
                disposer = next;
            }
            NodeImpl.dispose(this.peer);
        }
    }
}

