/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WatchdogTimer {
    private static final Logger logger = Logger.getLogger(WatchdogTimer.class.getName());
    private static final ThreadFactory threadFactory = new CustomThreadFactory();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
    private final Runnable runnable;
    private ScheduledFuture<?> future;

    private WatchdogTimer(long nativePointer) {
        this.executor.setRemoveOnCancelPolicy(true);
        this.runnable = () -> {
            try {
                this.twkFire(nativePointer);
            }
            catch (Throwable th) {
                logger.log(Level.WARNING, "Error firing watchdog timer", th);
            }
        };
    }

    private static WatchdogTimer fwkCreate(long nativePointer) {
        return new WatchdogTimer(nativePointer);
    }

    private void fwkStart(double limit) {
        if (this.future != null) {
            throw new IllegalStateException();
        }
        this.future = this.executor.schedule(this.runnable, (long)(limit * 1000.0) + 50L, TimeUnit.MILLISECONDS);
    }

    private void fwkStop() {
        if (this.future == null) {
            throw new IllegalStateException();
        }
        this.future.cancel(false);
        this.future = null;
    }

    private void fwkDestroy() {
        this.executor.shutdownNow();
        while (true) {
            try {
                while (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private native void twkFire(long var1);

    private static final class CustomThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger index = new AtomicInteger(1);

        private CustomThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "Watchdog-Timer-" + this.index.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

