/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.javafx.PlatformUtil;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.Renderer;
import java.lang.reflect.Method;
import java.security.AccessController;

class RendererFactory {
    private static String rootPkg = "com.sun.scenario.effect";
    private static boolean tryRSL = true;
    private static boolean trySIMD = false;
    private static boolean tryJOGL = PlatformUtil.isMac();
    private static boolean tryPrism = true;

    RendererFactory() {
    }

    private static boolean isRSLFriendly(Class klass) {
        if (klass.getName().equals("sun.java2d.pipe.hw.AccelGraphicsConfig")) {
            return true;
        }
        boolean rsl = false;
        for (Class<?> iface : klass.getInterfaces()) {
            if (!RendererFactory.isRSLFriendly(iface)) continue;
            rsl = true;
            break;
        }
        return rsl;
    }

    private static boolean isRSLAvailable(FilterContext fctx) {
        return RendererFactory.isRSLFriendly(fctx.getReferent().getClass());
    }

    private static Renderer createRSLRenderer(FilterContext fctx) {
        try {
            Class<?> klass = Class.forName(rootPkg + ".impl.j2d.rsl.RSLRenderer");
            Method m = klass.getMethod("createRenderer", FilterContext.class);
            return (Renderer)m.invoke(null, fctx);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Renderer createJOGLRenderer(FilterContext fctx) {
        if (tryJOGL) {
            try {
                Class<?> klass = Class.forName(rootPkg + ".impl.j2d.jogl.JOGLRenderer");
                Method m = klass.getMethod("createRenderer", FilterContext.class);
                return (Renderer)m.invoke(null, fctx);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Renderer createPrismRenderer(FilterContext fctx) {
        if (tryPrism) {
            try {
                Class<?> klass = Class.forName(rootPkg + ".impl.prism.PrRenderer");
                Method m = klass.getMethod("createRenderer", FilterContext.class);
                return (Renderer)m.invoke(null, fctx);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Renderer getSSERenderer() {
        if (trySIMD) {
            try {
                Class<?> klass = Class.forName(rootPkg + ".impl.j2d.J2DSWRenderer");
                Method m = klass.getMethod("getSSEInstance", null);
                Renderer sseRenderer = (Renderer)m.invoke(null, (Object[])null);
                if (sseRenderer != null) {
                    return sseRenderer;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            trySIMD = false;
        }
        return null;
    }

    private static Renderer getJavaRenderer() {
        try {
            Class<?> klass = Class.forName(rootPkg + ".impl.prism.sw.PSWRenderer");
            Class<?> screenClass = Class.forName("com.sun.glass.ui.Screen");
            Method m = klass.getMethod("createJSWInstance", screenClass);
            Renderer jswRenderer = (Renderer)m.invoke(null, new Object[]{null});
            if (jswRenderer != null) {
                return jswRenderer;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Renderer getJavaRenderer(FilterContext fctx) {
        try {
            Class<?> klass = Class.forName(rootPkg + ".impl.prism.sw.PSWRenderer");
            Method m = klass.getMethod("createJSWInstance", FilterContext.class);
            Renderer jswRenderer = (Renderer)m.invoke(null, fctx);
            if (jswRenderer != null) {
                return jswRenderer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static Renderer getSoftwareRenderer() {
        Renderer r = RendererFactory.getSSERenderer();
        if (r == null) {
            r = RendererFactory.getJavaRenderer();
        }
        return r;
    }

    static Renderer createRenderer(FilterContext fctx) {
        return AccessController.doPrivileged(() -> {
            Renderer r = null;
            String klassName = fctx.getClass().getName();
            String simpleName = klassName.substring(klassName.lastIndexOf(".") + 1);
            if (simpleName.equals("PrFilterContext") && tryPrism) {
                r = RendererFactory.createPrismRenderer(fctx);
            }
            if (r == null && tryRSL && RendererFactory.isRSLAvailable(fctx)) {
                r = RendererFactory.createRSLRenderer(fctx);
            }
            if (r == null && tryJOGL) {
                r = RendererFactory.createJOGLRenderer(fctx);
            }
            if (r == null && trySIMD) {
                r = RendererFactory.getSSERenderer();
            }
            if (r == null) {
                r = RendererFactory.getJavaRenderer(fctx);
            }
            return r;
        });
    }

    static {
        try {
            String tryJOGLProp;
            if ("false".equals(System.getProperty("decora.rsl"))) {
                tryRSL = false;
            }
            if ("false".equals(System.getProperty("decora.simd"))) {
                trySIMD = false;
            }
            if ((tryJOGLProp = System.getProperty("decora.jogl")) != null) {
                tryJOGL = Boolean.parseBoolean(tryJOGLProp);
            }
            if ("false".equals(System.getProperty("decora.prism"))) {
                tryPrism = false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

