/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public class WeakReferenceQueue<E> {
    private final ReferenceQueue garbage = new ReferenceQueue();
    private Object strongRef = new Object();
    private ListEntry head = new ListEntry(this.strongRef, this.garbage);
    int size = 0;

    public void add(E obj) {
        this.cleanup();
        ++this.size;
        new ListEntry(obj, this.garbage).insert(this.head.prev);
    }

    public void remove(E obj) {
        this.cleanup();
        ListEntry entry = this.head.next;
        while (entry != this.head) {
            Object other = entry.get();
            if (other == obj) {
                --this.size;
                entry.remove();
                return;
            }
            entry = entry.next;
        }
    }

    public void cleanup() {
        ListEntry entry;
        while ((entry = (ListEntry)this.garbage.poll()) != null) {
            --this.size;
            entry.remove();
        }
    }

    public Iterator<? super E> iterator() {
        return new Iterator(){
            private ListEntry index;
            private Object next;
            {
                this.index = WeakReferenceQueue.this.head;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                ListEntry nextIndex;
                this.next = null;
                while (this.next == null && (nextIndex = this.index.prev) != WeakReferenceQueue.this.head) {
                    this.next = nextIndex.get();
                    if (this.next != null) continue;
                    --WeakReferenceQueue.this.size;
                    nextIndex.remove();
                }
                return this.next != null;
            }

            public Object next() {
                this.hasNext();
                this.index = this.index.prev;
                return this.next;
            }

            @Override
            public void remove() {
                if (this.index != WeakReferenceQueue.this.head) {
                    ListEntry nextIndex = this.index.next;
                    --WeakReferenceQueue.this.size;
                    this.index.remove();
                    this.index = nextIndex;
                }
            }
        };
    }

    private static class ListEntry
    extends WeakReference {
        ListEntry prev = this;
        ListEntry next = this;

        public ListEntry(Object o, ReferenceQueue queue) {
            super(o, queue);
        }

        public void insert(ListEntry where) {
            this.prev = where;
            this.next = where.next;
            where.next = this;
            this.next.prev = this;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = this;
            this.prev = this;
        }
    }
}

