/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class DockerDeploymentRuntime
extends DockerApplicationRuntime {
    private final DockerAgentDeployment myAgentDeployment;
    private final DeploymentTask<DockerDeploymentConfiguration> myTask;
    private final DockerCloudConfiguration myServerConfiguration;

    public DockerDeploymentRuntime(DockerAgent agent, DeploymentTask<DockerDeploymentConfiguration> task, DeploymentLogManager logManager, ServerTaskExecutor serverTaskExecutor, AgentTaskExecutor agentTaskExecutor, DockerCloudConfiguration serverConfiguration, DockerApplicationRuntime group) throws ServerRuntimeException {
        super(serverTaskExecutor, agentTaskExecutor, task.getSource().getPresentableName(), group);
        File sourceFile;
        DockerAgentSourceType agentSourceType;
        this.myTask = task;
        this.myServerConfiguration = serverConfiguration;
        DeploymentSource source = task.getSource();
        if (source.getType() instanceof DockerFileDeploymentSourceType) {
            agentSourceType = DockerAgentSourceType.FILE;
            if (StringUtil.isEmptyOrSpaces((String)((DockerDeploymentConfiguration)task.getConfiguration()).getSourceFilePath())) {
                throw new ServerRuntimeException("Dockerfile not specified");
            }
            File dockerFile = DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(task.getProject(), (DockerDeploymentConfiguration)task.getConfiguration());
            if (dockerFile == null) {
                throw new ServerRuntimeException("Dockerfile cannot be found at " + ((DockerDeploymentConfiguration)task.getConfiguration()).getSourceFilePath());
            }
            sourceFile = dockerFile;
        } else if (source.getType() instanceof DockerImageDeploymentSourceType) {
            agentSourceType = DockerAgentSourceType.IMAGE;
            sourceFile = null;
        } else {
            agentSourceType = DockerAgentSourceType.FILE;
            sourceFile = source.getFile();
            if (sourceFile == null) {
                throw new ServerRuntimeException("Artifact file not found");
            }
        }
        final DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)task.getConfiguration();
        final String jsonFilePath = StringUtil.nullize((String)configuration.getSystemDependentJSONFilePath());
        this.myAgentDeployment = agent.createDeployment((DockerAgentDeploymentConfig)new DockerAgentDeploymentConfig.Adapter(){

            public File getFile() {
                return sourceFile;
            }

            public String getImageTag() {
                return Optional.ofNullable(configuration.getImageTag()).map(String::trim).orElse(null);
            }

            public String getContainerName() {
                return Optional.ofNullable(configuration.getContainerName()).map(String::trim).orElse(null);
            }

            public String getJSON() {
                return jsonFilePath;
            }

            public String[] getCustomCliOptions() {
                String cliOptions = configuration.getCommandLineOptions();
                return StringUtil.isEmptyOrSpaces((String)cliOptions) ? null : ParametersListUtil.parseToArray((String)cliOptions);
            }

            public String sourceType() {
                return agentSourceType.name();
            }

            public boolean isBuildImageOnly() {
                return configuration.isBuildOnly();
            }

            public String[] getEntrypoint() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getEntrypoint());
            }

            public String[] getCommand() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getCommand());
            }

            public DockerPortBinding[] getPortBindings() {
                List<DockerPortBindingImpl> portBindings = configuration.getPortBindings();
                return (DockerPortBinding[])DockerDeploymentRuntime.toObjectArrayOrNull(portBindings, DockerPortBinding.class);
            }

            public Boolean getPublishAllPorts() {
                return this.isPublishAllPorts();
            }

            public boolean isPublishAllPorts() {
                return configuration.isPublishAllPorts();
            }

            public DockerLink[] getLinks() {
                List<DockerLinkImpl> links = configuration.getLinks();
                return (DockerLink[])DockerDeploymentRuntime.toObjectArrayOrNull(links, DockerLink.class);
            }

            public DockerVolumeBinding[] getVolumeBindings() {
                List<DockerVolumeBindingImpl> binds = configuration.getVolumeBindings();
                return (DockerVolumeBinding[])DockerDeploymentRuntime.toObjectArrayOrNull(binds, DockerVolumeBinding.class);
            }

            public DockerEnvVar[] getEnvVars() {
                List<DockerEnvVarImpl> envVars = configuration.getEnvVars();
                return (DockerEnvVar[])DockerDeploymentRuntime.toObjectArrayOrNull(envVars, DockerEnvVar.class);
            }

            public DockerEnvVar[] getBuildArgs() {
                List<DockerEnvVarImpl> buildArgs = configuration.getBuildArgs();
                return (DockerEnvVar[])DockerDeploymentRuntime.toObjectArrayOrNull(buildArgs, DockerEnvVar.class);
            }
        }, (CloudAgentLoggingHandler)new CloudLoggingHandlerImpl(logManager), (DockerAgentPathMapper)new DockerAgentPathMapperImpl(this.myTask.getProject()));
    }

    private static <T> T[] toObjectArrayOrNull(Collection<? extends T> list, Class<T> clazz) {
        return list == null || list.isEmpty() ? null : ArrayUtil.toObjectArray(list, clazz);
    }

    private static String[] parseCommandLine(String commandLine) {
        return StringUtil.isEmpty((String)commandLine) ? null : ParametersListUtil.parseToArray((String)commandLine);
    }

    public DockerDeploymentConfiguration getConfiguration() {
        return (DockerDeploymentConfiguration)this.myTask.getConfiguration();
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.getAgentTaskExecutor().execute(() -> {
            this.myAgentDeployment.deploy();
            return null;
        }, (CallbackWrapper)new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                DockerDeploymentRuntime.this.setApplication((DockerAgentApplication)DockerDeploymentRuntime.this.myAgentDeployment);
                Deployment deployment = callback.succeeded((DeploymentRuntime)DockerDeploymentRuntime.this);
                DockerDeploymentRuntime.this.setDeploymentModel(deployment);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        URL apiUrl;
        Integer debugPort = ((DockerDeploymentConfiguration)this.myTask.getConfiguration()).getDebugPort();
        if (debugPort == null) {
            throw new ServerRuntimeException("Debug port not specified");
        }
        try {
            apiUrl = new URL(this.myServerConfiguration.getApiUrl());
        }
        catch (MalformedURLException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        return new JavaDebugConnectionData(apiUrl.getHost(), debugPort.intValue());
    }
}

