/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Consumer;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerApplicationRuntime
extends CloudApplicationRuntime {
    private final ServerTaskExecutor myTaskExecutor;
    private final AgentTaskExecutor myAgentTaskExecutor;
    private DockerApplicationRuntime myParent;
    private DockerAgentApplication myAgentApplication;
    private String[] myContainerNames;
    private String myImageId;
    private DeploymentStatus myStatus;
    private String myStatusText;
    private Set<String> myImageRepoTags;
    private String myImageParentId;
    private String myContainerId;

    public DockerApplicationRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String applicationName, DockerApplicationRuntime parent) {
        super(applicationName);
        this.myTaskExecutor = taskExecutor;
        this.myAgentTaskExecutor = agentTaskExecutor;
        this.myParent = parent;
    }

    protected ServerTaskExecutor getTaskExecutor() {
        return this.myTaskExecutor;
    }

    protected AgentTaskExecutor getAgentTaskExecutor() {
        return this.myAgentTaskExecutor;
    }

    protected ServerType<?> getCloudType() {
        return DockerCloudType.getInstance();
    }

    void setApplication(DockerAgentApplication agentApplication) {
        this.myAgentApplication = agentApplication;
        this.myContainerId = agentApplication.getContainerId();
        this.myContainerNames = agentApplication.getContainerNames();
        this.myImageId = agentApplication.getImageId();
        this.myImageParentId = agentApplication.getImageParentId();
        if (this.myContainerId != null) {
            this.myStatusText = agentApplication.getContainerStatus();
            this.myStatus = DockerUtil.isStartedStatus((String)this.myStatusText) ? DeploymentStatus.DEPLOYED : (DockerUtil.isStoppedStatus((String)this.myStatusText) ? DockerDeploymentStatus.STOPPED : DeploymentStatus.DEPLOYING);
        } else {
            this.myStatus = DockerDeploymentStatus.IMAGE;
            this.myImageRepoTags = new HashSet();
            this.myImageRepoTags.addAll(Arrays.asList(agentApplication.getImageRepoTags()));
        }
    }

    public String getContainerId() {
        return this.myAgentApplication != null ? this.myContainerId : null;
    }

    public String getContainerName() {
        return this.myContainerNames == null || this.myContainerNames.length == 0 ? null : new TreeSet<String>(Arrays.asList(this.myContainerNames)).first();
    }

    public String getImageId() {
        return this.myImageId;
    }

    public Set<String> getImageRepoTags() {
        return this.myImageRepoTags;
    }

    public String getImageParentId() {
        return this.myImageParentId;
    }

    @Nullable
    public String[] getContainerNames() {
        return this.myContainerNames;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @Nullable
    public String getStatusText() {
        return this.myStatusText;
    }

    @Nullable
    public CloudApplicationRuntime getParent() {
        return this.myParent;
    }

    @Nullable
    public Navigatable computeNavigatable(@NotNull Project project) {
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void setParent(DockerApplicationRuntime parent) {
        this.myParent = parent;
    }

    public void startContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.startContainer();
            }
        }.run(DeploymentStatus.DEPLOYING, "Starting", DeploymentStatus.DEPLOYED, "Started");
    }

    public void stopContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.stopContainer();
            }
        }.run(DeploymentStatus.UNDEPLOYING, "Stopping", DockerDeploymentStatus.STOPPED, null);
    }

    public void deleteContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteContainer();
            }
        }.run(DeploymentStatus.UNDEPLOYING, "Deleting", DeploymentStatus.NOT_DEPLOYED, "Deleted");
    }

    public void showLog(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.showLog(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public void inspect2Log(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.inspect2log(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public void inspect(ParameterizedRunnable<DockerAgentContainerConfig> onInspected) {
        this.getTaskExecutor().submit(() -> {
            try {
                DockerAgentContainerConfig config = (DockerAgentContainerConfig)this.getAgentTaskExecutor().execute(() -> this.myAgentApplication.inspect());
                onInspected.run((Object)config);
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    public void showProcesses(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.showProcesses(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public void attach(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.attach(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public void exec(Project project, final String command, final String logName, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.exec(loggingHandler, ParametersListUtil.parseToArray((String)command), logName);
            }
        }.perform(project, onDone);
    }

    public void deleteImage() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteImage();
            }
        }.run(DeploymentStatus.UNDEPLOYING, "Deleting", DeploymentStatus.NOT_DEPLOYED, "Deleted");
    }

    public void createContainer(Consumer<String> containerIdConsumer) {
        this.getTaskExecutor().submit(() -> {
            try {
                String containerId = (String)this.getAgentTaskExecutor().execute(() -> this.myAgentApplication.createContainer());
                containerIdConsumer.consume((Object)containerId);
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    public boolean isUndeploySupported() {
        return false;
    }

    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public void pushImage(Project project, DockerRepositoryModel repositoryModel) {
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        String qualifiedReference = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return DockerApplicationRuntime.this.myAgentApplication.pushImage(repositoryConfig, progressCallback);
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), "Pushing " + qualifiedReference, qualifiedReference + " pushed successfully");
    }

    public void updateContainer(DockerAgentContainerConfig config, Runnable onDone) {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    this.myAgentApplication.updateContainer(config);
                    return null;
                });
                onDone.run();
            }
            catch (ServerRuntimeException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeNavigatable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "undeploy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private abstract class StatusChangingTask {
        private StatusChangingTask() {
        }

        public void run(DeploymentStatus transitionStatus, String transitionStatusText, DeploymentStatus targetStatus, String targetStatusText) {
            DockerApplicationRuntime.this.getDeploymentModel().setStatus(transitionStatus, transitionStatusText);
            DockerApplicationRuntime.this.getTaskExecutor().submit(() -> {
                try {
                    DockerApplicationRuntime.this.getAgentTaskExecutor().execute(() -> {
                        this.doAgentTask();
                        return null;
                    });
                    DockerApplicationRuntime.this.myStatus = targetStatus;
                    DockerApplicationRuntime.this.myStatusText = targetStatusText;
                }
                catch (ServerRuntimeException e) {
                    DockerApplicationRuntime.this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
                }
                finally {
                    DockerApplicationRuntime.this.getDeploymentModel().setStatus(DockerApplicationRuntime.this.myStatus, DockerApplicationRuntime.this.myStatusText);
                }
            });
        }

        protected abstract void doAgentTask();
    }
}

