/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.compose.ComposeNavigatableHelper;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeStartCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeStopCliBuilder;
import com.intellij.docker.compose.cli.DockerComposeUpCliBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposeServiceRuntime
extends DockerApplicationRuntime {
    private final DeploymentStatus myStatus;
    private final String myServiceName;

    public ComposeServiceRuntime(@NotNull ComposeApplicationRuntime parentRuntime, @NotNull String serviceName) {
        if (parentRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(0);
        }
        if (serviceName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(1);
        }
        this(parentRuntime, serviceName, parentRuntime.getApplicationName() + ":" + serviceName);
    }

    protected ComposeServiceRuntime(@NotNull ComposeApplicationRuntime parentRuntime, @NotNull String serviceName, @NotNull String displayName) {
        if (parentRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(2);
        }
        if (serviceName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(3);
        }
        if (displayName == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(4);
        }
        super(parentRuntime.getTaskExecutor(), parentRuntime.getAgentTaskExecutor(), displayName, parentRuntime);
        this.myServiceName = serviceName;
        this.myStatus = new DeploymentStatus(DockerCloudType.getInstance().getIcon(), serviceName, false);
    }

    @Override
    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @Override
    public void setParent(DockerApplicationRuntime parent) {
        assert (parent == this.getParent()) : "Can't change parent : current: " + (Object)((Object)this.getParent()) + ", requested: " + (Object)((Object)parent);
    }

    @NotNull
    public final String getServiceName() {
        String string = this.myServiceName;
        if (string == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public ComposeApplicationRuntime getParent() {
        ComposeApplicationRuntime parent = (ComposeApplicationRuntime)super.getParent();
        assert (parent != null);
        ComposeApplicationRuntime composeApplicationRuntime = parent;
        if (composeApplicationRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(6);
        }
        return composeApplicationRuntime;
    }

    @NotNull
    private RemoteDockerRuntime requireRuntimeHelper() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        RemoteDockerRuntime helper = parent.getRuntimeHelper();
        if (helper == null) {
            throw new ServerRuntimeException("Can't find configuration for compose project `" + parent.getComposeProjectName() + "`");
        }
        RemoteDockerRuntime remoteDockerRuntime = helper;
        if (remoteDockerRuntime == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(7);
        }
        return remoteDockerRuntime;
    }

    public void scaleService(int number) throws ServerRuntimeException {
        number = Math.max(number, 0);
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeUpCliBuilder upCommand = ((DockerComposeUpCliBuilder)DockerComposeCliUtil.buildUpCommand(this.requireRuntimeHelper()).withFiles(parent.getComposeFilePaths())).withDetached(true).withServices(this.myServiceName).withServiceScaled(this.myServiceName, number);
        parent.executeCli(upCommand);
    }

    public void startService() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeStartCliBuilder startCommand = ((DockerComposeStartCliBuilder)DockerComposeCliUtil.buildStartCommand(this.requireRuntimeHelper()).withFiles(parent.getComposeFilePaths())).withServices(this.myServiceName);
        parent.executeCli(startCommand);
    }

    public void stopService() throws ServerRuntimeException {
        ComposeApplicationRuntime parent = this.getParent();
        DockerComposeStopCliBuilder stopCommand = DockerComposeCliUtil.buildStopCommand(this.requireRuntimeHelper()).withServices(this.myServiceName);
        parent.executeCli(stopCommand);
    }

    @Override
    @Nullable
    public Navigatable computeNavigatable(@NotNull Project project) {
        if (project == null) {
            ComposeServiceRuntime.$$$reportNull$$$0(8);
        }
        OpenFileDescriptor openComposeFile = this.getParent().computeNavigatable(project);
        ComposeNavigatableHelper helper = ComposeNavigatableHelper.getInstance();
        if (openComposeFile == null || helper == null) {
            return openComposeFile;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(openComposeFile.getFile());
        Navigatable result = psiFile == null ? null : helper.findNavigatableComposeService(psiFile, this.getServiceName());
        return result;
    }

    public CloudNotifier getCloudNotifier() {
        return ComposeApplicationRuntime.COMPOSE_NOTIFIER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRuntime";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeServiceRuntime";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeServiceRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRuntimeHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

