/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.compose.cli.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import icons.DockerIcons;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComposeApplicationRuntime
extends DockerApplicationRuntime {
    public static final CloudNotifier COMPOSE_NOTIFIER = new CloudNotifier("docker-compose");
    private final List<ComposeServiceRuntime> myServiceRuntimes;
    private final List<ComposeServiceRuntime> myServiceRuntimesRO;
    private final DeploymentStatus myStatus;

    public ComposeApplicationRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, @NotNull String applicationName) {
        if (applicationName == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(0);
        }
        super(taskExecutor, agentTaskExecutor, applicationName, null);
        this.myServiceRuntimes = new ArrayList<ComposeServiceRuntime>();
        this.myServiceRuntimesRO = Collections.unmodifiableList(this.myServiceRuntimes);
        this.myStatus = new DeploymentStatus(DockerIcons.ContainersList_2, "", false);
    }

    @Override
    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatus;
    }

    @NotNull
    public abstract String getComposeProjectName();

    public CloudNotifier getCloudNotifier() {
        return COMPOSE_NOTIFIER;
    }

    @Deprecated
    protected final List<ComposeServiceRuntime> getServiceRuntimes() {
        return this.myServiceRuntimesRO;
    }

    @Nullable
    protected abstract RemoteDockerRuntime getRuntimeHelper() throws ServerRuntimeException;

    @NotNull
    public final RemoteDockerRuntime requireRuntimeHelper() throws ServerRuntimeException {
        RemoteDockerRuntime result = this.getRuntimeHelper();
        if (result == null) {
            throw new ServerRuntimeException("Can't find configuration for compose project `" + this.getComposeProjectName() + "`");
        }
        RemoteDockerRuntime remoteDockerRuntime = result;
        if (remoteDockerRuntime == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(1);
        }
        return remoteDockerRuntime;
    }

    @NotNull
    public abstract CompletableFuture<Void> executeCli(@NotNull AbstractDockerComposeCmdCliBuilder<?> var1) throws ServerRuntimeException;

    @NotNull
    protected abstract List<File> getComposeFiles();

    @Nullable
    public OpenFileDescriptor computeNavigatable(@NotNull Project project) {
        List<File> composeFiles;
        if (project == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(2);
        }
        if ((composeFiles = this.getComposeFiles()).isEmpty()) {
            return null;
        }
        File mainFile = composeFiles.get(0);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(mainFile);
        return virtualFile == null ? null : new OpenFileDescriptor(project, virtualFile, 0);
    }

    @NotNull
    public final List<Path> getComposeFilePaths() {
        List list = ContainerUtil.map(this.getComposeFiles(), File::toPath);
        if (list == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public File getComposeProjectFolder() {
        List<File> allComposes = this.getComposeFiles();
        return allComposes.isEmpty() ? null : allComposes.get(0).getParentFile();
    }

    void addServiceRuntime(@NotNull ComposeServiceRuntime service) {
        if (service == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(4);
        }
        assert (service.getParent() == this);
        this.myServiceRuntimes.add(service);
    }

    @NotNull
    ComposeServiceRuntime findOrCreateService(@NotNull String serviceName) {
        if (serviceName == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(5);
        }
        for (ComposeServiceRuntime next : this.getServiceRuntimes()) {
            if (!serviceName.equals(next.getServiceName())) continue;
            ComposeServiceRuntime composeServiceRuntime = next;
            if (composeServiceRuntime == null) {
                ComposeApplicationRuntime.$$$reportNull$$$0(6);
            }
            return composeServiceRuntime;
        }
        ComposeServiceRuntime result = new ComposeServiceRuntime(this, serviceName);
        this.addServiceRuntime(result);
        ComposeServiceRuntime composeServiceRuntime = result;
        if (composeServiceRuntime == null) {
            ComposeApplicationRuntime.$$$reportNull$$$0(7);
        }
        return composeServiceRuntime;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/ComposeApplicationRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/ComposeApplicationRuntime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRuntimeHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComposeFilePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addServiceRuntime";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

