/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.InputStreamConsumer;
import com.intellij.docker.remote.run.runtime.RemoteDockerCloudLoggingHandler;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.TarCompressionUtil;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDockerApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(RemoteDockerApplicationRuntime.class);
    private final RemoteDockerRuntime myRuntime;
    private final RemoteDockerCloudLoggingHandler myLoggingHandler;
    private DockerAgentApplication myApplication;

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime, DockerAgentApplication application) {
        this(runtime);
        this.myApplication = application;
    }

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime) {
        this.myRuntime = runtime;
        this.myLoggingHandler = new RemoteDockerCloudLoggingHandler();
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentApplication application) {
        return new RemoteDockerApplicationRuntime(runtime, application);
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentDeploymentConfig config) throws ServerRuntimeException {
        RemoteDockerApplicationRuntime result = new RemoteDockerApplicationRuntime(runtime);
        result.create(config, runtime.getProject());
        return result;
    }

    public void start() throws ServerRuntimeException {
        this.executeAgentTask(() -> {
            this.myApplication.startContainer();
            return null;
        });
    }

    public void attach() throws ServerRuntimeException {
        this.executeAgentTask(() -> {
            this.myApplication.attach((CloudAgentLoggingHandler)this.myLoggingHandler);
            return null;
        });
    }

    public void startAndAttach() throws ServerRuntimeException {
        this.attach();
        this.start();
    }

    private DockerAgentDeployment create(DockerAgentDeploymentConfig config, Project project) throws ServerRuntimeException {
        Object pathMapper = project == null ? new DockerAgentPathMapper(){

            public String expandPath(String path) {
                return path;
            }

            public String collapsePath(String path) {
                return path;
            }
        } : new DockerAgentPathMapperImpl(project);
        DockerAgentDeployment deployment = (DockerAgentDeployment)this.executeAgentTask(() -> this.lambda$create$2(config, (DockerAgentPathMapper)pathMapper));
        this.myApplication = deployment;
        this.executeAgentTask(() -> {
            deployment.deploy();
            return null;
        });
        return deployment;
    }

    public ProcessOutput startAndGetOutput() throws ServerRuntimeException, IOException {
        try {
            this.startAndAttach();
            ProcessOutput processOutput = this.wait4AndGetOutput();
            return processOutput;
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    public void removeContainer() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteContainer();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public void removeImage() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteImage();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public void removeContainerWithVolumes() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteContainerWithVolumes();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    private void stopContainerImmediate() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.stopContainerImmediate(arg_0 -> ((Logger)LOG).info(arg_0));
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        return this.myRuntime.executeAgentTask(computable);
    }

    public InputStream getStdout() {
        return this.myLoggingHandler.getTerminalOutput();
    }

    public InputStream getStderr() {
        return this.myLoggingHandler.getStderr();
    }

    public OutputStream getStdin() {
        return this.myLoggingHandler.getTerminalInput();
    }

    public void wait4terminal() {
        this.myLoggingHandler.wait4();
    }

    public int wait4Exit() throws ServerRuntimeException {
        return (Integer)this.executeAgentTask(() -> this.myApplication.waitForExit());
    }

    public ProcessOutput wait4AndGetOutput() throws IOException, ServerRuntimeException {
        ProcessOutput result = new ProcessOutput();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        InputStreamConsumer stdoutConsumer = InputStreamConsumer.consume(this.myLoggingHandler.getTerminalOutput(), indicator);
        InputStreamConsumer stderrConsumer = InputStreamConsumer.consume(this.myLoggingHandler.getStderr(), indicator);
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteDockerApplicationRuntime.this.stopContainerImmediate());
                }
            });
        }
        int exitCode = this.wait4Exit();
        result.setExitCode(exitCode);
        result.appendStdout(stdoutConsumer.wait4Result());
        result.appendStderr(stderrConsumer.wait4Result());
        return result;
    }

    public DockerAgentContainerInspection inspect() throws ServerRuntimeException {
        return (DockerAgentContainerInspection)this.executeAgentTask(() -> this.myApplication.inspect());
    }

    public RemoteDockerRuntime getDockerRuntime() {
        return this.myRuntime;
    }

    public DockerAgent getAgent() {
        return this.myRuntime.getAgent();
    }

    public DockerAgentApplication getAgentApplication() {
        return this.myApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDirectoryAndRemove(String sourceDirPath, File targetDir, Map<String, String> remoteToLocalPathName, String machineName) throws IOException, ServerRuntimeException {
        try {
            this.downloadDirectory(sourceDirPath, targetDir, remoteToLocalPathName, machineName);
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    private static void copyTarEntry(TarArchiveInputStream tarInputStream, TarArchiveEntry tarEntry, File targetDir, String localPathName) throws IOException {
        if (SystemInfo.isWindows && localPathName.contains("\\")) {
            LOG.info("Extraction path '" + localPathName + "' contains backslashes, which will be treated as path separators");
        }
        if (tarEntry.isFile()) {
            RemoteDockerApplicationRuntime.copyStreamToFile((InputStream)tarInputStream, new File(targetDir, localPathName));
        } else if (tarEntry.isDirectory()) {
            new File(targetDir, localPathName).mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void downloadDirectory(@NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName) throws IOException, ServerRuntimeException {
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        File tarFile = FileUtil.createTempFile((String)String.valueOf(this.myApplication.getContainerId().hashCode()), (String)".download.tar");
        try (FileOutputStream tarOutputStream = new FileOutputStream(tarFile);){
            LOG.debug("Downloading '", new Object[]{resourcePath, "' resource from Docker container '", this.myApplication.getContainerId(), "' created at Docker machine ", "'", machineName, "' to '", tarFile.getAbsolutePath(), "'"});
            try (InputStream requestInputStream = (InputStream)this.executeAgentTask(() -> {
                if (resourcePath == null) {
                    RemoteDockerApplicationRuntime.$$$reportNull$$$0(13);
                }
                return this.myApplication.copyArchiveFromContainer(resourcePath);
            });){
                long size = IOUtils.copy((InputStream)requestInputStream, (OutputStream)tarOutputStream);
                LOG.debug("Downloaded ", new Object[]{size, " bytes from container '", this.myApplication.getContainerId(), "' to '", tarFile.getAbsolutePath(), "'"});
            }
        }
        try {
            RemoteDockerApplicationRuntime.extractTar(tarFile, resourcePath, targetFile, remoteToLocalPathName);
            if (tarFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tarFile.delete()) throw throwable;
            LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile.getPath(), "'"});
            throw throwable;
        }
        LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile.getPath(), "'"});
    }

    private static void extractTar(@NotNull File tarFile, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName) throws IOException {
        if (tarFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        LOG.debug("Extracting '", new Object[]{tarFile.getAbsoluteFile(), "' to '", targetFile.getPath(), "'"});
        RemoteDockerApplicationRuntime.extractTar(new BufferedInputStream(new FileInputStream(tarFile)), resourcePath, targetFile, remoteToLocalPathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName) throws IOException {
        if (inputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        String parentSourceDirPath = PathUtil.getParentPath((String)resourcePath);
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.uncompressStream(inputStream));){
            TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
            while (tarEntry != null) {
                if ((tarEntry.isFile() || tarEntry.isDirectory()) && StringUtil.isNotEmpty((String)tarEntry.getName())) {
                    if (remoteToLocalPathName == null) {
                        String localPathName = RemoteDockerApplicationRuntime.replacePathPrefix(tarEntry.getName(), targetFile.getName());
                        RemoteDockerApplicationRuntime.copyTarEntry(tarInputStream, tarEntry, targetFile.getParentFile(), localPathName);
                    } else {
                        String remotePathName = FileUtil.toCanonicalPath((String)StringUtil.join((String[])new String[]{parentSourceDirPath, tarEntry.getName()}, (String)"/"), (char)'/');
                        String localPathName = remoteToLocalPathName.get(remotePathName);
                        if (localPathName != null) {
                            RemoteDockerApplicationRuntime.copyTarEntry(tarInputStream, tarEntry, targetFile, localPathName);
                        } else {
                            LOG.debug("Remote file '" + remotePathName + "' skipped");
                        }
                    }
                }
                tarEntry = tarInputStream.getNextTarEntry();
            }
        }
    }

    @NotNull
    static String replacePathPrefix(@NotNull String path, @NotNull String newPrefix) {
        int index;
        if (path == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        if (newPrefix == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        if ((index = path.indexOf(47)) == -1) {
            index = path.length();
        }
        String string = newPrefix + path.substring(index);
        if (string == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static void copyStreamToFile(@NotNull InputStream inputStream, @NotNull File outputFile) throws IOException {
        if (inputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        if (outputFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        if (outputFile.getParentFile() != null && !outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            LOG.warn("Failed to create parent directories for file '" + outputFile + "' it will be skipped");
        } else {
            try (FileOutputStream entryOutputStream = new FileOutputStream(outputFile);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)entryOutputStream);
            }
        }
    }

    public String getContainerId() {
        return this.getAgentApplication().getContainerId();
    }

    public String getContainerName() {
        return this.getAgentApplication().getContainerName();
    }

    public static RemoteDockerApplicationRuntime createWithImageInitialization(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfigImpl config, ImageInitializer initializer) throws ServerRuntimeException, IOException {
        try {
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config);
        }
        catch (WrappedNotFoundException e) {
            LOG.debug("Image {", new Object[]{config.getImageTag(), "} has not been found", e});
            initializer.init();
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config);
        }
    }

    public static RemoteDockerApplicationRuntime createWithPullImage(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfigImpl config) throws IOException, ServerRuntimeException {
        return RemoteDockerApplicationRuntime.createWithImageInitialization(dockerRuntime, config, () -> dockerRuntime.pullImage(config.getImageTag()));
    }

    private /* synthetic */ DockerAgentDeployment lambda$create$2(DockerAgentDeploymentConfig config, DockerAgentPathMapper pathMapper) {
        return this.getAgent().createDeployment(config, (CloudAgentLoggingHandler)this.myLoggingHandler, pathMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarFile";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/RemoteDockerApplicationRuntime";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/RemoteDockerApplicationRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "downloadDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractTar";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replacePathPrefix";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamToFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$downloadDirectory$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ImageInitializer {
        public void init() throws IOException, ServerRuntimeException;
    }
}

