/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputStreamConsumer
implements Callable<String> {
    @NotNull
    private final CountDownLatch myCountDownLatch;
    @NotNull
    private final InputStream myInputStream;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final StringBuilder myResultBuilder;

    public InputStreamConsumer(@NotNull InputStream stream, @Nullable ProgressIndicator indicator) {
        if (stream == null) {
            InputStreamConsumer.$$$reportNull$$$0(0);
        }
        this.myCountDownLatch = new CountDownLatch(1);
        this.myResultBuilder = new StringBuilder();
        this.myInputStream = stream;
        this.myProgressIndicator = indicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.myInputStream, "UTF-8"));
            String line = reader.readLine();
            boolean firstLine = true;
            while (line != null) {
                if (!firstLine) {
                    this.myResultBuilder.append("\n");
                }
                firstLine = false;
                this.myResultBuilder.append(line);
                this.updateIndicatorText(line);
                line = reader.readLine();
            }
            String string = this.myResultBuilder.toString();
            return string;
        }
        finally {
            this.myCountDownLatch.countDown();
        }
    }

    private void updateIndicatorText(@NotNull CharSequence lastLineRead) {
        if (lastLineRead == null) {
            InputStreamConsumer.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((CharSequence)lastLineRead) || Character.isWhitespace(lastLineRead.charAt(0))) {
            return;
        }
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2(lastLineRead.toString());
        }
    }

    public String wait4Result() throws IOException {
        try {
            this.myCountDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return this.myResultBuilder.toString();
    }

    @NotNull
    public static InputStreamConsumer consume(@NotNull InputStream stream, @Nullable ProgressIndicator progressIndicator) {
        if (stream == null) {
            InputStreamConsumer.$$$reportNull$$$0(2);
        }
        InputStreamConsumer consumer = new InputStreamConsumer(stream, progressIndicator);
        ApplicationManager.getApplication().executeOnPooledThread((Callable)consumer);
        InputStreamConsumer inputStreamConsumer = consumer;
        if (inputStreamConsumer == null) {
            InputStreamConsumer.$$$reportNull$$$0(3);
        }
        return inputStreamConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastLineRead";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/InputStreamConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/InputStreamConsumer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "consume";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateIndicatorText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

