/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryConfigurable;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRegistryListConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable {
    @NonNls
    public static final String ID = "DockerRegistry";
    private final DockerRegistryManager myRegistryManager;

    public DockerRegistryListConfigurable(@NotNull DockerRegistryManager manager) {
        if (manager == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(0);
        }
        this.myRegistryManager = manager;
        this.initTree();
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "To configure Docker Registry, click '+'";
    }

    @Nls
    public String getDisplayName() {
        return "Docker Registry";
    }

    public void reset() {
        this.myRoot.removeAllChildren();
        for (DockerRegistry registry : this.myRegistryManager.getRegistries()) {
            this.addRegistryNode(registry, false);
        }
        super.reset();
    }

    private MasterDetailsComponent.MyNode addRegistryNode(DockerRegistry registry, boolean isNew) {
        MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new DockerRegistryConfigurable(registry, this.TREE_UPDATER, isNew));
        this.addNode(node, this.myRoot);
        return node;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            DockerRegistryListConfigurable.$$$reportNull$$$0(1);
        }
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> ((SpeedSearchSupply)ObjectUtils.assertNotNull((Object)SpeedSearchSupply.getSupply((JComponent)this.myTree, (boolean)true))).findAndSelectElement(option);
    }

    protected void initTree() {
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName(), true);
    }

    protected void processRemovedItems() {
        HashSet<Object> registries = new HashSet<Object>();
        for (NamedConfigurable<DockerRegistry> configurable : this.getConfiguredRegistries()) {
            registries.add(configurable.getEditableObject());
        }
        ArrayList<DockerRegistry> toDelete = new ArrayList<DockerRegistry>();
        for (DockerRegistry registry : this.myRegistryManager.getRegistries()) {
            if (registries.contains((Object)registry)) continue;
            toDelete.add(registry);
        }
        for (DockerRegistry registry : toDelete) {
            this.myRegistryManager.removeRegistry(registry);
        }
    }

    public void apply() throws ConfigurationException {
        super.apply();
        HashSet<DockerRegistry> registries = new HashSet<DockerRegistry>(this.myRegistryManager.getRegistries());
        for (NamedConfigurable<DockerRegistry> configurable : this.getConfiguredRegistries()) {
            DockerRegistry registry = (DockerRegistry)((Object)configurable.getEditableObject());
            registry.setName(configurable.getDisplayName());
            if (registries.contains((Object)registry)) continue;
            this.myRegistryManager.addRegistry(registry);
        }
    }

    public String getHelpTopic() {
        return "docker.registry";
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        actions.add((AnAction)new AddRegistryAction());
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions;
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    private List<NamedConfigurable<DockerRegistry>> getConfiguredRegistries() {
        ArrayList<NamedConfigurable<DockerRegistry>> configurables = new ArrayList<NamedConfigurable<DockerRegistry>>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i);
            configurables.add((NamedConfigurable<DockerRegistry>)node.getConfigurable());
        }
        return configurables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/registry/DockerRegistryListConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/registry/DockerRegistryListConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AddRegistryAction
    extends DumbAwareAction {
        private AddRegistryAction() {
            super("Add", null, IconUtil.getAddIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            String name = UniqueNameGenerator.generateUniqueName((String)"Docker Registry", s -> {
                for (NamedConfigurable configurable : DockerRegistryListConfigurable.this.getConfiguredRegistries()) {
                    if (!configurable.getDisplayName().equals(s)) continue;
                    return false;
                }
                return true;
            });
            MasterDetailsComponent.MyNode node = DockerRegistryListConfigurable.this.addRegistryNode(new DockerRegistry().withName(name), true);
            DockerRegistryListConfigurable.this.selectNodeInTree((DefaultMutableTreeNode)node);
        }
    }
}

