/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.intellij.docker.machine.DockerMachine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineUtil {
    public static final String DEFAULT_DOCKER_MACHINE_EXECUTABLE = "docker-machine";
    private static final String DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN = "docker-machine.exe";
    private static final String USR_LOCAL_BIN_PATH = "/usr/local/bin";
    private static final String PROGRAM_FILES_WIN_ENV = "ProgramFiles";
    private static final String PROGRAM_FILES_X86_WIN_ENV = "ProgramFiles(x86)";
    private static final String DOCKER_TOOLBOX_WIN_FOLDER = "Docker Toolbox";
    private static final Pattern DOCKER_MACHINE_VERSION_PATTERN = Pattern.compile("version\\s+(?<version>[\\d.\\w]+)");

    private DockerMachineUtil() {
    }

    @NotNull
    public static String getDefaultDockerMachineExecutable() {
        if (DEFAULT_DOCKER_MACHINE_EXECUTABLE == null) {
            DockerMachineUtil.$$$reportNull$$$0(0);
        }
        return DEFAULT_DOCKER_MACHINE_EXECUTABLE;
    }

    @NotNull
    public static Optional<String> tryFindDockerMachineExecutable() {
        Optional<String> fromPath = Optional.ofNullable(PathEnvironmentVariableUtil.findInPath((String)DEFAULT_DOCKER_MACHINE_EXECUTABLE)).map(File::getAbsolutePath).filter(DockerMachineUtil::checkValidExecutable);
        if (fromPath.isPresent()) {
            Optional<String> optional = fromPath;
            if (optional == null) {
                DockerMachineUtil.$$$reportNull$$$0(1);
            }
            return optional;
        }
        if (DockerMachineUtil.checkValidExecutable(DEFAULT_DOCKER_MACHINE_EXECUTABLE)) {
            Optional<String> optional = Optional.of(DEFAULT_DOCKER_MACHINE_EXECUTABLE);
            if (optional == null) {
                DockerMachineUtil.$$$reportNull$$$0(2);
            }
            return optional;
        }
        if (SystemInfo.isMac || SystemInfo.isUnix) {
            String pathname = FileUtil.join((String[])new String[]{USR_LOCAL_BIN_PATH, DEFAULT_DOCKER_MACHINE_EXECUTABLE});
            if (DockerMachineUtil.checkExists(pathname)) {
                Optional<String> optional = Optional.of(pathname);
                if (optional == null) {
                    DockerMachineUtil.$$$reportNull$$$0(3);
                }
                return optional;
            }
        } else if (SystemInfo.isWindows) {
            String pathname;
            String pathname2;
            String programFiles = System.getenv(PROGRAM_FILES_WIN_ENV);
            if (programFiles != null && DockerMachineUtil.checkExists(pathname2 = FileUtil.join((String[])new String[]{programFiles, DOCKER_TOOLBOX_WIN_FOLDER, DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN}))) {
                Optional<String> optional = Optional.of(pathname2);
                if (optional == null) {
                    DockerMachineUtil.$$$reportNull$$$0(4);
                }
                return optional;
            }
            String programFilesX86 = System.getenv(PROGRAM_FILES_X86_WIN_ENV);
            if (programFilesX86 != null && DockerMachineUtil.checkExists(pathname = FileUtil.join((String[])new String[]{programFilesX86, DOCKER_TOOLBOX_WIN_FOLDER, DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN}))) {
                Optional<String> optional = Optional.of(pathname);
                if (optional == null) {
                    DockerMachineUtil.$$$reportNull$$$0(5);
                }
                return optional;
            }
        }
        Optional<String> optional = Optional.empty();
        if (optional == null) {
            DockerMachineUtil.$$$reportNull$$$0(6);
        }
        return optional;
    }

    private static boolean checkValidExecutable(@NotNull String pathname) {
        if (pathname == null) {
            DockerMachineUtil.$$$reportNull$$$0(7);
        }
        try {
            DockerMachine.getDockerMachine(pathname).version();
            return true;
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    private static boolean checkExists(@NotNull String pathname) {
        File file;
        if (pathname == null) {
            DockerMachineUtil.$$$reportNull$$$0(8);
        }
        return (file = new File(pathname)).exists() && file.canExecute();
    }

    public static void startMachineWithProgressIndicator(@Nullable Project project, final @NotNull String machineName) {
        if (machineName == null) {
            DockerMachineUtil.$$$reportNull$$$0(9);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Void, RuntimeException>(){

            public Void compute() {
                ProgressManager.progress((String)("Starting Docker Machine '" + machineName + "'"));
                DockerMachine.currentDockerMachine().start(machineName);
                return null;
            }
        }, "Starting Docker Machine", true, project);
    }

    @Nullable
    public static String getVersion(@Nullable String stdout) {
        if (stdout == null) {
            return null;
        }
        Matcher matcher = DOCKER_MACHINE_VERSION_PATTERN.matcher(stdout);
        return matcher.find() ? matcher.group("version") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/machine/DockerMachineUtil";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathname";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "machineName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultDockerMachineExecutable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFindDockerMachineExecutable";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/machine/DockerMachineUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkValidExecutable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkExists";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startMachineWithProgressIndicator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

